/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import soot.toolkits.scalar.AbstractBoundedFlowSet;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.FlowUniverse;
import soot.toolkits.scalar.ObjectIntMapper;

public class ArrayPackedSet<T>
extends AbstractBoundedFlowSet<T> {
    ObjectIntMapper<T> map;
    BitSet bits;

    public ArrayPackedSet(FlowUniverse<T> universe) {
        this(new ObjectIntMapper<T>(universe));
    }

    ArrayPackedSet(ObjectIntMapper<T> map) {
        this(map, new BitSet());
    }

    ArrayPackedSet(ObjectIntMapper<T> map, BitSet bits) {
        this.map = map;
        this.bits = bits;
    }

    private boolean sameType(Object flowSet) {
        return flowSet instanceof ArrayPackedSet && ((ArrayPackedSet)flowSet).map == this.map;
    }

    @Override
    public ArrayPackedSet<T> clone() {
        return new ArrayPackedSet<T>(this.map, (BitSet)this.bits.clone());
    }

    @Override
    public FlowSet<T> emptySet() {
        return new ArrayPackedSet<T>(this.map);
    }

    @Override
    public int size() {
        return this.bits.cardinality();
    }

    @Override
    public boolean isEmpty() {
        return this.bits.isEmpty();
    }

    @Override
    public void clear() {
        this.bits.clear();
    }

    public List<T> toList(int lowInclusive, int highInclusive) {
        int highExclusive = highInclusive + 1;
        if (lowInclusive < 0) {
            throw new IllegalArgumentException();
        }
        if (lowInclusive > highInclusive) {
            throw new IllegalArgumentException();
        }
        if (lowInclusive == highInclusive) {
            return this.bits.get(lowInclusive) ? Collections.singletonList(this.map.getObject(lowInclusive)) : Collections.emptyList();
        }
        int i = this.bits.nextSetBit(lowInclusive);
        if (i < 0 || i >= highExclusive) {
            return Collections.emptyList();
        }
        LinkedList<T> elements = new LinkedList<T>();
        do {
            int endOfRun = Math.min(highExclusive, this.bits.nextClearBit(i + 1));
            do {
                elements.add(this.map.getObject(i++));
            } while (i < endOfRun);
            if (i < highExclusive) continue;
            return elements;
        } while ((i = this.bits.nextSetBit(i + 1)) >= 0 && i < highExclusive);
        return elements;
    }

    @Override
    public List<T> toList() {
        int i = this.bits.nextSetBit(0);
        if (i == -1) {
            return Collections.emptyList();
        }
        ArrayList<T> elements = new ArrayList<T>(this.bits.cardinality());
        while (i >= 0) {
            int endOfRun = this.bits.nextClearBit(i + 1);
            do {
                elements.add(this.map.getObject(i++));
            } while (i < endOfRun);
            i = this.bits.nextSetBit(i + 1);
        }
        return elements;
    }

    @Override
    public void add(T obj) {
        this.bits.set(this.map.getInt(obj));
    }

    @Override
    public void complement(FlowSet<T> destFlow) {
        if (this.sameType(destFlow)) {
            ArrayPackedSet dest = (ArrayPackedSet)destFlow;
            if (this != dest) {
                dest.bits.clear();
                dest.bits.or(this.bits);
            }
            dest.bits.flip(0, dest.bits.size());
        } else {
            super.complement(destFlow);
        }
    }

    @Override
    public void remove(T obj) {
        this.bits.clear(this.map.getInt(obj));
    }

    @Override
    public boolean isSubSet(FlowSet<T> other) {
        if (other == this) {
            return true;
        }
        if (this.sameType(other)) {
            ArrayPackedSet o = (ArrayPackedSet)other;
            BitSet tmp = (BitSet)o.bits.clone();
            tmp.andNot(this.bits);
            return tmp.isEmpty();
        }
        return super.isSubSet(other);
    }

    @Override
    public void union(FlowSet<T> otherFlow, FlowSet<T> destFlow) {
        if (this.sameType(otherFlow) && this.sameType(destFlow)) {
            ArrayPackedSet other = (ArrayPackedSet)otherFlow;
            ArrayPackedSet dest = (ArrayPackedSet)destFlow;
            if (!(other instanceof ArrayPackedSet)) {
                throw new RuntimeException("Incompatible other set for union");
            }
            if (this != dest) {
                dest.bits.clear();
                dest.bits.or(this.bits);
            }
            dest.bits.or(other.bits);
        } else {
            super.union(otherFlow, destFlow);
        }
    }

    @Override
    public void difference(FlowSet<T> otherFlow, FlowSet<T> destFlow) {
        if (this.sameType(otherFlow) && this.sameType(destFlow)) {
            if (!(otherFlow instanceof ArrayPackedSet)) {
                throw new RuntimeException("Incompatible other set for union");
            }
            ArrayPackedSet other = (ArrayPackedSet)otherFlow;
            ArrayPackedSet dest = (ArrayPackedSet)destFlow;
            if (this != dest) {
                dest.bits.clear();
                dest.bits.or(this.bits);
            }
            dest.bits.andNot(other.bits);
        } else {
            super.difference(otherFlow, destFlow);
        }
    }

    @Override
    public void intersection(FlowSet<T> otherFlow, FlowSet<T> destFlow) {
        if (this.sameType(otherFlow) && this.sameType(destFlow)) {
            if (!(otherFlow instanceof ArrayPackedSet)) {
                throw new RuntimeException("Incompatible other set for union");
            }
            ArrayPackedSet other = (ArrayPackedSet)otherFlow;
            ArrayPackedSet dest = (ArrayPackedSet)destFlow;
            if (this != dest) {
                dest.bits.clear();
                dest.bits.or(this.bits);
            }
            dest.bits.and(other.bits);
        } else {
            super.intersection(otherFlow, destFlow);
        }
    }

    @Override
    public boolean contains(T obj) {
        if (!this.map.contains(obj)) {
            return false;
        }
        return this.bits.get(this.map.getInt(obj));
    }

    @Override
    public boolean equals(Object otherFlow) {
        if (this.sameType(otherFlow)) {
            return this.bits.equals(((ArrayPackedSet)otherFlow).bits);
        }
        return super.equals(otherFlow);
    }

    @Override
    public void copy(FlowSet<T> destFlow) {
        if (this == destFlow) {
            return;
        }
        if (this.sameType(destFlow)) {
            ArrayPackedSet dest = (ArrayPackedSet)destFlow;
            dest.bits.clear();
            dest.bits.or(this.bits);
        } else {
            super.copy(destFlow);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int i;
            T t;
            {
                this.i = ArrayPackedSet.this.bits.nextSetBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.i >= 0;
            }

            @Override
            public T next() {
                if (this.i < 0) {
                    throw new NoSuchElementException();
                }
                this.t = ArrayPackedSet.this.map.getObject(this.i);
                this.i = ArrayPackedSet.this.bits.nextSetBit(this.i + 1);
                return this.t;
            }

            @Override
            public void remove() {
                if (this.t == null) {
                    throw new IllegalStateException();
                }
                ArrayPackedSet.this.bits.clear(this.i);
                this.t = null;
            }
        };
    }
}

