/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import soot.toolkits.scalar.AbstractFlowSet;
import soot.toolkits.scalar.FlowSet;

public class ArraySparseSet<T>
extends AbstractFlowSet<T> {
    protected static final int DEFAULT_SIZE = 8;
    protected int numElements;
    protected int maxElements;
    protected T[] elements;

    public ArraySparseSet() {
        this.maxElements = 8;
        this.elements = new Object[8];
        this.numElements = 0;
    }

    private ArraySparseSet(ArraySparseSet<T> other) {
        this.numElements = other.numElements;
        this.maxElements = other.maxElements;
        this.elements = (Object[])other.elements.clone();
    }

    private boolean sameType(Object flowSet) {
        return flowSet instanceof ArraySparseSet;
    }

    @Override
    public ArraySparseSet<T> clone() {
        return new ArraySparseSet<T>(this);
    }

    @Override
    public FlowSet<T> emptySet() {
        return new ArraySparseSet<T>();
    }

    @Override
    public void clear() {
        this.numElements = 0;
        Arrays.fill(this.elements, null);
    }

    @Override
    public int size() {
        return this.numElements;
    }

    @Override
    public boolean isEmpty() {
        return this.numElements == 0;
    }

    @Override
    public List<T> toList() {
        return Arrays.asList(Arrays.copyOf(this.elements, this.numElements));
    }

    @Override
    public void add(T e) {
        if (!this.contains((Object)e)) {
            if (this.numElements == this.maxElements) {
                this.doubleCapacity();
            }
            this.elements[this.numElements++] = e;
        }
    }

    private void doubleCapacity() {
        int newSize = this.maxElements * 2;
        Object[] newElements = new Object[newSize];
        System.arraycopy(this.elements, 0, newElements, 0, this.numElements);
        this.elements = newElements;
        this.maxElements = newSize;
    }

    @Override
    public void remove(Object obj) {
        int i = 0;
        while (i < this.numElements) {
            if (this.elements[i].equals(obj)) {
                this.remove(i);
                break;
            }
            ++i;
        }
    }

    @Override
    public void remove(int idx) {
        --this.numElements;
        this.elements[idx] = this.elements[this.numElements];
        this.elements[this.numElements] = null;
    }

    @Override
    public void union(FlowSet<T> otherFlow, FlowSet<T> destFlow) {
        if (this.sameType(otherFlow) && this.sameType(destFlow)) {
            ArraySparseSet dest = (ArraySparseSet)destFlow;
            ArraySparseSet other = (ArraySparseSet)otherFlow;
            if (dest == other) {
                int i = 0;
                while (i < this.numElements) {
                    dest.add(this.elements[i]);
                    ++i;
                }
            } else {
                if (this != dest) {
                    this.copy(dest);
                }
                int i = 0;
                while (i < other.numElements) {
                    dest.add(other.elements[i]);
                    ++i;
                }
            }
        } else {
            super.union(otherFlow, destFlow);
        }
    }

    @Override
    public void intersection(FlowSet<T> otherFlow, FlowSet<T> destFlow) {
        if (this.sameType(otherFlow) && this.sameType(destFlow)) {
            ArraySparseSet workingSet;
            ArraySparseSet dest = (ArraySparseSet)destFlow;
            ArraySparseSet other = (ArraySparseSet)otherFlow;
            if (dest == other || dest == this) {
                workingSet = new ArraySparseSet();
            } else {
                workingSet = dest;
                workingSet.clear();
            }
            int i = 0;
            while (i < this.numElements) {
                if (other.contains((Object)this.elements[i])) {
                    workingSet.add(this.elements[i]);
                }
                ++i;
            }
            if (workingSet != dest) {
                workingSet.copy(dest);
            }
        } else {
            super.intersection(otherFlow, destFlow);
        }
    }

    @Override
    public void difference(FlowSet<T> otherFlow, FlowSet<T> destFlow) {
        if (this.sameType(otherFlow) && this.sameType(destFlow)) {
            ArraySparseSet workingSet;
            ArraySparseSet dest = (ArraySparseSet)destFlow;
            ArraySparseSet other = (ArraySparseSet)otherFlow;
            if (dest == other || dest == this) {
                workingSet = new ArraySparseSet();
            } else {
                workingSet = dest;
                workingSet.clear();
            }
            int i = 0;
            while (i < this.numElements) {
                if (!other.contains((Object)this.elements[i])) {
                    workingSet.add(this.elements[i]);
                }
                ++i;
            }
            if (workingSet != dest) {
                workingSet.copy(dest);
            }
        } else {
            super.difference(otherFlow, destFlow);
        }
    }

    @Override
    @Deprecated
    public boolean contains(Object obj) {
        int i = 0;
        while (i < this.numElements) {
            if (this.elements[i].equals(obj)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean equals(Object otherFlow) {
        if (this.sameType(otherFlow)) {
            ArraySparseSet other = (ArraySparseSet)otherFlow;
            if (other.numElements != this.numElements) {
                return false;
            }
            int size = this.numElements;
            int i = 0;
            while (i < size) {
                if (!other.contains((Object)this.elements[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return super.equals(otherFlow);
    }

    @Override
    public void copy(FlowSet<T> destFlow) {
        if (this.sameType(destFlow)) {
            ArraySparseSet dest = (ArraySparseSet)destFlow;
            while (dest.maxElements < this.maxElements) {
                dest.doubleCapacity();
            }
            dest.numElements = this.numElements;
            System.arraycopy(this.elements, 0, dest.elements, 0, this.numElements);
        } else {
            super.copy(destFlow);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int lastIdx = 0;

            @Override
            public boolean hasNext() {
                return this.lastIdx < ArraySparseSet.this.numElements;
            }

            @Override
            public T next() {
                return ArraySparseSet.this.elements[this.lastIdx++];
            }

            @Override
            public void remove() {
                ArraySparseSet.this.remove(this.lastIdx);
                --this.lastIdx;
            }
        };
    }
}

