/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.BitSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Timers;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.Orderer;
import soot.toolkits.graph.PseudoTopologicalOrderer;

public abstract class ForwardFlowAnalysisExtended<N, A> {
    protected Map<N, Map<N, A>> unitToBeforeFlow;
    protected Map<N, Map<N, A>> unitToAfterFlow;
    protected DirectedGraph<N> graph;

    public ForwardFlowAnalysisExtended(DirectedGraph<N> graph) {
        this.graph = graph;
        this.unitToBeforeFlow = new IdentityHashMap<N, Map<N, A>>(graph.size() * 2 + 1);
        this.unitToAfterFlow = new IdentityHashMap<N, Map<N, A>>(graph.size() * 2 + 1);
    }

    protected Orderer<N> constructOrderer() {
        return new PseudoTopologicalOrderer();
    }

    protected abstract A newInitialFlow();

    protected abstract A entryInitialFlow();

    protected abstract void copy(A var1, A var2);

    protected abstract void merge(A var1, A var2, A var3);

    protected void merge(N succNode, A in1, A in2, A out) {
        this.merge(in1, in2, out);
    }

    protected void mergeInto(N succNode, A inout, A in) {
        A tmp = this.newInitialFlow();
        this.merge(succNode, inout, in, tmp);
        this.copy(tmp, inout);
    }

    public A getFromMap(Map<N, Map<N, A>> map, N s, N t) {
        Map<N, A> m = map.get(s);
        if (m == null) {
            return null;
        }
        return m.get(t);
    }

    public void putToMap(Map<N, Map<N, A>> map, N s, N t, A val) {
        Map<N, A> m = map.get(s);
        if (m == null) {
            m = new IdentityHashMap<N, A>();
            map.put(s, m);
        }
        m.put(t, val);
    }

    protected void doAnalysis() {
        List<N> orderedUnits = this.constructOrderer().newList(this.graph, false);
        int n = orderedUnits.size();
        BitSet head = new BitSet();
        BitSet work = new BitSet(n);
        work.set(0, n);
        IdentityHashMap<Object, Integer> index = new IdentityHashMap<Object, Integer>(n * 2 + 1);
        int i = 0;
        for (Object s : orderedUnits) {
            index.put(s, i++);
            for (Object object : this.graph.getSuccsOf(s)) {
                this.putToMap(this.unitToBeforeFlow, s, object, this.newInitialFlow());
                this.putToMap(this.unitToAfterFlow, s, object, this.newInitialFlow());
            }
        }
        for (Object s : this.graph.getHeads()) {
            head.set((Integer)index.get(s));
            for (N v : this.graph.getSuccsOf(s)) {
                this.putToMap(this.unitToBeforeFlow, s, v, this.entryInitialFlow());
            }
        }
        int numComputations = 0;
        A previousFlow = this.newInitialFlow();
        int i2 = work.nextSetBit(0);
        while (i2 >= 0) {
            work.clear(i2);
            N n2 = orderedUnits.get(i2);
            int k = i2;
            for (N v : this.graph.getSuccsOf(n2)) {
                boolean hasChanged;
                A beforeFlow = this.getFromMap(this.unitToBeforeFlow, n2, v);
                A afterFlow = this.getFromMap(this.unitToAfterFlow, n2, v);
                this.copy(afterFlow, previousFlow);
                Iterator<N> it = this.graph.getPredsOf(n2).iterator();
                if (it.hasNext()) {
                    this.copy(this.getFromMap(this.unitToAfterFlow, it.next(), n2), beforeFlow);
                    while (it.hasNext()) {
                        this.mergeInto(n2, beforeFlow, this.getFromMap(this.unitToAfterFlow, it.next(), n2));
                    }
                    if (head.get(k)) {
                        this.mergeInto(n2, beforeFlow, this.entryInitialFlow());
                    }
                }
                this.flowThrough(beforeFlow, n2, v, afterFlow);
                boolean bl = hasChanged = !previousFlow.equals(afterFlow);
                if (hasChanged) {
                    int j = (Integer)index.get(v);
                    work.set(j);
                    i2 = Math.min(i2, j - 1);
                }
                ++numComputations;
            }
            i2 = work.nextSetBit(i2 + 1);
        }
        Timers.v().totalFlowNodes += n;
        Timers.v().totalFlowComputations += numComputations;
    }

    protected abstract void flowThrough(A var1, N var2, N var3, A var4);

    public A getFlowBefore(N s) {
        Iterator<N> it = this.graph.getPredsOf(s).iterator();
        A beforeFlow = null;
        if (it.hasNext()) {
            beforeFlow = this.getFromMap(this.unitToAfterFlow, it.next(), s);
            while (it.hasNext()) {
                this.mergeInto(s, beforeFlow, this.getFromMap(this.unitToAfterFlow, it.next(), s));
            }
        }
        return beforeFlow;
    }
}

