/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Local;
import soot.Singletons;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.options.Options;

public class UnusedLocalEliminator
extends BodyTransformer {
    public UnusedLocalEliminator(Singletons.Global g) {
    }

    public static UnusedLocalEliminator v() {
        return G.v().soot_toolkits_scalar_UnusedLocalEliminator();
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map<String, String> options) {
        Local[] locals;
        if (Options.v().verbose()) {
            G.v().out.println("[" + body.getMethod().getName() + "] Eliminating unused locals...");
        }
        int i = 0;
        int n = body.getLocals().size();
        int[] oldNumbers = new int[n];
        Local[] localArray = locals = body.getLocals().toArray(new Local[n]);
        int n2 = locals.length;
        int n3 = 0;
        while (n3 < n2) {
            Local local = localArray[n3];
            oldNumbers[i] = local.getNumber();
            local.setNumber(i);
            ++i;
            ++n3;
        }
        boolean[] usedLocals = new boolean[n];
        for (Unit s : body.getUnits()) {
            Local l;
            Value v;
            for (ValueBox vb : s.getUseBoxes()) {
                v = vb.getValue();
                if (!(v instanceof Local)) continue;
                l = (Local)v;
                usedLocals[l.getNumber()] = true;
            }
            for (ValueBox vb : s.getDefBoxes()) {
                v = vb.getValue();
                if (!(v instanceof Local)) continue;
                l = (Local)v;
                usedLocals[l.getNumber()] = true;
            }
        }
        ArrayList<Local> keep = new ArrayList<Local>(locals.length);
        Local[] localArray2 = locals;
        int n4 = locals.length;
        int n5 = 0;
        while (n5 < n4) {
            Local local = localArray2[n5];
            int lno = local.getNumber();
            local.setNumber(oldNumbers[lno]);
            if (usedLocals[lno]) {
                keep.add(local);
            }
            ++n5;
        }
        body.getLocals().clear();
        body.getLocals().addAll(keep);
    }
}

