/*
 * Decompiled with CFR 0.152.
 */
package soot.tools;

import java.util.Iterator;
import java.util.Map;
import soot.G;
import soot.Main;
import soot.PackManager;
import soot.PrimType;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Transform;
import soot.Value;
import soot.ValueBox;
import soot.jimple.FieldRef;
import soot.jimple.InvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.toolkits.callgraph.CallGraph;

public class BadFields
extends SceneTransformer {
    private SootClass lastClass;
    private SootClass currentClass;

    public static void main(String[] args) {
        PackManager.v().getPack("cg").add(new Transform("cg.badfields", new BadFields()));
        Main.main(args);
    }

    @Override
    protected void internalTransform(String phaseName, Map<String, String> options) {
        this.lastClass = null;
        Iterator<SootClass> clIt = Scene.v().getApplicationClasses().iterator();
        while (clIt.hasNext()) {
            SootClass cl;
            this.currentClass = cl = clIt.next();
            this.handleClass(cl);
            Iterator<SootMethod> it = cl.methodIterator();
            while (it.hasNext()) {
                this.handleMethod(it.next());
            }
        }
        Scene.v().setCallGraph(new CallGraph());
    }

    private void handleClass(SootClass cl) {
        for (SootField f : cl.getFields()) {
            String typeName;
            if (!f.isStatic() || (typeName = f.getType().toString()).equals("java.lang.Class") || f.isFinal() && (f.getType() instanceof PrimType || typeName.equals("java.io.PrintStream") || typeName.equals("java.lang.String") || typeName.equals("java.lang.Object") || typeName.equals("java.lang.Integer") || typeName.equals("java.lang.Boolean"))) continue;
            this.warn("Bad field " + f);
        }
    }

    private void warn(String warning) {
        if (this.lastClass != this.currentClass) {
            G.v().out.println("In class " + this.currentClass);
        }
        this.lastClass = this.currentClass;
        G.v().out.println("  " + warning);
    }

    private void handleMethod(SootMethod m) {
        InvokeExpr ie;
        SootMethod target;
        if (!m.isConcrete()) {
            return;
        }
        for (ValueBox valueBox : m.retrieveActiveBody().getUseAndDefBoxes()) {
            StaticFieldRef sfr;
            SootField f;
            Value v = valueBox.getValue();
            if (!(v instanceof StaticFieldRef) || !(f = (sfr = (StaticFieldRef)v).getField()).getDeclaringClass().getName().equals("java.lang.System")) continue;
            if (f.getName().equals("err")) {
                G.v().out.println("Use of System.err in " + m);
            }
            if (!f.getName().equals("out")) continue;
            G.v().out.println("Use of System.out in " + m);
        }
        for (Stmt stmt : m.getActiveBody().getUnits()) {
            if (!stmt.containsInvokeExpr() || !(target = (ie = stmt.getInvokeExpr()).getMethod()).getDeclaringClass().getName().equals("java.lang.System") || !target.getName().equals("exit")) continue;
            this.warn(m + " calls System.exit");
        }
        if (m.getName().equals("<clinit>")) {
            for (Stmt stmt : m.getActiveBody().getUnits()) {
                for (ValueBox b : stmt.getUseBoxes()) {
                    Value v = b.getValue();
                    if (!(v instanceof FieldRef)) continue;
                    this.warn(String.valueOf(m.getName()) + " reads field " + v);
                }
                if (!stmt.containsInvokeExpr()) continue;
                ie = stmt.getInvokeExpr();
                target = ie.getMethod();
                this.calls(target);
            }
        }
    }

    private void calls(SootMethod target) {
        if (target.getName().equals("<init>")) {
            if (target.getDeclaringClass().getName().equals("java.io.PrintStream")) {
                return;
            }
            if (target.getDeclaringClass().getName().equals("java.lang.Boolean")) {
                return;
            }
            if (target.getDeclaringClass().getName().equals("java.lang.Integer")) {
                return;
            }
            if (target.getDeclaringClass().getName().equals("java.lang.String")) {
                return;
            }
            if (target.getDeclaringClass().getName().equals("java.lang.Object")) {
                return;
            }
        }
        if (target.getName().equals("getProperty") && target.getDeclaringClass().getName().equals("java.lang.System")) {
            return;
        }
        if (target.getName().equals("charAt") && target.getDeclaringClass().getName().equals("java.lang.String")) {
            return;
        }
        this.warn("<clinit> invokes " + target);
    }
}

