/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import soot.util.BitSetIterator;

public class BitVector {
    private long[] bits;

    public BitVector() {
        this(64);
    }

    public BitVector(BitVector other) {
        this.bits = new long[other.bits.length];
        System.arraycopy(other.bits, 0, this.bits, 0, other.bits.length);
    }

    public BitVector(int numBits) {
        int lastIndex = this.indexOf(numBits - 1);
        this.bits = new long[lastIndex + 1];
    }

    private int indexOf(int bit) {
        return bit >> 6;
    }

    private long mask(int bit) {
        return 1L << (bit & 0x3F);
    }

    public void and(BitVector other) {
        if (this == other) {
            return;
        }
        long[] otherBits = other.bits;
        int numToAnd = otherBits.length;
        if (this.bits.length < numToAnd) {
            numToAnd = this.bits.length;
        }
        int i = 0;
        while (i < numToAnd) {
            this.bits[i] = this.bits[i] & otherBits[i];
            ++i;
        }
        while (i < this.bits.length) {
            this.bits[i] = 0L;
            ++i;
        }
    }

    public void andNot(BitVector other) {
        long[] otherBits = other.bits;
        int numToAnd = otherBits.length;
        if (this.bits.length < numToAnd) {
            numToAnd = this.bits.length;
        }
        int i = 0;
        while (i < numToAnd) {
            this.bits[i] = this.bits[i] & (otherBits[i] ^ 0xFFFFFFFFFFFFFFFFL);
            ++i;
        }
    }

    public void clear(int bit) {
        if (this.indexOf(bit) < this.bits.length) {
            int n = this.indexOf(bit);
            this.bits[n] = this.bits[n] & (this.mask(bit) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public Object clone() {
        try {
            BitVector ret = (BitVector)super.clone();
            System.arraycopy(this.bits, 0, ret.bits, 0, ret.bits.length);
            return ret;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof BitVector)) {
            return false;
        }
        BitVector other = (BitVector)o;
        int min = this.bits.length;
        long[] longer = other.bits;
        if (other.bits.length < min) {
            min = other.bits.length;
            longer = this.bits;
        }
        int i = 0;
        while (i < min) {
            if (this.bits[i] != other.bits[i]) {
                return false;
            }
            ++i;
        }
        while (i < longer.length) {
            if (longer[i] != 0L) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean get(int bit) {
        if (this.indexOf(bit) >= this.bits.length) {
            return false;
        }
        return (this.bits[this.indexOf(bit)] & this.mask(bit)) != 0L;
    }

    public int hashCode() {
        long ret = 0L;
        long[] lArray = this.bits;
        int n = this.bits.length;
        int n2 = 0;
        while (n2 < n) {
            long element = lArray[n2];
            ret ^= element;
            ++n2;
        }
        return (int)(ret >> 32 ^ ret);
    }

    public int length() {
        int i = this.bits.length - 1;
        while (i >= 0) {
            if (this.bits[i] != 0L) break;
            --i;
        }
        if (i < 0) {
            return 0;
        }
        long j = this.bits[i];
        ++i;
        i <<= 6;
        long k = Long.MIN_VALUE;
        while ((k & j) == 0L) {
            k >>= 1;
            --i;
        }
        return i;
    }

    public void copyFrom(BitVector other) {
        if (this == other) {
            return;
        }
        long[] otherBits = other.bits;
        int j = otherBits.length - 1;
        while (j >= 0) {
            if (otherBits[j] != 0L) break;
            --j;
        }
        this.expand(j << 6);
        int i = j + 1;
        while (j >= 0) {
            this.bits[j] = otherBits[j];
            --j;
        }
        while (i < this.bits.length) {
            this.bits[i] = 0L;
            ++i;
        }
    }

    public void or(BitVector other) {
        if (this == other) {
            return;
        }
        long[] otherBits = other.bits;
        int j = otherBits.length - 1;
        while (j >= 0) {
            if (otherBits[j] != 0L) break;
            --j;
        }
        this.expand(j << 6);
        while (j >= 0) {
            int n = j;
            this.bits[n] = this.bits[n] | otherBits[j];
            --j;
        }
    }

    public int cardinality() {
        int c = 0;
        long[] lArray = this.bits;
        int n = this.bits.length;
        int n2 = 0;
        while (n2 < n) {
            long v = lArray[n2];
            while (v != 0L) {
                v &= v - 1L;
                ++c;
            }
            ++n2;
        }
        return c;
    }

    public boolean intersects(BitVector other) {
        long[] otherBits = other.bits;
        int numToCheck = otherBits.length;
        if (this.bits.length < numToCheck) {
            numToCheck = this.bits.length;
        }
        int i = 0;
        while (i < numToCheck) {
            if ((this.bits[i] & otherBits[i]) != 0L) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void expand(int bit) {
        int n = this.indexOf(bit) + 1;
        if (n <= this.bits.length) {
            return;
        }
        if (this.bits.length * 2 > n) {
            n = this.bits.length * 2;
        }
        long[] newBits = new long[n];
        System.arraycopy(this.bits, 0, newBits, 0, this.bits.length);
        this.bits = newBits;
    }

    public void xor(BitVector other) {
        if (this == other) {
            return;
        }
        long[] otherBits = other.bits;
        int j = otherBits.length - 1;
        while (j >= 0) {
            if (otherBits[j] != 0L) break;
            --j;
        }
        this.expand(j << 6);
        while (j >= 0) {
            int n = j;
            this.bits[n] = this.bits[n] ^ otherBits[j];
            --j;
        }
    }

    public boolean set(int bit) {
        this.expand(bit);
        boolean ret = !this.get(bit);
        int n = this.indexOf(bit);
        this.bits[n] = this.bits[n] | this.mask(bit);
        return ret;
    }

    public int size() {
        return this.bits.length << 6;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append('{');
        boolean start = true;
        BitSetIterator it = new BitSetIterator(this.bits);
        while (it.hasNext()) {
            int bit = it.next();
            if (!start) {
                ret.append(", ");
            }
            start = false;
            ret.append(bit);
        }
        ret.append('}');
        return ret.toString();
    }

    /*
     * Unable to fully structure code
     */
    public boolean orAndAndNot(BitVector orset, BitVector andset, BitVector andnotset) {
        block24: {
            block25: {
                block23: {
                    ret = false;
                    a = null;
                    b = null;
                    c = null;
                    d = null;
                    e = null;
                    a = this.bits;
                    al = a.length;
                    if (orset == null) {
                        bl = 0;
                    } else {
                        b = orset.bits;
                        bl = b.length;
                    }
                    if (andset == null) {
                        cl = 0;
                    } else {
                        c = andset.bits;
                        cl = c.length;
                    }
                    if (andnotset == null) {
                        dl = 0;
                    } else {
                        d = andnotset.bits;
                        dl = d.length;
                    }
                    if (al < bl) {
                        e = new long[bl];
                        System.arraycopy(a, 0, e, 0, al);
                        this.bits = e;
                    } else {
                        e = a;
                    }
                    i = 0;
                    if (c != null) break block23;
                    if (dl > bl) ** GOTO lbl53
                    while (i < dl) {
                        l = b[i] & (d[i] ^ -1L);
                        if ((l & (e[i] ^ -1L)) != 0L) {
                            ret = true;
                        }
                        v0 = i++;
                        e[v0] = e[v0] | l;
                    }
                    while (i < bl) {
                        l = b[i];
                        if ((l & (e[i] ^ -1L)) != 0L) {
                            ret = true;
                        }
                        v1 = i++;
                        e[v1] = e[v1] | l;
                    }
                    break block24;
lbl-1000:
                    // 1 sources

                    {
                        l = b[i] & (d[i] ^ -1L);
                        if ((l & (e[i] ^ -1L)) != 0L) {
                            ret = true;
                        }
                        v2 = i++;
                        e[v2] = e[v2] | l;
lbl53:
                        // 2 sources

                        ** while (i < bl)
                    }
lbl54:
                    // 1 sources

                    break block24;
                }
                if (bl > cl || bl > dl) break block25;
                while (i < bl) {
                    l = b[i] & c[i] & (d[i] ^ -1L);
                    if ((l & (e[i] ^ -1L)) != 0L) {
                        ret = true;
                    }
                    v3 = i++;
                    e[v3] = e[v3] | l;
                }
                break block24;
            }
            if (cl > bl || cl > dl) ** GOTO lbl80
            while (i < cl) {
                l = b[i] & c[i] & (d[i] ^ -1L);
                if ((l & (e[i] ^ -1L)) != 0L) {
                    ret = true;
                }
                v4 = i++;
                e[v4] = e[v4] | l;
            }
            break block24;
lbl-1000:
            // 1 sources

            {
                l = b[i] & c[i] & (d[i] ^ -1L);
                if ((l & (e[i] ^ -1L)) != 0L) {
                    ret = true;
                }
                v5 = i++;
                e[v5] = e[v5] | l;
lbl80:
                // 2 sources

                ** while (i < dl)
            }
lbl81:
            // 1 sources

            shorter = cl;
            if (bl < shorter) {
                shorter = bl;
            }
            while (i < shorter) {
                l = b[i] & c[i];
                if ((l & (e[i] ^ -1L)) != 0L) {
                    ret = true;
                }
                v6 = i++;
                e[v6] = e[v6] | l;
            }
        }
        return ret;
    }

    public static BitVector and(BitVector set1, BitVector set2) {
        int max;
        int min = set1.size();
        if (min > (max = set2.size())) {
            min = max;
        }
        BitVector ret = new BitVector(min);
        long[] retbits = ret.bits;
        long[] bits1 = set1.bits;
        long[] bits2 = set2.bits;
        min >>= 6;
        int i = 0;
        while (i < min) {
            retbits[i] = bits1[i] & bits2[i];
            ++i;
        }
        return ret;
    }

    public static BitVector or(BitVector set1, BitVector set2) {
        int max;
        int min = set1.size();
        if (min > (max = set2.size())) {
            min = max;
            max = set1.size();
        }
        BitVector ret = new BitVector(max);
        long[] retbits = ret.bits;
        long[] bits1 = set1.bits;
        long[] bits2 = set2.bits;
        min >>= 6;
        max >>= 6;
        int i = 0;
        while (i < min) {
            retbits[i] = bits1[i] | bits2[i];
            ++i;
        }
        if (bits1.length == min) {
            System.arraycopy(bits2, min, retbits, min, max - min);
        } else {
            System.arraycopy(bits1, min, retbits, min, max - min);
        }
        return ret;
    }

    public BitSetIterator iterator() {
        return new BitSetIterator(this.bits);
    }
}

