/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.util.Iterator;
import soot.util.ArrayNumberer;
import soot.util.BitVector;
import soot.util.Numberable;

public final class NumberedSet<N extends Numberable> {
    private Numberable[] array = new Numberable[8];
    private BitVector bits;
    private int size = 0;
    private ArrayNumberer<N> universe;

    public NumberedSet(ArrayNumberer<N> universe) {
        this.universe = universe;
    }

    public boolean add(Numberable o) {
        if (this.array != null) {
            int pos = this.findPosition(o);
            if (this.array[pos] == o) {
                return false;
            }
            ++this.size;
            if (this.size * 3 > this.array.length * 2) {
                this.doubleSize();
                if (this.array != null) {
                    pos = this.findPosition(o);
                } else {
                    int number = o.getNumber();
                    if (number == 0) {
                        throw new RuntimeException("unnumbered");
                    }
                    return this.bits.set(number);
                }
            }
            this.array[pos] = o;
            return true;
        }
        int number = o.getNumber();
        if (number == 0) {
            throw new RuntimeException("unnumbered");
        }
        if (this.bits.set(number)) {
            ++this.size;
            return true;
        }
        return false;
    }

    public boolean contains(Numberable o) {
        if (this.array != null) {
            return this.array[this.findPosition(o)] != null;
        }
        int number = o.getNumber();
        if (number == 0) {
            throw new RuntimeException("unnumbered");
        }
        return this.bits.get(number);
    }

    private final int findPosition(Numberable o) {
        int number = o.getNumber();
        if (number == 0) {
            throw new RuntimeException("unnumbered");
        }
        number &= this.array.length - 1;
        while (this.array[number] != o) {
            if (this.array[number] == null) {
                return number;
            }
            number = number + 1 & this.array.length - 1;
        }
        return number;
    }

    private final void doubleSize() {
        int uniSize = this.universe.size();
        if (this.array.length * 128 > uniSize) {
            this.bits = new BitVector(uniSize);
            Numberable[] oldArray = this.array;
            this.array = null;
            Numberable[] numberableArray = oldArray;
            int n = oldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Numberable element = numberableArray[n2];
                if (element != null) {
                    this.bits.set(element.getNumber());
                }
                ++n2;
            }
        } else {
            Numberable[] oldArray = this.array;
            this.array = new Numberable[this.array.length * 2];
            Numberable[] numberableArray = oldArray;
            int n = oldArray.length;
            int n3 = 0;
            while (n3 < n) {
                Numberable element = numberableArray[n3];
                if (element != null) {
                    this.array[this.findPosition((Numberable)element)] = element;
                }
                ++n3;
            }
        }
    }

    public Iterator<N> iterator() {
        if (this.array == null) {
            return new BitSetIterator(this);
        }
        return new NumberedSetIterator(this);
    }

    public final int size() {
        return this.size;
    }

    class BitSetIterator
    implements Iterator<N> {
        soot.util.BitSetIterator iter;

        BitSetIterator(NumberedSet<N> set) {
            this.iter = set.bits.iterator();
        }

        @Override
        public final boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public void remove() {
            throw new RuntimeException("Not implemented.");
        }

        @Override
        public final N next() {
            return NumberedSet.this.universe.get(this.iter.next());
        }
    }

    class NumberedSetIterator
    implements Iterator<N> {
        NumberedSet<N> set;
        int cur = 0;

        NumberedSetIterator(NumberedSet<N> set) {
            this.set = set;
            this.seekNext();
        }

        protected final void seekNext() {
            try {
                while (this.set.array[this.cur] == null) {
                    ++this.cur;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.cur = -1;
            }
        }

        @Override
        public final boolean hasNext() {
            return this.cur != -1;
        }

        @Override
        public void remove() {
            throw new RuntimeException("Not implemented.");
        }

        @Override
        public final N next() {
            Numberable ret = this.set.array[this.cur];
            ++this.cur;
            this.seekNext();
            return ret;
        }
    }
}

