/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import soot.util.LargePriorityQueue;
import soot.util.MediumPriorityQueue;
import soot.util.Numberable;
import soot.util.SmallPriorityQueue;

public abstract class PriorityQueue<E>
extends AbstractQueue<E> {
    final List<? extends E> universe;
    final int N;
    int min = Integer.MAX_VALUE;
    private Map<E, Integer> ordinalMap;

    int getOrdinal(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        Integer i = this.ordinalMap.get(o);
        if (i == null) {
            throw new NoSuchElementException();
        }
        return i;
    }

    abstract void addAll();

    abstract int nextSetBit(int var1);

    abstract boolean remove(int var1);

    @Override
    abstract boolean add(int var1);

    abstract boolean contains(int var1);

    @Override
    public final E peek() {
        return this.isEmpty() ? null : (E)this.universe.get(this.min);
    }

    @Override
    public final E poll() {
        if (this.isEmpty()) {
            return null;
        }
        E e = this.universe.get(this.min);
        this.remove(this.min);
        return e;
    }

    @Override
    public final boolean add(E e) {
        return this.offer(e);
    }

    @Override
    public final boolean offer(E e) {
        return this.add(this.getOrdinal(e));
    }

    @Override
    public final boolean remove(Object o) {
        block4: {
            if (o == null || this.isEmpty()) {
                return false;
            }
            try {
                if (!o.equals(this.peek())) break block4;
                this.remove(this.min);
                return true;
            }
            catch (NoSuchElementException noSuchElementException) {
                return false;
            }
        }
        return this.remove(this.getOrdinal(o));
    }

    @Override
    public final boolean contains(Object o) {
        block4: {
            if (o == null) {
                return false;
            }
            try {
                if (!o.equals(this.peek())) break block4;
                return true;
            }
            catch (NoSuchElementException noSuchElementException) {
                return false;
            }
        }
        return this.contains(this.getOrdinal(o));
    }

    @Override
    public boolean isEmpty() {
        return this.min >= this.N;
    }

    PriorityQueue(List<? extends E> universe, Map<E, Integer> ordinalMap) {
        assert (ordinalMap.size() == universe.size());
        this.universe = universe;
        this.ordinalMap = ordinalMap;
        this.N = universe.size();
    }

    public static <E> PriorityQueue<E> of(E[] universe) {
        return PriorityQueue.of(Arrays.asList(universe));
    }

    public static <E> PriorityQueue<E> noneOf(E[] universe) {
        return PriorityQueue.noneOf(Arrays.asList(universe));
    }

    public static <E> PriorityQueue<E> of(List<? extends E> universe) {
        PriorityQueue<E> q = PriorityQueue.noneOf(universe);
        q.addAll();
        return q;
    }

    public static <E> PriorityQueue<E> noneOf(List<? extends E> universe) {
        HashMap<E, Integer> ordinalMap = new HashMap<E, Integer>(2 * universe.size() / 3);
        int i = 0;
        for (E e : universe) {
            if (e == null) {
                throw new NullPointerException("null is not allowed");
            }
            if (ordinalMap.put(e, i++) == null) continue;
            throw new IllegalArgumentException("duplicate key found");
        }
        return PriorityQueue.newPriorityQueue(universe, ordinalMap);
    }

    public static <E extends Numberable> PriorityQueue<E> of(List<? extends E> universe, boolean useNumberInterface) {
        PriorityQueue<E> q = PriorityQueue.noneOf(universe, useNumberInterface);
        q.addAll();
        return q;
    }

    public static <E extends Numberable> PriorityQueue<E> noneOf(final List<? extends E> universe, boolean useNumberInterface) {
        if (!useNumberInterface) {
            return PriorityQueue.noneOf(universe);
        }
        int i = 0;
        for (Numberable e : universe) {
            e.setNumber(i++);
        }
        return PriorityQueue.newPriorityQueue(universe, new AbstractMap<E, Integer>(){

            @Override
            public Integer get(Object key) {
                return ((Numberable)key).getNumber();
            }

            @Override
            public int size() {
                return universe.size();
            }

            @Override
            public Set<Map.Entry<E, Integer>> entrySet() {
                throw new UnsupportedOperationException();
            }
        });
    }

    private static <E> PriorityQueue<E> newPriorityQueue(List<? extends E> universe, Map<E, Integer> ordinalMap) {
        if (universe.size() <= 64) {
            return new SmallPriorityQueue<E>(universe, ordinalMap);
        }
        if (universe.size() <= 4096) {
            return new MediumPriorityQueue<E>(universe, ordinalMap);
        }
        return new LargePriorityQueue<E>(universe, ordinalMap);
    }

    abstract class Itr
    implements Iterator<E> {
        long expected = this.getExpected();
        int next;
        int now;

        Itr() {
            this.next = PriorityQueue.this.min;
            this.now = Integer.MAX_VALUE;
        }

        abstract long getExpected();

        @Override
        public boolean hasNext() {
            return this.next < PriorityQueue.this.N;
        }

        @Override
        public E next() {
            if (this.expected != this.getExpected()) {
                throw new ConcurrentModificationException();
            }
            if (this.next >= PriorityQueue.this.N) {
                throw new NoSuchElementException();
            }
            this.now = this.next;
            this.next = PriorityQueue.this.nextSetBit(this.next + 1);
            return PriorityQueue.this.universe.get(this.now);
        }

        @Override
        public void remove() {
            if (this.now >= PriorityQueue.this.N) {
                throw new IllegalStateException();
            }
            if (this.expected != this.getExpected()) {
                throw new ConcurrentModificationException();
            }
            PriorityQueue.this.remove(this.now);
            this.expected = this.getExpected();
            this.now = Integer.MAX_VALUE;
        }
    }
}

