/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.util.PriorityQueue;

class SmallPriorityQueue<E>
extends PriorityQueue<E> {
    static final int MAX_CAPACITY = 64;
    private long queue = 0L;

    @Override
    void addAll() {
        if (this.N == 0) {
            return;
        }
        this.queue = -1L >>> -this.N;
        this.min = 0;
    }

    SmallPriorityQueue(List<? extends E> universe, Map<E, Integer> ordinalMap) {
        super(universe, ordinalMap);
        assert (universe.size() <= 64);
    }

    @Override
    public void clear() {
        this.queue = 0L;
        this.min = Integer.MAX_VALUE;
    }

    @Override
    public Iterator<E> iterator() {
        return new PriorityQueue.Itr(this){

            @Override
            long getExpected() {
                return SmallPriorityQueue.this.queue;
            }
        };
    }

    @Override
    public int size() {
        return Long.bitCount(this.queue);
    }

    @Override
    int nextSetBit(int fromIndex) {
        assert (fromIndex >= 0);
        if (fromIndex > this.N) {
            return fromIndex;
        }
        long m0 = -1L << fromIndex;
        long t0 = this.queue & m0;
        if ((t0 & -m0) != 0L) {
            return fromIndex;
        }
        return Long.numberOfTrailingZeros(t0);
    }

    @Override
    boolean add(int ordinal) {
        long old = this.queue;
        this.queue |= 1L << ordinal;
        if (old == this.queue) {
            return false;
        }
        this.min = Math.min(this.min, ordinal);
        return true;
    }

    @Override
    boolean contains(int ordinal) {
        assert (ordinal >= 0);
        assert (ordinal < this.N);
        return (this.queue >>> ordinal & 1L) == 1L;
    }

    @Override
    boolean remove(int index) {
        assert (index >= 0);
        assert (index < this.N);
        long old = this.queue;
        this.queue &= 1L << index ^ 0xFFFFFFFFFFFFFFFFL;
        if (old == this.queue) {
            return false;
        }
        if (this.min == index) {
            this.min = this.nextSetBit(this.min + 1);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        long mask = 0L;
        for (Object o : c) {
            mask |= 1L << this.getOrdinal(o);
        }
        long old = this.queue;
        this.queue &= mask ^ 0xFFFFFFFFFFFFFFFFL;
        this.min = this.nextSetBit(this.min);
        return old != this.queue;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        long mask = 0L;
        for (Object o : c) {
            mask |= 1L << this.getOrdinal(o);
        }
        long old = this.queue;
        this.queue &= mask;
        this.min = this.nextSetBit(this.min);
        return old != this.queue;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        long mask = 0L;
        for (Object o : c) {
            mask |= 1L << this.getOrdinal(o);
        }
        return (mask & (this.queue ^ 0xFFFFFFFFFFFFFFFFL)) == 0L;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        long mask = 0L;
        for (E o : c) {
            mask |= 1L << this.getOrdinal(o);
        }
        long old = this.queue;
        this.queue |= mask;
        if (old == this.queue) {
            return false;
        }
        this.min = this.nextSetBit(0);
        return true;
    }
}

