/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.text.StringCharacterIterator;

public class StringTools {
    public static final String lineSeparator = System.getProperty("line.separator");

    public static String getEscapedStringOf(String fromString) {
        char c;
        StringBuffer whole = new StringBuffer();
        StringBuffer mini = new StringBuffer();
        char[] fromStringArray = fromString.toCharArray();
        char cr = lineSeparator.charAt(0);
        int n = -1;
        if (lineSeparator.length() == 2) {
            c = lineSeparator.charAt(1);
        }
        char[] cArray = fromStringArray;
        int n2 = fromStringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            char element = cArray[n3];
            char ch = element;
            if ((ch >= ' ' && ch <= '~' || ch == cr || ch == c) && ch != '\\') {
                whole.append(ch);
            } else {
                mini.setLength(0);
                mini.append(Integer.toHexString(ch));
                while (mini.length() < 4) {
                    mini.insert(0, "0");
                }
                mini.insert(0, "\\u");
                whole.append(mini.toString());
            }
            ++n3;
        }
        return whole.toString();
    }

    public static String getQuotedStringOf(String fromString) {
        StringBuffer toStringBuffer = new StringBuffer();
        char[] fromStringArray = fromString.toCharArray();
        toStringBuffer.append("\"");
        char[] cArray = fromStringArray;
        int n = fromStringArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (ch == '\\') {
                toStringBuffer.append("\\\\");
            } else if (ch == '\'') {
                toStringBuffer.append("\\'");
            } else if (ch == '\"') {
                toStringBuffer.append("\\\"");
            } else if (ch == '\n') {
                toStringBuffer.append("\\n");
            } else if (ch == '\t') {
                toStringBuffer.append("\\t");
            } else if (ch == '\r') {
                toStringBuffer.append("\\r");
            } else if (ch == '\f') {
                toStringBuffer.append("\\f");
            } else if (ch >= ' ' && ch <= '~') {
                toStringBuffer.append(ch);
            } else {
                toStringBuffer.append(StringTools.getUnicodeStringFromChar(ch));
            }
            ++n2;
        }
        toStringBuffer.append("\"");
        return toStringBuffer.toString();
    }

    public static String getUnicodeStringFromChar(char ch) {
        String s = Integer.toHexString(ch);
        String padding = null;
        switch (s.length()) {
            case 1: {
                padding = "000";
                break;
            }
            case 2: {
                padding = "00";
                break;
            }
            case 3: {
                padding = "0";
                break;
            }
            case 4: {
                padding = "";
            }
        }
        return "\\u" + padding + s;
    }

    public static String getUnEscapedStringOf(String str) {
        StringBuffer buf = new StringBuffer();
        StringCharacterIterator iter = new StringCharacterIterator(str);
        char ch = iter.first();
        while (ch != '\uffff') {
            if (ch != '\\') {
                buf.append(ch);
            } else {
                ch = iter.next();
                if (ch == '\\') {
                    buf.append(ch);
                } else {
                    char format = StringTools.getCFormatChar(ch);
                    if (format != '\u0000') {
                        buf.append(format);
                    } else if (ch == 'u') {
                        StringBuffer mini = new StringBuffer(4);
                        int i = 0;
                        while (i < 4) {
                            mini.append(iter.next());
                            ++i;
                        }
                        ch = (char)Integer.parseInt(mini.toString(), 16);
                        buf.append(ch);
                    } else {
                        throw new RuntimeException("Unexpected char: " + ch);
                    }
                }
            }
            ch = iter.next();
        }
        return buf.toString();
    }

    public static char getCFormatChar(char c) {
        char res;
        switch (c) {
            case 'n': {
                res = '\n';
                break;
            }
            case 't': {
                res = '\t';
                break;
            }
            case 'r': {
                res = '\r';
                break;
            }
            case 'b': {
                res = '\b';
                break;
            }
            case 'f': {
                res = '\f';
                break;
            }
            case '\"': {
                res = '\"';
                break;
            }
            case '\'': {
                res = '\'';
                break;
            }
            default: {
                res = '\u0000';
            }
        }
        return res;
    }
}

