/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

class TrustingMonotonicArraySet<T>
extends AbstractSet<T> {
    private static final int DEFAULT_SIZE = 8;
    private int numElements = 0;
    private int maxElements = 8;
    private T[] elements = new Object[8];

    public TrustingMonotonicArraySet() {
    }

    public TrustingMonotonicArraySet(T[] elements) {
        this();
        T[] TArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            T element = TArray[n2];
            this.add(element);
            ++n2;
        }
    }

    @Override
    public void clear() {
        this.numElements = 0;
    }

    @Override
    public boolean contains(Object obj) {
        int i = 0;
        while (i < this.numElements) {
            if (this.elements[i].equals(obj)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean add(T e) {
        if (this.numElements == this.maxElements) {
            this.doubleCapacity();
        }
        this.elements[this.numElements++] = e;
        return true;
    }

    @Override
    public int size() {
        return this.numElements;
    }

    @Override
    public Iterator<T> iterator() {
        return new ArrayIterator();
    }

    private void removeElementAt(int index) {
        throw new UnsupportedOperationException();
    }

    private void doubleCapacity() {
        int newSize = this.maxElements * 2;
        Object[] newElements = new Object[newSize];
        System.arraycopy(this.elements, 0, newElements, 0, this.numElements);
        this.elements = newElements;
        this.maxElements = newSize;
    }

    @Override
    public T[] toArray() {
        Object[] array = new Object[this.numElements];
        System.arraycopy(this.elements, 0, array, 0, this.numElements);
        return array;
    }

    private class ArrayIterator
    implements Iterator<T> {
        int nextIndex = 0;

        ArrayIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < TrustingMonotonicArraySet.this.numElements;
        }

        @Override
        public T next() throws NoSuchElementException {
            if (this.nextIndex >= TrustingMonotonicArraySet.this.numElements) {
                throw new NoSuchElementException();
            }
            return TrustingMonotonicArraySet.this.elements[this.nextIndex++];
        }

        @Override
        public void remove() throws NoSuchElementException {
            if (this.nextIndex == 0) {
                throw new NoSuchElementException();
            }
            TrustingMonotonicArraySet.this.removeElementAt(this.nextIndex - 1);
            --this.nextIndex;
        }
    }
}

