/*
 * Decompiled with CFR 0.152.
 */
package soot.util.annotations;

import org.apache.commons.lang3.ClassUtils;
import soot.tagkit.AbstractAnnotationElemTypeSwitch;
import soot.tagkit.AnnotationAnnotationElem;
import soot.tagkit.AnnotationArrayElem;
import soot.tagkit.AnnotationBooleanElem;
import soot.tagkit.AnnotationClassElem;
import soot.tagkit.AnnotationDoubleElem;
import soot.tagkit.AnnotationElem;
import soot.tagkit.AnnotationEnumElem;
import soot.tagkit.AnnotationFloatElem;
import soot.tagkit.AnnotationIntElem;
import soot.tagkit.AnnotationLongElem;
import soot.tagkit.AnnotationStringElem;
import soot.util.annotations.AnnotationInstanceCreator;

public class AnnotationElemSwitch
extends AbstractAnnotationElemTypeSwitch {
    @Override
    public void caseAnnotationAnnotationElem(AnnotationAnnotationElem v) {
        AnnotationInstanceCreator aic = new AnnotationInstanceCreator();
        Object result = aic.create(v.getValue());
        this.setResult(new AnnotationElemResult<Object>(v.getName(), result));
    }

    @Override
    public void caseAnnotationArrayElem(AnnotationArrayElem v) {
        Object[] result = new Object[v.getNumValues()];
        int i = 0;
        for (AnnotationElem elem : v.getValues()) {
            AnnotationElemSwitch sw = new AnnotationElemSwitch();
            elem.apply(sw);
            result[i] = ((AnnotationElemResult)sw.getResult()).getValue();
            ++i;
        }
        this.setResult(new AnnotationElemResult<Object[]>(v.getName(), result));
    }

    @Override
    public void caseAnnotationBooleanElem(AnnotationBooleanElem v) {
        this.setResult(new AnnotationElemResult<Boolean>(v.getName(), v.getValue()));
    }

    @Override
    public void caseAnnotationClassElem(AnnotationClassElem v) {
        try {
            Class<?> clazz = ClassUtils.getClass(v.getDesc());
            this.setResult(new AnnotationElemResult(v.getName(), clazz));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load class: " + v.getDesc());
        }
    }

    @Override
    public void caseAnnotationDoubleElem(AnnotationDoubleElem v) {
        this.setResult(new AnnotationElemResult<Double>(v.getName(), v.getValue()));
    }

    @Override
    public void caseAnnotationEnumElem(AnnotationEnumElem v) {
        try {
            Class<?> clazz = ClassUtils.getClass(v.getTypeName());
            Enum result = null;
            ?[] objArray = clazz.getEnumConstants();
            int n = objArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objArray[n2];
                try {
                    Enum t = (Enum)o;
                    if (t.name().equals(v.getConstantName())) {
                        result = t;
                        break;
                    }
                }
                catch (ClassCastException e) {
                    throw new RuntimeException("Class " + v.getTypeName() + " is no Enum");
                }
                ++n2;
            }
            if (result == null) {
                throw new RuntimeException(String.valueOf(v.getConstantName()) + " is not a EnumConstant of " + v.getTypeName());
            }
            this.setResult(new AnnotationElemResult<Object>(v.getName(), result));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load class: " + v.getTypeName());
        }
    }

    @Override
    public void caseAnnotationFloatElem(AnnotationFloatElem v) {
        this.setResult(new AnnotationElemResult<Float>(v.getName(), Float.valueOf(v.getValue())));
    }

    @Override
    public void caseAnnotationIntElem(AnnotationIntElem v) {
        this.setResult(new AnnotationElemResult<Integer>(v.getName(), v.getValue()));
    }

    @Override
    public void caseAnnotationLongElem(AnnotationLongElem v) {
        this.setResult(new AnnotationElemResult<Long>(v.getName(), v.getValue()));
    }

    @Override
    public void caseAnnotationStringElem(AnnotationStringElem v) {
        this.setResult(new AnnotationElemResult<String>(v.getName(), v.getValue()));
    }

    @Override
    public void defaultCase(Object object) {
        throw new RuntimeException("Unexpected AnnotationElem");
    }

    public class AnnotationElemResult<V> {
        private String name;
        private V value;

        public AnnotationElemResult(String name, V value) {
            this.name = name;
            this.value = value;
        }

        public String getKey() {
            return this.name;
        }

        public V getValue() {
            return this.value;
        }
    }
}

