/*
 * Decompiled with CFR 0.152.
 */
package soot.util.cfgcmd;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import soot.G;
import soot.Singletons;

public class AltClassLoader
extends ClassLoader {
    private static final boolean DEBUG = false;
    private String[] locations;
    private final Map<String, Class<?>> alreadyFound = new HashMap();
    private final Map<String, String> nameToMangledName = new HashMap<String, String>();
    private final Map<String, String> mangledNameToName = new HashMap<String, String>();

    public AltClassLoader(Singletons.Global g) {
    }

    public static AltClassLoader v() {
        return G.v().soot_util_cfgcmd_AltClassLoader();
    }

    public void setAltClassPath(String altClassPath) {
        LinkedList<String> locationList = new LinkedList<String>();
        StringTokenizer tokens = new StringTokenizer(altClassPath, File.pathSeparator, false);
        while (tokens.hasMoreTokens()) {
            String location = tokens.nextToken();
            locationList.add(location);
        }
        this.locations = new String[locationList.size()];
        this.locations = locationList.toArray(this.locations);
    }

    public void setAltClasses(String[] classNames) {
        this.nameToMangledName.clear();
        String[] stringArray = classNames;
        int n = classNames.length;
        int n2 = 0;
        while (n2 < n) {
            String origName = stringArray[n2];
            String mangledName = AltClassLoader.mangleName(origName);
            this.nameToMangledName.put(origName, mangledName);
            this.mangledNameToName.put(mangledName, origName);
            ++n2;
        }
    }

    private static String mangleName(String origName) throws IllegalArgumentException {
        int lastDot;
        int dot = 46;
        int dotReplacement = 95;
        StringBuffer mangledName = new StringBuffer(origName);
        int replacements = 0;
        int nextDot = lastDot = origName.lastIndexOf(46);
        while ((nextDot = origName.lastIndexOf(46, nextDot - 1)) >= 0) {
            mangledName.setCharAt(nextDot, '_');
            ++replacements;
        }
        if (replacements <= 0) {
            throw new IllegalArgumentException("AltClassLoader.mangleName()'s crude classname mangling cannot deal with " + origName);
        }
        return mangledName.toString();
    }

    @Override
    protected Class<?> findClass(String maybeMangledName) throws ClassNotFoundException {
        Class<?> result = this.alreadyFound.get(maybeMangledName);
        if (result != null) {
            return result;
        }
        String name = this.mangledNameToName.get(maybeMangledName);
        if (name == null) {
            name = maybeMangledName;
        }
        String pathTail = "/" + name.replace('.', File.separatorChar) + ".class";
        String[] stringArray = this.locations;
        int n = this.locations.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            String path = String.valueOf(element) + pathTail;
            try {
                FileInputStream stream = new FileInputStream(path);
                byte[] classBytes = new byte[stream.available()];
                stream.read(classBytes);
                this.replaceAltClassNames(classBytes);
                result = this.defineClass(maybeMangledName, classBytes, 0, classBytes.length);
                this.alreadyFound.put(maybeMangledName, result);
                stream.close();
                return result;
            }
            catch (IOException iOException) {
            }
            catch (ClassFormatError classFormatError) {
                // empty catch block
            }
            ++n2;
        }
        throw new ClassNotFoundException("Unable to find class" + name + " in alternate classpath");
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        String nameForParent = this.nameToMangledName.get(name);
        if (nameForParent == null) {
            nameForParent = name;
        }
        return super.loadClass(nameForParent, false);
    }

    private void replaceAltClassNames(byte[] classBytes) {
        for (Map.Entry<String, String> entry : this.nameToMangledName.entrySet()) {
            String origName = entry.getKey();
            origName = origName.replace('.', '/');
            String mangledName = entry.getValue();
            mangledName = mangledName.replace('.', '/');
            AltClassLoader.findAndReplace(classBytes, AltClassLoader.stringToUtf8Pattern(origName), AltClassLoader.stringToUtf8Pattern(mangledName));
            AltClassLoader.findAndReplace(classBytes, AltClassLoader.stringToTypeStringPattern(origName), AltClassLoader.stringToTypeStringPattern(mangledName));
        }
    }

    private static byte[] stringToUtf8Pattern(String s) {
        byte[] origBytes = s.getBytes();
        int length = origBytes.length;
        boolean CONSTANT_Utf8 = true;
        byte[] result = new byte[length + 3];
        result[0] = 1;
        result[1] = (byte)(length & 0xFF00);
        result[2] = (byte)(length & 0xFF);
        int i = 0;
        while (i < length) {
            result[i + 3] = origBytes[i];
            ++i;
        }
        return result;
    }

    private static byte[] stringToTypeStringPattern(String s) {
        byte[] origBytes = s.getBytes();
        int length = origBytes.length;
        byte[] result = new byte[length + 2];
        result[0] = 76;
        int i = 0;
        while (i < length) {
            result[i + 1] = origBytes[i];
            ++i;
        }
        result[length + 1] = 59;
        return result;
    }

    private static void findAndReplace(byte[] text, byte[] pattern, byte[] replacement) throws IllegalArgumentException {
        int patternLength = pattern.length;
        if (patternLength != replacement.length) {
            throw new IllegalArgumentException("findAndReplace(): The lengths of the pattern and replacement must match.");
        }
        int match = 0;
        while ((match = AltClassLoader.findMatch(text, pattern, match)) >= 0) {
            AltClassLoader.replace(text, replacement, match);
            match += patternLength;
        }
    }

    private static int findMatch(byte[] text, byte[] pattern, int start) {
        int textLength = text.length;
        int patternLength = pattern.length;
        int base = start;
        while (base < textLength) {
            block3: {
                int t = base;
                int p = 0;
                while (p < patternLength) {
                    if (text[t] == pattern[p]) {
                        ++t;
                        ++p;
                        continue;
                    }
                    break block3;
                }
                return base;
            }
            ++base;
        }
        return -1;
    }

    private static void replace(byte[] text, byte[] replacement, int start) {
        int t = start;
        int p = 0;
        while (p < replacement.length) {
            text[t] = replacement[p];
            ++t;
            ++p;
        }
    }

    public static void main(String[] argv) throws ClassNotFoundException {
        AltClassLoader.v().setAltClassPath(argv[0]);
        int i = 1;
        while (i < argv.length) {
            AltClassLoader.v().setAltClasses(new String[]{argv[i]});
            G.v().out.println("main() loadClass(" + argv[i] + ")");
            AltClassLoader.v().loadClass(argv[i]);
            ++i;
        }
    }
}

