/*
 * Decompiled with CFR 0.152.
 */
package soot.util.cfgcmd;

import soot.CompilationDeathException;
import soot.G;

public class CFGOptionMatcher {
    private CFGOption[] options;

    public CFGOptionMatcher(CFGOption[] options) {
        this.options = options;
    }

    public CFGOption match(String quarry) throws CompilationDeathException {
        String uncasedQuarry = quarry.toLowerCase();
        int match = -1;
        int i = 0;
        while (i < this.options.length) {
            String uncasedName = this.options[i].name().toLowerCase();
            if (uncasedName.startsWith(uncasedQuarry)) {
                if (match == -1) {
                    match = i;
                } else {
                    G.v().out.println(String.valueOf(quarry) + " is ambiguous; it matches " + this.options[match].name() + " and " + this.options[i].name());
                    throw new CompilationDeathException(0, "Option parse error");
                }
            }
            ++i;
        }
        if (match == -1) {
            G.v().out.println("\"" + quarry + "\"" + " does not match any value.");
            throw new CompilationDeathException(0, "Option parse error");
        }
        return this.options[match];
    }

    public String help(int initialIndent, int rightMargin, int hangingIndent) {
        StringBuffer newLineBuf = new StringBuffer(2 + rightMargin);
        newLineBuf.append('\n');
        if (hangingIndent < 0) {
            hangingIndent = 0;
        }
        int i = 0;
        while (i < hangingIndent) {
            newLineBuf.append(' ');
            ++i;
        }
        String newLine = newLineBuf.toString();
        StringBuffer result = new StringBuffer();
        int lineLength = 0;
        int i2 = 0;
        while (i2 < initialIndent) {
            ++lineLength;
            result.append(' ');
            ++i2;
        }
        i2 = 0;
        while (i2 < this.options.length) {
            String name;
            int nameLength;
            if (i2 > 0) {
                result.append('|');
                ++lineLength;
            }
            if (lineLength + (nameLength = (name = this.options[i2].name()).length()) > rightMargin) {
                result.append(newLine);
                lineLength = hangingIndent;
            }
            result.append(name);
            lineLength += nameLength;
            ++i2;
        }
        return result.toString();
    }

    public static abstract class CFGOption {
        private final String name;

        protected CFGOption(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }
    }
}

