/*
 * Decompiled with CFR 0.152.
 */
package soot.validation;

import java.util.HashSet;
import java.util.List;
import soot.SootClass;
import soot.validation.ClassValidator;
import soot.validation.ValidationException;

public enum OuterClassValidator implements ClassValidator
{
    INSTANCE;


    public static OuterClassValidator v() {
        return INSTANCE;
    }

    @Override
    public void validate(SootClass sc, List<ValidationException> exceptions) {
        HashSet<SootClass> outerClasses = new HashSet<SootClass>();
        SootClass curClass = sc;
        while (curClass != null) {
            if (!outerClasses.add(curClass)) {
                exceptions.add(new ValidationException(curClass, "Circular outer class chain"));
                break;
            }
            SootClass sootClass = curClass = curClass.hasOuterClass() ? curClass.getOuterClass() : null;
        }
    }

    @Override
    public boolean isBasicValidator() {
        return true;
    }
}

