/*
 * Decompiled with CFR 0.152.
 */
package soot.xml;

import java.io.PrintWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import soot.Body;
import soot.G;
import soot.Local;
import soot.Main;
import soot.Modifier;
import soot.NormalUnitPrinter;
import soot.PatchingChain;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Trap;
import soot.Unit;
import soot.ValueBox;
import soot.jimple.IdentityStmt;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.scalar.SimpleLiveLocals;
import soot.util.Chain;
import soot.xml.XMLNode;
import soot.xml.XMLRoot;

public class XMLPrinter {
    public static final String xmlHeader = "<?xml version=\"1.0\" ?>\n";
    public static final String dtdHeader = "<!DOCTYPE jil SYSTEM \"http://www.sable.mcgill.ca/~flynn/jil/jil10.dtd\">\n";
    public XMLRoot root;
    private XMLNode xmlNode = null;

    public String toString() {
        if (this.root != null) {
            return this.root.toString();
        }
        throw new RuntimeException("Error generating XML!");
    }

    public XMLNode addElement(String name) {
        return this.addElement(name, "", "", "");
    }

    public XMLNode addElement(String name, String value) {
        return this.addElement(name, value, "", "");
    }

    public XMLNode addElement(String name, String value, String[] attributes) {
        return this.addElement(name, value, attributes, null);
    }

    public XMLNode addElement(String name, String value, String attribute, String attributeValue) {
        return this.addElement(name, value, new String[]{attribute}, new String[]{attributeValue});
    }

    public XMLNode addElement(String name, String value, String[] attributes, String[] values) {
        return this.root.addElement(name, value, attributes, values);
    }

    public XMLPrinter(Singletons.Global g) {
    }

    public static XMLPrinter v() {
        return G.v().soot_xml_XMLPrinter();
    }

    public XMLNode setXMLNode(XMLNode node) {
        this.xmlNode = node;
        return this.xmlNode;
    }

    private void printStatementsInBody(Body body, PrintWriter out) {
        NormalUnitPrinter up = new NormalUnitPrinter(body);
        Map<Unit, String> stmtToName = up.labels();
        PatchingChain<Unit> units = body.getUnits();
        ExceptionalUnitGraph exceptionalUnitGraph = new ExceptionalUnitGraph(body);
        SimpleLiveLocals sll = new SimpleLiveLocals(exceptionalUnitGraph);
        String cleanMethodName = this.cleanMethod(body.getMethod().getName());
        Iterator unitIt = units.iterator();
        Unit currentStmt = null;
        String currentLabel = "default";
        long statementCount = 0L;
        long labelCount = 0L;
        long labelID = 0L;
        Vector<String> useList = new Vector<String>();
        Vector<Vector<Long>> useDataList = new Vector<Vector<Long>>();
        Vector<String> defList = new Vector<String>();
        Vector<Vector<Long>> defDataList = new Vector<Vector<Long>>();
        Vector<Vector> paramData = new Vector<Vector>();
        Vector<XMLLabel> xmlLabelsList = new Vector<XMLLabel>();
        long maxStmtCount = 0L;
        XMLNode methodNode = this.xmlNode.addChild("method", new String[]{"name", "returntype", "class"}, new String[]{cleanMethodName, body.getMethod().getReturnType().toString(), body.getMethod().getDeclaringClass().getName().toString()});
        String declarationStr = body.getMethod().getDeclaration().toString().trim();
        methodNode.addChild("declaration", this.toCDATA(declarationStr), new String[]{"length"}, new String[]{String.valueOf(declarationStr.length())});
        XMLNode parametersNode = methodNode.addChild("parameters", new String[]{"method"}, new String[]{cleanMethodName});
        XMLNode localsNode = methodNode.addChild("locals");
        XMLNode labelsNode = methodNode.addChild("labels");
        XMLNode stmtsNode = methodNode.addChild("statements");
        XMLLabel xmlLabel = new XMLLabel(labelCount, cleanMethodName, currentLabel);
        labelsNode.addChild("label", new String[]{"id", "name", "method"}, new String[]{String.valueOf(labelCount++), currentLabel, cleanMethodName});
        while (unitIt.hasNext()) {
            Vector<Long> tempVector;
            String local;
            currentStmt = (Unit)unitIt.next();
            if (stmtToName.containsKey(currentStmt)) {
                currentLabel = stmtToName.get(currentStmt).toString();
                xmlLabel.stmtCount = labelID;
                xmlLabel.stmtPercentage = new Float((double)(new Float(labelID).floatValue() / (float)new Float(units.size()).intValue()) * 100.0).longValue();
                if (xmlLabel.stmtPercentage > maxStmtCount) {
                    maxStmtCount = xmlLabel.stmtPercentage;
                }
                xmlLabelsList.addElement(xmlLabel);
                xmlLabel = new XMLLabel(labelCount, cleanMethodName, currentLabel);
                labelsNode.addChild("label", new String[]{"id", "name", "method"}, new String[]{String.valueOf(labelCount), currentLabel, cleanMethodName});
                ++labelCount;
                labelID = 0L;
            }
            XMLNode stmtNode = stmtsNode.addChild("statement", new String[]{"id", "label", "method", "labelid"}, new String[]{String.valueOf(statementCount), currentLabel, cleanMethodName, String.valueOf(labelID)});
            XMLNode sootstmtNode = stmtNode.addChild("soot_statement", new String[]{"branches", "fallsthrough"}, new String[]{this.boolToString(currentStmt.branches()), this.boolToString(currentStmt.fallsThrough())});
            int j = 0;
            for (ValueBox box : currentStmt.getUseBoxes()) {
                if (!(box.getValue() instanceof Local)) continue;
                local = this.cleanLocal(((Local)box.getValue()).toString());
                sootstmtNode.addChild("uses", new String[]{"id", "local", "method"}, new String[]{String.valueOf(j), local, cleanMethodName});
                ++j;
                tempVector = null;
                int useIndex = useList.indexOf(local);
                if (useIndex == -1) {
                    useDataList.addElement(tempVector);
                    useList.addElement(local);
                    useIndex = useList.indexOf(local);
                }
                if (useDataList.size() <= useIndex) continue;
                tempVector = (Vector<Long>)useDataList.elementAt(useIndex);
                if (tempVector == null) {
                    tempVector = new Vector<Long>();
                }
                tempVector.addElement(new Long(statementCount));
                useDataList.setElementAt(tempVector, useIndex);
            }
            j = 0;
            for (ValueBox box : currentStmt.getDefBoxes()) {
                if (!(box.getValue() instanceof Local)) continue;
                local = this.cleanLocal(((Local)box.getValue()).toString());
                sootstmtNode.addChild("defines", new String[]{"id", "local", "method"}, new String[]{String.valueOf(j), local, cleanMethodName});
                ++j;
                tempVector = null;
                int defIndex = defList.indexOf(local);
                if (defIndex == -1) {
                    defDataList.addElement(tempVector);
                    defList.addElement(local);
                    defIndex = defList.indexOf(local);
                }
                if (defDataList.size() <= defIndex) continue;
                tempVector = (Vector<Long>)defDataList.elementAt(defIndex);
                if (tempVector == null) {
                    tempVector = new Vector<Long>();
                }
                tempVector.addElement(new Long(statementCount));
                defDataList.setElementAt(tempVector, defIndex);
            }
            List<Local> liveLocalsIn = sll.getLiveLocalsBefore(currentStmt);
            List<Local> liveLocalsOut = sll.getLiveLocalsAfter(currentStmt);
            XMLNode livevarsNode = sootstmtNode.addChild("livevariables", new String[]{"incount", "outcount"}, new String[]{String.valueOf(liveLocalsIn.size()), String.valueOf(liveLocalsOut.size())});
            int i = 0;
            while (i < liveLocalsIn.size()) {
                livevarsNode.addChild("in", new String[]{"id", "local", "method"}, new String[]{String.valueOf(i), this.cleanLocal(liveLocalsIn.get(i).toString()), cleanMethodName});
                ++i;
            }
            i = 0;
            while (i < liveLocalsOut.size()) {
                livevarsNode.addChild("out", new String[]{"id", "local", "method"}, new String[]{String.valueOf(i), this.cleanLocal(liveLocalsOut.get(i).toString()), cleanMethodName});
                ++i;
            }
            i = 0;
            while (i < body.getMethod().getParameterTypes().size()) {
                Vector tempVec = new Vector();
                paramData.addElement(tempVec);
                ++i;
            }
            currentStmt.toString(up);
            String jimpleStr = up.toString().trim();
            if (currentStmt instanceof IdentityStmt && jimpleStr.indexOf("@parameter") != -1) {
                int paramIndex;
                Vector tempVec;
                String tempStr = jimpleStr.substring(jimpleStr.indexOf("@parameter") + 10);
                if (tempStr.indexOf(":") != -1) {
                    tempStr = tempStr.substring(0, tempStr.indexOf(":")).trim();
                }
                if (tempStr.indexOf(" ") != -1) {
                    tempStr = tempStr.substring(0, tempStr.indexOf(" ")).trim();
                }
                if ((tempVec = (Vector)paramData.elementAt(paramIndex = new Integer(tempStr).intValue())) != null) {
                    tempVec.addElement(Long.toString(statementCount));
                }
                paramData.setElementAt(tempVec, paramIndex);
            }
            sootstmtNode.addChild("jimple", this.toCDATA(jimpleStr), new String[]{"length"}, new String[]{String.valueOf(jimpleStr.length() + 1)});
            ++labelID;
            ++statementCount;
        }
        stmtsNode.addAttribute("count", String.valueOf(statementCount));
        parametersNode.addAttribute("count", String.valueOf(body.getMethod().getParameterCount()));
        int i = 0;
        while (i < body.getMethod().getParameterTypes().size()) {
            XMLNode paramNode = parametersNode.addChild("parameter", new String[]{"id", "type", "method", "name"}, new String[]{String.valueOf(i), body.getMethod().getParameterTypes().get(i).toString(), cleanMethodName, "_parameter" + i});
            XMLNode sootparamNode = paramNode.addChild("soot_parameter");
            Vector tempVec = (Vector)paramData.elementAt(i);
            int k = 0;
            while (k < tempVec.size()) {
                sootparamNode.addChild("use", new String[]{"id", "line", "method"}, new String[]{String.valueOf(k), String.valueOf(String.valueOf(tempVec.elementAt(k))), cleanMethodName});
                ++k;
            }
            sootparamNode.addAttribute("uses", String.valueOf(tempVec.size()));
            ++i;
        }
        xmlLabel.stmtCount = labelID;
        xmlLabel.stmtPercentage = new Float((double)(new Float(labelID).floatValue() / new Float(units.size()).floatValue()) * 100.0).longValue();
        if (xmlLabel.stmtPercentage > maxStmtCount) {
            maxStmtCount = xmlLabel.stmtPercentage;
        }
        xmlLabelsList.addElement(xmlLabel);
        Chain<Local> locals = body.getLocals();
        Iterator localsIterator = locals.iterator();
        Vector<String> localTypes = new Vector<String>();
        Vector<Vector> typedLocals = new Vector<Vector>();
        Vector<Integer> typeCounts = new Vector<Integer>();
        int j = 0;
        int currentType = 0;
        while (localsIterator.hasNext()) {
            int i2;
            Vector tempVector;
            String query;
            int useCount = 0;
            int defineCount = 0;
            Local localData = (Local)localsIterator.next();
            String local = this.cleanLocal(localData.toString());
            String localType = localData.getType().toString();
            if (!localTypes.contains(localType)) {
                localTypes.addElement(localType);
                typedLocals.addElement(new Vector());
                typeCounts.addElement(new Integer(0));
            }
            XMLNode localNode = new XMLNode("local", "", new String[]{"id", "method", "name", "type"}, new String[]{String.valueOf(j), cleanMethodName, local, localType});
            XMLNode sootlocalNode = localNode.addChild("soot_local");
            currentType = 0;
            int k = 0;
            while (k < localTypes.size()) {
                if (localType.equalsIgnoreCase((String)localTypes.elementAt(k))) {
                    currentType = k;
                    Integer tempInt = new Integer((Integer)typeCounts.elementAt(k) + 1);
                    typeCounts.setElementAt(tempInt, k);
                    break;
                }
                ++k;
            }
            k = 0;
            while (k < useList.size()) {
                query = (String)useList.elementAt(k);
                if (query.equalsIgnoreCase(local)) {
                    tempVector = (Vector)useDataList.elementAt(useList.indexOf(local));
                    i2 = 0;
                    while (i2 < tempVector.size()) {
                        sootlocalNode.addChild("use", new String[]{"id", "line", "method"}, new String[]{String.valueOf(i2), ((Long)tempVector.elementAt(i2)).toString(), cleanMethodName});
                        ++i2;
                    }
                    useCount = tempVector.size();
                    break;
                }
                ++k;
            }
            k = 0;
            while (k < defList.size()) {
                query = (String)defList.elementAt(k);
                if (query.equalsIgnoreCase(local)) {
                    tempVector = (Vector)defDataList.elementAt(defList.indexOf(local));
                    i2 = 0;
                    while (i2 < tempVector.size()) {
                        sootlocalNode.addChild("definition", new String[]{"id", "line", "method"}, new String[]{String.valueOf(i2), ((Long)tempVector.elementAt(i2)).toString(), cleanMethodName});
                        ++i2;
                    }
                    defineCount = tempVector.size();
                    break;
                }
                ++k;
            }
            sootlocalNode.addAttribute("uses", String.valueOf(useCount));
            sootlocalNode.addAttribute("defines", String.valueOf(defineCount));
            Vector list = (Vector)typedLocals.elementAt(currentType);
            list.addElement(localNode);
            typedLocals.setElementAt(list, currentType);
            localsNode.addChild((XMLNode)localNode.clone());
            ++j;
        }
        localsNode.addAttribute("count", String.valueOf(locals.size()));
        XMLNode typesNode = localsNode.addChild("types", new String[]{"count"}, new String[]{String.valueOf(localTypes.size())});
        int i3 = 0;
        while (i3 < localTypes.size()) {
            String type = (String)localTypes.elementAt(i3);
            XMLNode typeNode = typesNode.addChild("type", new String[]{"id", "type", "count"}, new String[]{String.valueOf(i3), type, "" + typeCounts.elementAt(i3)});
            Vector list = (Vector)typedLocals.elementAt(i3);
            j = 0;
            while (j < list.size()) {
                typeNode.addChild((XMLNode)list.elementAt(j));
                ++j;
            }
            ++i3;
        }
        labelsNode.addAttribute("count", String.valueOf(labelCount));
        XMLNode current = labelsNode.child;
        int i4 = 0;
        while (i4 < xmlLabelsList.size()) {
            XMLLabel tempLabel = (XMLLabel)xmlLabelsList.elementAt(i4);
            tempLabel.stmtPercentage = new Float((double)(new Float(tempLabel.stmtPercentage).floatValue() / new Float(maxStmtCount).floatValue()) * 100.0).longValue();
            if (current != null) {
                current.addAttribute("stmtcount", String.valueOf(tempLabel.stmtCount));
                current.addAttribute("stmtpercentage", String.valueOf(tempLabel.stmtPercentage));
                current = current.next;
            }
            ++i4;
        }
        statementCount = 0L;
        XMLNode exceptionsNode = methodNode.addChild("exceptions");
        Iterator<Trap> trapIt = body.getTraps().iterator();
        if (trapIt.hasNext()) {
            while (trapIt.hasNext()) {
                Trap trap = trapIt.next();
                XMLNode catchNode = exceptionsNode.addChild("exception", new String[]{"id", "method", "type"}, new String[]{String.valueOf(statementCount++), cleanMethodName, Scene.v().quotedNameOf(trap.getException().getName())});
                catchNode.addChild("begin", new String[]{"label"}, new String[]{stmtToName.get(trap.getBeginUnit()).toString()});
                catchNode.addChild("end", new String[]{"label"}, new String[]{stmtToName.get(trap.getEndUnit()).toString()});
                catchNode.addChild("handler", new String[]{"label"}, new String[]{stmtToName.get(trap.getHandlerUnit()).toString()});
            }
        }
        exceptionsNode.addAttribute("count", String.valueOf(exceptionsNode.getNumberOfChildren()));
    }

    private String cleanMethod(String str) {
        return str.trim().replace('<', '_').replace('>', '_');
    }

    private String cleanLocal(String str) {
        return str.trim();
    }

    private String toCDATA(String str) {
        str = str.replaceAll("]]>", "]]&gt;");
        return "<![CDATA[" + str + "]]>";
    }

    private String boolToString(boolean bool) {
        if (bool) {
            return "true";
        }
        return "false";
    }

    private void printXMLTo(SootClass cl, PrintWriter out) {
        this.root = new XMLRoot();
        XMLNode xmlRootNode = null;
        XMLNode xmlHistoryNode = null;
        XMLNode xmlClassNode = null;
        XMLNode xmlTempNode = null;
        xmlRootNode = this.root.addElement("jil");
        String cmdlineStr = "";
        String[] stringArray = Main.v().cmdLineArgs;
        int n = Main.v().cmdLineArgs.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            cmdlineStr = String.valueOf(cmdlineStr) + element + " ";
            ++n2;
        }
        String dateStr = new Date().toString();
        xmlHistoryNode = xmlRootNode.addChild("history");
        xmlHistoryNode.addAttribute("created", dateStr);
        String[] stringArray2 = new String[]{"version", "command", "timestamp"};
        String[] stringArray3 = new String[3];
        Main.v();
        stringArray3[0] = Main.versionString;
        stringArray3[1] = cmdlineStr.trim();
        stringArray3[2] = dateStr;
        xmlHistoryNode.addChild("soot", stringArray2, stringArray3);
        xmlClassNode = xmlRootNode.addChild("class", new String[]{"name"}, new String[]{Scene.v().quotedNameOf(cl.getName()).toString()});
        if (cl.getPackageName().length() > 0) {
            xmlClassNode.addAttribute("package", cl.getPackageName());
        }
        if (cl.hasSuperclass()) {
            xmlClassNode.addAttribute("extends", Scene.v().quotedNameOf(cl.getSuperclass().getName()).toString());
        }
        xmlTempNode = xmlClassNode.addChild("modifiers");
        StringTokenizer st = new StringTokenizer(Modifier.toString(cl.getModifiers()));
        while (st.hasMoreTokens()) {
            xmlTempNode.addChild("modifier", new String[]{"name"}, new String[]{String.valueOf(st.nextToken())});
        }
        xmlTempNode.addAttribute("count", String.valueOf(xmlTempNode.getNumberOfChildren()));
        xmlTempNode = xmlClassNode.addChild("interfaces", "", new String[]{"count"}, new String[]{String.valueOf(cl.getInterfaceCount())});
        Iterator<SootClass> interfaceIt = cl.getInterfaces().iterator();
        if (interfaceIt.hasNext()) {
            while (interfaceIt.hasNext()) {
                xmlTempNode.addChild("implements", "", new String[]{"class"}, new String[]{Scene.v().quotedNameOf(interfaceIt.next().getName()).toString()});
            }
        }
        xmlTempNode = xmlClassNode.addChild("fields", "", new String[]{"count"}, new String[]{String.valueOf(cl.getFieldCount())});
        Iterator<SootField> fieldIt = cl.getFields().iterator();
        if (fieldIt.hasNext()) {
            int i = 0;
            while (fieldIt.hasNext()) {
                SootField f = fieldIt.next();
                if (f.isPhantom()) continue;
                String type = f.getType().toString();
                String name = f.getName().toString();
                XMLNode xmlFieldNode = xmlTempNode.addChild("field", "", new String[]{"id", "name", "type"}, new String[]{String.valueOf(i++), name, type});
                XMLNode xmlModifiersNode = xmlFieldNode.addChild("modifiers");
                StringTokenizer st2 = new StringTokenizer(Modifier.toString(f.getModifiers()));
                while (st2.hasMoreTokens()) {
                    xmlModifiersNode.addChild("modifier", new String[]{"name"}, new String[]{String.valueOf(st2.nextToken())});
                }
                xmlModifiersNode.addAttribute("count", String.valueOf(xmlModifiersNode.getNumberOfChildren()));
            }
        }
        Iterator<SootMethod> methodIt = cl.methodIterator();
        this.setXMLNode(xmlClassNode.addChild("methods", new String[]{"count"}, new String[]{String.valueOf(cl.getMethodCount())}));
        while (methodIt.hasNext()) {
            SootMethod method = methodIt.next();
            if (method.isPhantom() || Modifier.isAbstract(method.getModifiers()) || Modifier.isNative(method.getModifiers())) continue;
            if (!method.hasActiveBody()) {
                throw new RuntimeException("method " + method.getName() + " has no active body!");
            }
            this.printTo(method.getActiveBody(), out);
        }
        out.println(this.toString());
    }

    public void printJimpleStyleTo(SootClass cl, PrintWriter out) {
        this.printXMLTo(cl, out);
    }

    private void printTo(Body b, PrintWriter out) {
        b.validate();
        this.printStatementsInBody(b, out);
    }

    class XMLLabel {
        public long id;
        public String methodName;
        public String label;
        public long stmtCount;
        public long stmtPercentage;

        public XMLLabel(long in_id, String in_methodName, String in_label) {
            this.id = in_id;
            this.methodName = in_methodName;
            this.label = in_label;
        }
    }
}

