/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class NumericShaper
implements Serializable {
    private static final long serialVersionUID = -8022764705923730308L;
    public static final int EUROPEAN = 1;
    public static final int ARABIC = 2;
    public static final int EASTERN_ARABIC = 4;
    public static final int DEVANAGARI = 8;
    public static final int BENGALI = 16;
    public static final int GURMUKHI = 32;
    public static final int GUJARATI = 64;
    public static final int ORIYA = 128;
    public static final int TAMIL = 256;
    public static final int TELUGU = 512;
    public static final int KANNADA = 1024;
    public static final int MALAYALAM = 2048;
    public static final int THAI = 4096;
    public static final int LAO = 8192;
    public static final int TIBETAN = 16384;
    public static final int MYANMAR = 32768;
    public static final int ETHIOPIC = 65536;
    public static final int KHMER = 131072;
    public static final int MONGOLIAN = 262144;
    public static final int ALL_RANGES = 524287;
    private static final int INDEX_EUROPEAN = 0;
    private static final int INDEX_ARABIC = 1;
    private static final int INDEX_EASTERN_ARABIC = 2;
    private static final int INDEX_DEVANAGARI = 3;
    private static final int INDEX_BENGALI = 4;
    private static final int INDEX_GURMUKHI = 5;
    private static final int INDEX_GUJARATI = 6;
    private static final int INDEX_ORIYA = 7;
    private static final int INDEX_TAMIL = 8;
    private static final int INDEX_TELUGU = 9;
    private static final int INDEX_KANNADA = 10;
    private static final int INDEX_MALAYALAM = 11;
    private static final int INDEX_THAI = 12;
    private static final int INDEX_LAO = 13;
    private static final int INDEX_TIBETAN = 14;
    private static final int INDEX_MYANMAR = 15;
    private static final int INDEX_ETHIOPIC = 16;
    private static final int INDEX_KHMER = 17;
    private static final int INDEX_MONGOLIAN = 18;
    private static final int MAX_INDEX = 19;
    private final int[] scriptsRanges = new int[]{0, 591, 1536, 1791, 1536, 1791, 2304, 2431, 2432, 2559, 2560, 2687, 2688, 2815, 2816, 2943, 2944, 3071, 3072, 3199, 3200, 3327, 3328, 3455, 3584, 3711, 3712, 3839, 3840, 4095, 4096, 4255, 4608, 4991, 6016, 6143, 6144, 6319};
    private final int[] digitsLowRanges = new int[]{0, 1584, 1584, 2358, 2486, 2614, 2742, 2870, 2998, 3126, 3254, 3382, 3616, 3744, 3824, 4112, 4920, 6064, 6112};
    private final String[] contexts = new String[]{"EUROPEAN", "ARABIC", "EASTERN_ARABIC", "DEVANAGARI", "BENGALI", "GURMUKHI", "GUJARATI", "ORIYA", "TAMIL", "TELUGU", "KANNADA", "MALAYALAM", "THAI", "LAO", "TIBETAN", "MYANMAR", "ETHIOPIC", "KHMER", "MONGOLIAN"};
    private static final int[] STRONG_TEXT_FLAGS = new int[]{0, 0, 0x7FFFFFE, 0x7FFFFFE, 0, 0x4200400, -8388609, -8388609, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -65533, -1, -1, -100663297, 196611, 16415, 0, 0, 0, 0x4000000, -10432, -5, -32769, -4194305, -1, -1, -1, -1, -1017, -1, -32769, 0x3FFFFFF, 65535, -131072, -25165825, -2, 767, 0x40000000, -65463, 2033663, -939513841, 0x7FFFFFE, 2047, -73728, -1, -1, 541065215, -67059616, -180225, 65535, -8192, 16383, -1, 131135, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -8, -469762049, -16703999, 537001971, -417812, -473563649, -1333765759, 133431235, -423960, -1016201729, 1577058305, 1900480, -278552, -470942209, 72193, 65475, -417812, 1676541439, -1333782143, 262083, -700594200, -1006647528, 8396230, 524224, -139282, 66059775, 30, 65475, -139284, -470811137, 1080036831, 65475, -139284, -1006633473, 8396225, 65475, -58720276, 0x2FFBFFFF, -16547713, 0x1C0000, -2, 917503, 268402815, 0, -17816170, 537783470, 872349791, 0, -50331649, -1050673153, -257, -2147481601, 3872, -1073741824, 237503, 0, -1, 16914171, 0xFFFFFF, 0, 0, -1, -65473, 0x1FFFFFFF, -1, -1, -2080374785, -1, -1, -249, -1, 0x3FFFFFF, -1, -1, 1031749119, -1, -49665, 2134769663, -8388803, -1, -12713985, -1, 0x7FFFFFF, 0x1FFFFFFF, 65535, -1, -1, 0x1FFFFF, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0x7FFFFF, 0x7FFFFFE, -1, -1, 131071, 253951, 0x63FFFF, 262143, 122879, -1, -1065353217, 401605055, 1023, 0x3FF0000, -1, -1, 0xFFFFFF, -1, 511, 0, 0, 0x1FFFFFFF, 33226872, -64, 0x1F3FFF, -1, -64513, 0x3FF03FF, 0, -830472193, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, 0, 0, -1, -1, -1, -1, 0xFFFFFFF, -1, -1, 0x3FFFFFF, 0x3F3FFFFF, -1, -1426112705, 0x3FFFFFFF, -1, 0x5FDFFFFF, 265232348, 534519807, 49152, 27648, 0, -2147352576, 0x1F0000, 0, 0, 0, 1043332228, -201605808, 992, -1, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -4194304, -1, 0x7FFFFFF, 0x200000, 0, 0, 0, 0, 0, 0, 0, -268435456, -1, -1, 1023, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4096, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -32769, Integer.MAX_VALUE, 0, -1, -1, -1, 31, -1, -65473, -1, 32831, 0x7FFFFF, 0x7F7F7F7F, 0x7F7F7F7F, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 224, 524157950, -2, -1, -528482305, -2, -1, -134217729, -32, -122881, -1, -1, -32769, 0xFFFFFF, 0, -65536, 0x1FFFFFFF, -1, 15, -1879048193, -1, 131071, -61441, Integer.MAX_VALUE, -1, -1, -1, -125829121, -1, -1, 0x3FFFFFFF, Integer.MAX_VALUE, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x200000, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x8000000, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2117, 159, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, Integer.MIN_VALUE, 1, 0, 0, Integer.MIN_VALUE, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, Integer.MIN_VALUE, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, Integer.MIN_VALUE, -1, -1, -1, -1, -1, -1, -1, -1, -1, -49153, -1, -63489, -1, -1, 0x3FFFFFF, 0, -1594359681, 1602223615, -37, -1, -1, 262143, -524288, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0x3FFFFFFF, -65536, -1, -196609, -1, 255, 0x1FFF0000, 0, 0, 0, -2162688, -1, -1, -1, 0x1FFFFFFF, 0, 0x7FFFFFE, 0x7FFFFFE, -64, -1, Integer.MAX_VALUE, 0x1CFCFCFC, 0};
    private int key;
    private int mask;
    private int fRanges;
    private int fDefaultContextIndex;
    private boolean fContextual;
    private int fSingleRangeIndex;

    private NumericShaper(int ranges, int defaultContext, boolean isContextual) {
        this.fRanges = ranges;
        this.fDefaultContextIndex = this.getIndexFromRange(defaultContext);
        this.fContextual = isContextual;
        if (!this.fContextual) {
            this.fSingleRangeIndex = this.getIndexFromRange(ranges);
        }
    }

    private int getIndexFromRange(int range) {
        if (range == 0) {
            throw NumericShaper.rangeException(range);
        }
        for (int index = 0; index < 19; ++index) {
            if (range != 1 << index) continue;
            return index;
        }
        throw NumericShaper.rangeException(range);
    }

    private int getRangeFromIndex(int index) {
        if (index < 0 || index >= 19) {
            throw NumericShaper.rangeException(index);
        }
        return 1 << index;
    }

    private static IllegalArgumentException rangeException(int value) {
        throw new IllegalArgumentException("Illegal range argument value: " + value);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.fRanges;
        result = 31 * result + this.fDefaultContextIndex;
        result = 31 * result + (this.fContextual ? 1 : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        try {
            NumericShaper ns = (NumericShaper)obj;
            return this.fRanges == ns.fRanges && this.fDefaultContextIndex == ns.fDefaultContextIndex && this.fContextual == ns.fContextual;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("[contextual:");
        sb.append(this.fContextual);
        if (this.fContextual) {
            sb.append(", context:");
            sb.append(this.contexts[this.fDefaultContextIndex]);
        }
        sb.append(", range(s): ");
        if (this.fContextual) {
            boolean isFirst = true;
            for (int index = 0; index < 19; ++index) {
                if ((this.fRanges & 1 << index) == 0) continue;
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(this.contexts[index]);
            }
        } else {
            sb.append(this.contexts[this.fSingleRangeIndex]);
        }
        sb.append("]");
        return sb.toString();
    }

    public static NumericShaper getContextualShaper(int ranges, int defaultContext) {
        return new NumericShaper(ranges &= 0x7FFFF, defaultContext &= 0x7FFFF, true);
    }

    public static NumericShaper getContextualShaper(int ranges) {
        return new NumericShaper(ranges &= 0x7FFFF, 1, true);
    }

    public int getRanges() {
        return this.fRanges;
    }

    public static NumericShaper getShaper(int singleRange) {
        return new NumericShaper(singleRange &= 0x7FFFF, 1, false);
    }

    public boolean isContextual() {
        return this.fContextual;
    }

    public void shape(char[] text, int start, int count, int context) {
        if (this.isContextual()) {
            this.contextualShape(text, start, count, this.getIndexFromRange(context));
        } else {
            this.nonContextualShape(text, start, count);
        }
    }

    public void shape(char[] text, int start, int count) {
        if (this.isContextual()) {
            this.contextualShape(text, start, count, this.fDefaultContextIndex);
        } else {
            this.nonContextualShape(text, start, count);
        }
    }

    private void contextualShape(char[] text, int start, int count, int contextIndex) {
        char maxDigit = '9';
        char minDigit = '0';
        int currIndex = (1 << contextIndex & this.fRanges) == 0 ? 0 : contextIndex;
        for (int ind = start; ind < start + count; ++ind) {
            int index;
            if (minDigit <= text[ind] && text[ind] <= maxDigit) {
                if (currIndex == 16 && text[ind] == '0') continue;
                text[ind] = (char)(this.digitsLowRanges[currIndex] + text[ind]);
                continue;
            }
            if (!this.isCharStrong(text[ind]) || currIndex == (index = this.getCharIndex(text[ind]))) continue;
            currIndex = (1 << index & this.fRanges) != 0 ? index : 0;
        }
    }

    private void nonContextualShape(char[] text, int start, int count) {
        char maxDigit = '9';
        char minDigit = (char)(this.fRanges == 65536 ? 49 : 48);
        for (int ind = start; ind < start + count; ++ind) {
            if (minDigit > text[ind] || text[ind] > maxDigit) continue;
            text[ind] = (char)(this.digitsLowRanges[this.fSingleRangeIndex] + text[ind]);
        }
    }

    private int getCharIndex(char ch) {
        int index = 0;
        for (int i = 0; i < 19; ++i) {
            int j = i * 2;
            if (this.scriptsRanges[j] > ch || ch > this.scriptsRanges[j + 1]) continue;
            return i;
        }
        return index;
    }

    private boolean isCharStrong(int chr) {
        return (STRONG_TEXT_FLAGS[chr >> 5] & 1 << chr % 32) != 0;
    }

    private void updateRangesFields() {
        this.fRanges = this.mask & Integer.MAX_VALUE;
        boolean bl = this.fContextual = (this.mask & Integer.MIN_VALUE) != 0;
        if (this.fContextual) {
            this.fRanges = this.mask & Integer.MAX_VALUE;
            this.fDefaultContextIndex = this.key;
        } else {
            this.fRanges = this.mask;
            this.fSingleRangeIndex = this.key;
        }
    }

    private void updateKeyMaskFields() {
        this.mask = this.fRanges;
        if (this.fContextual) {
            this.mask |= Integer.MIN_VALUE;
            this.key = this.fDefaultContextIndex;
        } else {
            this.key = this.fSingleRangeIndex;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.updateKeyMaskFields();
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.updateRangesFields();
    }
}

