/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class BufferedOutputStream
extends FilterOutputStream {
    protected byte[] buf;
    protected int count;

    public BufferedOutputStream(OutputStream out) {
        this(out, 8192);
    }

    public BufferedOutputStream(OutputStream out, int size) {
        super(out);
        if (size <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        this.buf = new byte[size];
    }

    public synchronized void flush() throws IOException {
        this.checkNotClosed();
        this.flushInternal();
        this.out.flush();
    }

    private void checkNotClosed() throws IOException {
        if (this.buf == null) {
            throw new IOException("BufferedOutputStream is closed");
        }
    }

    public synchronized void write(byte[] buffer, int offset, int length) throws IOException {
        this.checkNotClosed();
        if (buffer == null) {
            throw new NullPointerException("buffer == null");
        }
        byte[] internalBuffer = this.buf;
        if (length >= internalBuffer.length) {
            this.flushInternal();
            this.out.write(buffer, offset, length);
            return;
        }
        Arrays.checkOffsetAndCount(buffer.length, offset, length);
        if (length > internalBuffer.length - this.count) {
            this.flushInternal();
        }
        System.arraycopy(buffer, offset, internalBuffer, this.count, length);
        this.count += length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        if (this.buf == null) {
            return;
        }
        try {
            super.close();
        }
        finally {
            this.buf = null;
        }
    }

    public synchronized void write(int oneByte) throws IOException {
        this.checkNotClosed();
        if (this.count == this.buf.length) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
        this.buf[this.count++] = (byte)oneByte;
    }

    private void flushInternal() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }
}

