/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;

public class BufferedReader
extends Reader {
    private Reader in;
    private char[] buf;
    private int pos;
    private int end;
    private int mark = -1;
    private int markLimit = -1;

    public BufferedReader(Reader in) {
        this(in, 8192);
    }

    public BufferedReader(Reader in, int size) {
        super(in);
        if (size <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        this.in = in;
        this.buf = new char[size];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isClosed()) {
                this.in.close();
                this.buf = null;
            }
        }
    }

    private int fillBuf() throws IOException {
        if (this.mark == -1 || this.pos - this.mark >= this.markLimit) {
            int result = this.in.read(this.buf, 0, this.buf.length);
            if (result > 0) {
                this.mark = -1;
                this.pos = 0;
                this.end = result;
            }
            return result;
        }
        if (this.mark == 0 && this.markLimit > this.buf.length) {
            int newLength = this.buf.length * 2;
            if (newLength > this.markLimit) {
                newLength = this.markLimit;
            }
            char[] newbuf = new char[newLength];
            System.arraycopy(this.buf, 0, newbuf, 0, this.buf.length);
            this.buf = newbuf;
        } else if (this.mark > 0) {
            System.arraycopy(this.buf, this.mark, this.buf, 0, this.buf.length - this.mark);
            this.pos -= this.mark;
            this.end -= this.mark;
            this.mark = 0;
        }
        int count = this.in.read(this.buf, this.pos, this.buf.length - this.pos);
        if (count != -1) {
            this.end += count;
        }
        return count;
    }

    private boolean isClosed() {
        return this.buf == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int markLimit) throws IOException {
        if (markLimit < 0) {
            throw new IllegalArgumentException();
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            this.markLimit = markLimit;
            this.mark = this.pos;
        }
    }

    private void checkNotClosed() throws IOException {
        if (this.isClosed()) {
            throw new IOException("BufferedReader is closed");
        }
    }

    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            if (this.pos < this.end || this.fillBuf() != -1) {
                return this.buf[this.pos++];
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] buffer, int offset, int length) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            Arrays.checkOffsetAndCount(buffer.length, offset, length);
            int outstanding = length;
            while (outstanding > 0) {
                int count;
                int available = this.end - this.pos;
                if (available > 0) {
                    count = available >= outstanding ? outstanding : available;
                    System.arraycopy(this.buf, this.pos, buffer, offset, count);
                    this.pos += count;
                    offset += count;
                    outstanding -= count;
                }
                if (outstanding == 0 || outstanding < length && !this.in.ready()) break;
                if ((this.mark == -1 || this.pos - this.mark >= this.markLimit) && outstanding >= this.buf.length) {
                    count = this.in.read(buffer, offset, outstanding);
                    if (count <= 0) break;
                    outstanding -= count;
                    this.mark = -1;
                    break;
                }
                if (this.fillBuf() != -1) continue;
                break;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl24 : MonitorExitStatement: MONITOREXIT : var4_4
            int count = length - outstanding;
            return count > 0 || count == length ? count : -1;
        }
    }

    final void chompNewline() throws IOException {
        if ((this.pos != this.end || this.fillBuf() != -1) && this.buf[this.pos] == '\n') {
            ++this.pos;
        }
    }

    public String readLine() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            if (this.pos == this.end && this.fillBuf() == -1) {
                return null;
            }
            for (int charPos = this.pos; charPos < this.end; ++charPos) {
                char ch = this.buf[charPos];
                if (ch > '\r') continue;
                if (ch == '\n') {
                    String res = new String(this.buf, this.pos, charPos - this.pos);
                    this.pos = charPos + 1;
                    return res;
                }
                if (ch != '\r') continue;
                String res = new String(this.buf, this.pos, charPos - this.pos);
                this.pos = charPos + 1;
                if ((this.pos < this.end || this.fillBuf() != -1) && this.buf[this.pos] == '\n') {
                    ++this.pos;
                }
                return res;
            }
            int eol = 0;
            StringBuilder result = new StringBuilder(80);
            result.append(this.buf, this.pos, this.end - this.pos);
            while (true) {
                this.pos = this.end;
                if (eol == 10) {
                    return result.toString();
                }
                if (this.fillBuf() == -1) {
                    return result.length() > 0 || eol != 0 ? result.toString() : null;
                }
                for (int charPos = this.pos; charPos < this.end; ++charPos) {
                    int c = this.buf[charPos];
                    if (eol == 0) {
                        if (c != 10 && c != 13) continue;
                        eol = c;
                        continue;
                    }
                    if (eol == 13 && c == 10) {
                        if (charPos > this.pos) {
                            result.append(this.buf, this.pos, charPos - this.pos - 1);
                        }
                        this.pos = charPos + 1;
                        return result.toString();
                    }
                    if (charPos > this.pos) {
                        result.append(this.buf, this.pos, charPos - this.pos - 1);
                    }
                    this.pos = charPos;
                    return result.toString();
                }
                if (eol == 0) {
                    result.append(this.buf, this.pos, this.end - this.pos);
                    continue;
                }
                result.append(this.buf, this.pos, this.end - this.pos - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            return this.end - this.pos > 0 || this.in.ready();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            if (this.mark == -1) {
                throw new IOException("Invalid mark");
            }
            this.pos = this.mark;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long byteCount) throws IOException {
        if (byteCount < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + byteCount);
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            if (byteCount < 1L) {
                return 0L;
            }
            if ((long)(this.end - this.pos) >= byteCount) {
                this.pos = (int)((long)this.pos + byteCount);
                return byteCount;
            }
            this.pos = this.end;
            for (long read = (long)(this.end - this.pos); read < byteCount; read += (long)(this.end - this.pos)) {
                if (this.fillBuf() == -1) {
                    return read;
                }
                if ((long)(this.end - this.pos) >= byteCount - read) {
                    this.pos = (int)((long)this.pos + (byteCount - read));
                    return byteCount;
                }
                this.pos = this.end;
            }
            return byteCount;
        }
    }
}

