/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceInputStream
extends InputStream {
    private Enumeration<? extends InputStream> e;
    private InputStream in;

    public SequenceInputStream(InputStream s1, InputStream s2) {
        if (s1 == null) {
            throw new NullPointerException();
        }
        Vector<InputStream> inVector = new Vector<InputStream>(1);
        inVector.addElement(s2);
        this.e = inVector.elements();
        this.in = s1;
    }

    public SequenceInputStream(Enumeration<? extends InputStream> e) {
        this.e = e;
        if (e.hasMoreElements()) {
            this.in = e.nextElement();
            if (this.in == null) {
                throw new NullPointerException();
            }
        }
    }

    @Override
    public int available() throws IOException {
        if (this.e != null && this.in != null) {
            return this.in.available();
        }
        return 0;
    }

    @Override
    public void close() throws IOException {
        while (this.in != null) {
            this.nextStream();
        }
        this.e = null;
    }

    private void nextStream() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        if (this.e.hasMoreElements()) {
            this.in = this.e.nextElement();
            if (this.in == null) {
                throw new NullPointerException();
            }
        } else {
            this.in = null;
        }
    }

    @Override
    public int read() throws IOException {
        while (this.in != null) {
            int result = this.in.read();
            if (result >= 0) {
                return result;
            }
            this.nextStream();
        }
        return -1;
    }

    @Override
    public int read(byte[] buffer, int offset, int count) throws IOException {
        if (this.in == null) {
            return -1;
        }
        Arrays.checkOffsetAndCount(buffer.length, offset, count);
        while (this.in != null) {
            int result = this.in.read(buffer, offset, count);
            if (result >= 0) {
                return result;
            }
            this.nextStream();
        }
        return -1;
    }
}

