/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Locale;

public class StreamTokenizer {
    public double nval;
    public String sval;
    public static final int TT_EOF = -1;
    public static final int TT_EOL = 10;
    public static final int TT_NUMBER = -2;
    public static final int TT_WORD = -3;
    private static final int TT_UNKNOWN = -4;
    public int ttype = -4;
    private byte[] tokenTypes = new byte[256];
    private static final byte TOKEN_COMMENT = 1;
    private static final byte TOKEN_QUOTE = 2;
    private static final byte TOKEN_WHITE = 4;
    private static final byte TOKEN_WORD = 8;
    private static final byte TOKEN_DIGIT = 16;
    private int lineNumber = 1;
    private boolean forceLowercase;
    private boolean isEOLSignificant;
    private boolean slashStarComments;
    private boolean slashSlashComments;
    private boolean pushBackToken;
    private boolean lastCr;
    private InputStream inStream;
    private Reader inReader;
    private int peekChar = -2;

    private StreamTokenizer() {
        this.wordChars(65, 90);
        this.wordChars(97, 122);
        this.wordChars(160, 255);
        this.whitespaceChars(0, 32);
        this.commentChar(47);
        this.quoteChar(34);
        this.quoteChar(39);
        this.parseNumbers();
    }

    @Deprecated
    public StreamTokenizer(InputStream is) {
        this();
        if (is == null) {
            throw new NullPointerException();
        }
        this.inStream = is;
    }

    public StreamTokenizer(Reader r) {
        this();
        if (r == null) {
            throw new NullPointerException();
        }
        this.inReader = r;
    }

    public void commentChar(int ch) {
        if (ch >= 0 && ch < this.tokenTypes.length) {
            this.tokenTypes[ch] = 1;
        }
    }

    public void eolIsSignificant(boolean flag) {
        this.isEOLSignificant = flag;
    }

    public int lineno() {
        return this.lineNumber;
    }

    public void lowerCaseMode(boolean flag) {
        this.forceLowercase = flag;
    }

    public int nextToken() throws IOException {
        int currentType;
        int currentChar;
        if (this.pushBackToken) {
            this.pushBackToken = false;
            if (this.ttype != -4) {
                return this.ttype;
            }
        }
        this.sval = null;
        int n = currentChar = this.peekChar == -2 ? this.read() : this.peekChar;
        if (this.lastCr && currentChar == 10) {
            this.lastCr = false;
            currentChar = this.read();
        }
        if (currentChar == -1) {
            this.ttype = -1;
            return -1;
        }
        int n2 = currentType = currentChar > 255 ? 8 : this.tokenTypes[currentChar];
        while ((currentType & 4) != 0) {
            if (currentChar == 13) {
                ++this.lineNumber;
                if (this.isEOLSignificant) {
                    this.lastCr = true;
                    this.peekChar = -2;
                    this.ttype = 10;
                    return 10;
                }
                currentChar = this.read();
                if (currentChar == 10) {
                    currentChar = this.read();
                }
            } else if (currentChar == 10) {
                ++this.lineNumber;
                if (this.isEOLSignificant) {
                    this.peekChar = -2;
                    this.ttype = 10;
                    return 10;
                }
                currentChar = this.read();
            } else {
                currentChar = this.read();
            }
            if (currentChar == -1) {
                this.ttype = -1;
                return -1;
            }
            currentType = currentChar > 255 ? 8 : this.tokenTypes[currentChar];
        }
        if ((currentType & 0x10) != 0) {
            boolean checkJustNegative;
            StringBuilder digits = new StringBuilder(20);
            boolean haveDecimal = false;
            boolean bl = checkJustNegative = currentChar == 45;
            do {
                if (currentChar == 46) {
                    haveDecimal = true;
                }
                digits.append((char)currentChar);
            } while ((currentChar = this.read()) >= 48 && currentChar <= 57 || !haveDecimal && currentChar == 46);
            this.peekChar = currentChar;
            if (checkJustNegative && digits.length() == 1) {
                this.ttype = 45;
                return 45;
            }
            try {
                this.nval = Double.valueOf(digits.toString());
            }
            catch (NumberFormatException e) {
                this.nval = 0.0;
            }
            this.ttype = -2;
            return -2;
        }
        if ((currentType & 8) != 0) {
            StringBuilder word = new StringBuilder(20);
            do {
                word.append((char)currentChar);
            } while ((currentChar = this.read()) != -1 && (currentChar >= 256 || (this.tokenTypes[currentChar] & 0x18) != 0));
            this.peekChar = currentChar;
            this.sval = word.toString();
            if (this.forceLowercase) {
                this.sval = this.sval.toLowerCase(Locale.getDefault());
            }
            this.ttype = -3;
            return -3;
        }
        if (currentType == 2) {
            int matchQuote = currentChar;
            StringBuilder quoteString = new StringBuilder();
            int peekOne = this.read();
            while (peekOne >= 0 && peekOne != matchQuote && peekOne != 13 && peekOne != 10) {
                boolean readPeek = true;
                if (peekOne == 92) {
                    int c1 = this.read();
                    if (c1 <= 55 && c1 >= 48) {
                        int digitValue = c1 - 48;
                        c1 = this.read();
                        if (c1 > 55 || c1 < 48) {
                            readPeek = false;
                        } else {
                            digitValue = digitValue * 8 + (c1 - 48);
                            c1 = this.read();
                            if (digitValue > 31 || c1 > 55 || c1 < 48) {
                                readPeek = false;
                            } else {
                                digitValue = digitValue * 8 + (c1 - 48);
                            }
                        }
                        if (!readPeek) {
                            quoteString.append((char)digitValue);
                            peekOne = c1;
                        } else {
                            peekOne = digitValue;
                        }
                    } else {
                        switch (c1) {
                            case 97: {
                                peekOne = 7;
                                break;
                            }
                            case 98: {
                                peekOne = 8;
                                break;
                            }
                            case 102: {
                                peekOne = 12;
                                break;
                            }
                            case 110: {
                                peekOne = 10;
                                break;
                            }
                            case 114: {
                                peekOne = 13;
                                break;
                            }
                            case 116: {
                                peekOne = 9;
                                break;
                            }
                            case 118: {
                                peekOne = 11;
                                break;
                            }
                            default: {
                                peekOne = c1;
                            }
                        }
                    }
                }
                if (!readPeek) continue;
                quoteString.append((char)peekOne);
                peekOne = this.read();
            }
            if (peekOne == matchQuote) {
                peekOne = this.read();
            }
            this.peekChar = peekOne;
            this.ttype = matchQuote;
            this.sval = quoteString.toString();
            return this.ttype;
        }
        if (currentChar == 47 && (this.slashSlashComments || this.slashStarComments)) {
            currentChar = this.read();
            if (currentChar == 42 && this.slashStarComments) {
                int peekOne = this.read();
                while (true) {
                    currentChar = peekOne;
                    peekOne = this.read();
                    if (currentChar == -1) {
                        this.peekChar = -1;
                        this.ttype = -1;
                        return -1;
                    }
                    if (currentChar == 13) {
                        if (peekOne == 10) {
                            peekOne = this.read();
                        }
                        ++this.lineNumber;
                        continue;
                    }
                    if (currentChar == 10) {
                        ++this.lineNumber;
                        continue;
                    }
                    if (currentChar == 42 && peekOne == 47) break;
                }
                this.peekChar = this.read();
                return this.nextToken();
            }
            if (currentChar == 47 && this.slashSlashComments) {
                while ((currentChar = this.read()) >= 0 && currentChar != 13 && currentChar != 10) {
                }
                this.peekChar = currentChar;
                return this.nextToken();
            }
            if (currentType != 1) {
                this.peekChar = currentChar;
                this.ttype = 47;
                return 47;
            }
        }
        if (currentType == 1) {
            while ((currentChar = this.read()) >= 0 && currentChar != 13 && currentChar != 10) {
            }
            this.peekChar = currentChar;
            return this.nextToken();
        }
        this.peekChar = this.read();
        this.ttype = currentChar;
        return this.ttype;
    }

    public void ordinaryChar(int ch) {
        if (ch >= 0 && ch < this.tokenTypes.length) {
            this.tokenTypes[ch] = 0;
        }
    }

    public void ordinaryChars(int low, int hi) {
        if (low < 0) {
            low = 0;
        }
        if (hi > this.tokenTypes.length) {
            hi = this.tokenTypes.length - 1;
        }
        for (int i = low; i <= hi; ++i) {
            this.tokenTypes[i] = 0;
        }
    }

    public void parseNumbers() {
        int i = 48;
        while (i <= 57) {
            int n = i++;
            this.tokenTypes[n] = (byte)(this.tokenTypes[n] | 0x10);
        }
        this.tokenTypes[46] = (byte)(this.tokenTypes[46] | 0x10);
        this.tokenTypes[45] = (byte)(this.tokenTypes[45] | 0x10);
    }

    public void pushBack() {
        this.pushBackToken = true;
    }

    public void quoteChar(int ch) {
        if (ch >= 0 && ch < this.tokenTypes.length) {
            this.tokenTypes[ch] = 2;
        }
    }

    private int read() throws IOException {
        if (this.inStream == null) {
            return this.inReader.read();
        }
        return this.inStream.read();
    }

    public void resetSyntax() {
        for (int i = 0; i < 256; ++i) {
            this.tokenTypes[i] = 0;
        }
    }

    public void slashSlashComments(boolean flag) {
        this.slashSlashComments = flag;
    }

    public void slashStarComments(boolean flag) {
        this.slashStarComments = flag;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Token[");
        switch (this.ttype) {
            case -1: {
                result.append("EOF");
                break;
            }
            case 10: {
                result.append("EOL");
                break;
            }
            case -2: {
                result.append("n=");
                result.append(this.nval);
                break;
            }
            case -3: {
                result.append(this.sval);
                break;
            }
            default: {
                if (this.ttype == -4 || this.tokenTypes[this.ttype] == 2) {
                    result.append(this.sval);
                    break;
                }
                result.append('\'');
                result.append((char)this.ttype);
                result.append('\'');
            }
        }
        result.append("], line ");
        result.append(this.lineNumber);
        return result.toString();
    }

    public void whitespaceChars(int low, int hi) {
        if (low < 0) {
            low = 0;
        }
        if (hi > this.tokenTypes.length) {
            hi = this.tokenTypes.length - 1;
        }
        for (int i = low; i <= hi; ++i) {
            this.tokenTypes[i] = 4;
        }
    }

    public void wordChars(int low, int hi) {
        if (low < 0) {
            low = 0;
        }
        if (hi > this.tokenTypes.length) {
            hi = this.tokenTypes.length - 1;
        }
        int i = low;
        while (i <= hi) {
            int n = i++;
            this.tokenTypes[n] = (byte)(this.tokenTypes[n] | 8);
        }
    }
}

