/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FindBugsSuppressWarnings(value={"DM_NUMBER_CTOR"})
public final class Character
implements Serializable,
Comparable<Character> {
    private static final long serialVersionUID = 3786198910865385080L;
    private final char value;
    public static final char MIN_VALUE = '\u0000';
    public static final char MAX_VALUE = '\uffff';
    public static final int MIN_RADIX = 2;
    public static final int MAX_RADIX = 36;
    public static final Class<Character> TYPE = char[].class.getComponentType();
    public static final byte UNASSIGNED = 0;
    public static final byte UPPERCASE_LETTER = 1;
    public static final byte LOWERCASE_LETTER = 2;
    public static final byte TITLECASE_LETTER = 3;
    public static final byte MODIFIER_LETTER = 4;
    public static final byte OTHER_LETTER = 5;
    public static final byte NON_SPACING_MARK = 6;
    public static final byte ENCLOSING_MARK = 7;
    public static final byte COMBINING_SPACING_MARK = 8;
    public static final byte DECIMAL_DIGIT_NUMBER = 9;
    public static final byte LETTER_NUMBER = 10;
    public static final byte OTHER_NUMBER = 11;
    public static final byte SPACE_SEPARATOR = 12;
    public static final byte LINE_SEPARATOR = 13;
    public static final byte PARAGRAPH_SEPARATOR = 14;
    public static final byte CONTROL = 15;
    public static final byte FORMAT = 16;
    public static final byte PRIVATE_USE = 18;
    public static final byte SURROGATE = 19;
    public static final byte DASH_PUNCTUATION = 20;
    public static final byte START_PUNCTUATION = 21;
    public static final byte END_PUNCTUATION = 22;
    public static final byte CONNECTOR_PUNCTUATION = 23;
    public static final byte OTHER_PUNCTUATION = 24;
    public static final byte MATH_SYMBOL = 25;
    public static final byte CURRENCY_SYMBOL = 26;
    public static final byte MODIFIER_SYMBOL = 27;
    public static final byte OTHER_SYMBOL = 28;
    public static final byte INITIAL_QUOTE_PUNCTUATION = 29;
    public static final byte FINAL_QUOTE_PUNCTUATION = 30;
    public static final byte DIRECTIONALITY_UNDEFINED = -1;
    public static final byte DIRECTIONALITY_LEFT_TO_RIGHT = 0;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT = 1;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT_ARABIC = 2;
    public static final byte DIRECTIONALITY_EUROPEAN_NUMBER = 3;
    public static final byte DIRECTIONALITY_EUROPEAN_NUMBER_SEPARATOR = 4;
    public static final byte DIRECTIONALITY_EUROPEAN_NUMBER_TERMINATOR = 5;
    public static final byte DIRECTIONALITY_ARABIC_NUMBER = 6;
    public static final byte DIRECTIONALITY_COMMON_NUMBER_SEPARATOR = 7;
    public static final byte DIRECTIONALITY_NONSPACING_MARK = 8;
    public static final byte DIRECTIONALITY_BOUNDARY_NEUTRAL = 9;
    public static final byte DIRECTIONALITY_PARAGRAPH_SEPARATOR = 10;
    public static final byte DIRECTIONALITY_SEGMENT_SEPARATOR = 11;
    public static final byte DIRECTIONALITY_WHITESPACE = 12;
    public static final byte DIRECTIONALITY_OTHER_NEUTRALS = 13;
    public static final byte DIRECTIONALITY_LEFT_TO_RIGHT_EMBEDDING = 14;
    public static final byte DIRECTIONALITY_LEFT_TO_RIGHT_OVERRIDE = 15;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT_EMBEDDING = 16;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT_OVERRIDE = 17;
    public static final byte DIRECTIONALITY_POP_DIRECTIONAL_FORMAT = 18;
    public static final char MIN_HIGH_SURROGATE = '\ud800';
    public static final char MAX_HIGH_SURROGATE = '\udbff';
    public static final char MIN_LOW_SURROGATE = '\udc00';
    public static final char MAX_LOW_SURROGATE = '\udfff';
    public static final char MIN_SURROGATE = '\ud800';
    public static final char MAX_SURROGATE = '\udfff';
    public static final int MIN_SUPPLEMENTARY_CODE_POINT = 65536;
    public static final int MIN_CODE_POINT = 0;
    public static final int MAX_CODE_POINT = 0x10FFFF;
    public static final int SIZE = 16;
    private static final byte[] DIRECTIONALITY = new byte[]{0, 1, 3, 4, 5, 6, 7, 10, 11, 12, 13, 14, 15, 2, 16, 17, 18, 8, 9};
    private static final Character[] SMALL_VALUES = new Character[128];

    private static native int forNameImpl(String var0);

    private static native int ofImpl(int var0);

    public Character(char value) {
        this.value = value;
    }

    public char charValue() {
        return this.value;
    }

    private static void checkValidCodePoint(int codePoint) {
        if (!Character.isValidCodePoint(codePoint)) {
            throw new IllegalArgumentException("Invalid code point: " + codePoint);
        }
    }

    @Override
    public int compareTo(Character c) {
        return Character.compare(this.value, c.value);
    }

    public static int compare(char lhs, char rhs) {
        return lhs - rhs;
    }

    public static Character valueOf(char c) {
        return c < '\u0080' ? SMALL_VALUES[c] : new Character(c);
    }

    public static boolean isValidCodePoint(int codePoint) {
        return 0 <= codePoint && 0x10FFFF >= codePoint;
    }

    public static boolean isSupplementaryCodePoint(int codePoint) {
        return 65536 <= codePoint && 0x10FFFF >= codePoint;
    }

    public static boolean isHighSurrogate(char ch) {
        return '\ud800' <= ch && '\udbff' >= ch;
    }

    public static boolean isLowSurrogate(char ch) {
        return '\udc00' <= ch && '\udfff' >= ch;
    }

    public static boolean isSurrogate(char ch) {
        return ch >= '\ud800' && ch <= '\udfff';
    }

    public static boolean isSurrogatePair(char high, char low) {
        return Character.isHighSurrogate(high) && Character.isLowSurrogate(low);
    }

    public static int charCount(int codePoint) {
        return codePoint >= 65536 ? 2 : 1;
    }

    public static int toCodePoint(char high, char low) {
        int h = (high & 0x3FF) << 10;
        int l = low & 0x3FF;
        return (h | l) + 65536;
    }

    public static int codePointAt(CharSequence seq, int index) {
        if (seq == null) {
            throw new NullPointerException();
        }
        int len = seq.length();
        if (index < 0 || index >= len) {
            throw new IndexOutOfBoundsException();
        }
        char high = seq.charAt(index++);
        if (index >= len) {
            return high;
        }
        char low = seq.charAt(index);
        if (Character.isSurrogatePair(high, low)) {
            return Character.toCodePoint(high, low);
        }
        return high;
    }

    public static int codePointAt(char[] seq, int index) {
        if (seq == null) {
            throw new NullPointerException();
        }
        int len = seq.length;
        if (index < 0 || index >= len) {
            throw new IndexOutOfBoundsException();
        }
        char high = seq[index++];
        if (index >= len) {
            return high;
        }
        char low = seq[index];
        if (Character.isSurrogatePair(high, low)) {
            return Character.toCodePoint(high, low);
        }
        return high;
    }

    public static int codePointAt(char[] seq, int index, int limit) {
        if (index < 0 || index >= limit || limit < 0 || limit > seq.length) {
            throw new IndexOutOfBoundsException();
        }
        char high = seq[index++];
        if (index >= limit) {
            return high;
        }
        char low = seq[index];
        if (Character.isSurrogatePair(high, low)) {
            return Character.toCodePoint(high, low);
        }
        return high;
    }

    public static int codePointBefore(CharSequence seq, int index) {
        if (seq == null) {
            throw new NullPointerException();
        }
        int len = seq.length();
        if (index < 1 || index > len) {
            throw new IndexOutOfBoundsException();
        }
        char low = seq.charAt(--index);
        if (--index < 0) {
            return low;
        }
        char high = seq.charAt(index);
        if (Character.isSurrogatePair(high, low)) {
            return Character.toCodePoint(high, low);
        }
        return low;
    }

    public static int codePointBefore(char[] seq, int index) {
        if (seq == null) {
            throw new NullPointerException();
        }
        int len = seq.length;
        if (index < 1 || index > len) {
            throw new IndexOutOfBoundsException();
        }
        char low = seq[--index];
        if (--index < 0) {
            return low;
        }
        char high = seq[index];
        if (Character.isSurrogatePair(high, low)) {
            return Character.toCodePoint(high, low);
        }
        return low;
    }

    public static int codePointBefore(char[] seq, int index, int start) {
        if (seq == null) {
            throw new NullPointerException();
        }
        int len = seq.length;
        if (index <= start || index > len || start < 0 || start >= len) {
            throw new IndexOutOfBoundsException();
        }
        char low = seq[--index];
        if (--index < start) {
            return low;
        }
        char high = seq[index];
        if (Character.isSurrogatePair(high, low)) {
            return Character.toCodePoint(high, low);
        }
        return low;
    }

    public static int toChars(int codePoint, char[] dst, int dstIndex) {
        Character.checkValidCodePoint(codePoint);
        if (dst == null) {
            throw new NullPointerException();
        }
        if (dstIndex < 0 || dstIndex >= dst.length) {
            throw new IndexOutOfBoundsException();
        }
        if (Character.isSupplementaryCodePoint(codePoint)) {
            if (dstIndex == dst.length - 1) {
                throw new IndexOutOfBoundsException();
            }
            int cpPrime = codePoint - 65536;
            int high = 0xD800 | cpPrime >> 10 & 0x3FF;
            int low = 0xDC00 | cpPrime & 0x3FF;
            dst[dstIndex] = (char)high;
            dst[dstIndex + 1] = (char)low;
            return 2;
        }
        dst[dstIndex] = (char)codePoint;
        return 1;
    }

    public static char[] toChars(int codePoint) {
        Character.checkValidCodePoint(codePoint);
        if (Character.isSupplementaryCodePoint(codePoint)) {
            int cpPrime = codePoint - 65536;
            int high = 0xD800 | cpPrime >> 10 & 0x3FF;
            int low = 0xDC00 | cpPrime & 0x3FF;
            return new char[]{(char)high, (char)low};
        }
        return new char[]{(char)codePoint};
    }

    public static int codePointCount(CharSequence seq, int beginIndex, int endIndex) {
        if (seq == null) {
            throw new NullPointerException();
        }
        int len = seq.length();
        if (beginIndex < 0 || endIndex > len || beginIndex > endIndex) {
            throw new IndexOutOfBoundsException();
        }
        int result = 0;
        for (int i = beginIndex; i < endIndex; ++i) {
            char c = seq.charAt(i);
            if (Character.isHighSurrogate(c) && ++i < endIndex && !Character.isLowSurrogate(c = seq.charAt(i))) {
                ++result;
            }
            ++result;
        }
        return result;
    }

    public static int codePointCount(char[] seq, int offset, int count) {
        Arrays.checkOffsetAndCount(seq.length, offset, count);
        int endIndex = offset + count;
        int result = 0;
        for (int i = offset; i < endIndex; ++i) {
            char c = seq[i];
            if (Character.isHighSurrogate(c) && ++i < endIndex && !Character.isLowSurrogate(c = seq[i])) {
                ++result;
            }
            ++result;
        }
        return result;
    }

    public static int offsetByCodePoints(CharSequence seq, int index, int codePointOffset) {
        if (seq == null) {
            throw new NullPointerException();
        }
        int len = seq.length();
        if (index < 0 || index > len) {
            throw new IndexOutOfBoundsException();
        }
        if (codePointOffset == 0) {
            return index;
        }
        if (codePointOffset > 0) {
            int codePoints = codePointOffset;
            int i = index;
            while (codePoints > 0) {
                int next;
                --codePoints;
                if (i >= len) {
                    throw new IndexOutOfBoundsException();
                }
                if (Character.isHighSurrogate(seq.charAt(i)) && (next = i + 1) < len && Character.isLowSurrogate(seq.charAt(next))) {
                    ++i;
                }
                ++i;
            }
            return i;
        }
        int codePoints = -codePointOffset;
        int i = index;
        while (codePoints > 0) {
            int prev;
            --codePoints;
            if (--i < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (!Character.isLowSurrogate(seq.charAt(i)) || (prev = i - 1) < 0 || !Character.isHighSurrogate(seq.charAt(prev))) continue;
            --i;
        }
        return i;
    }

    public static int offsetByCodePoints(char[] seq, int start, int count, int index, int codePointOffset) {
        Arrays.checkOffsetAndCount(seq.length, start, count);
        int end = start + count;
        if (index < start || index > end) {
            throw new IndexOutOfBoundsException();
        }
        if (codePointOffset == 0) {
            return index;
        }
        if (codePointOffset > 0) {
            int codePoints = codePointOffset;
            int i = index;
            while (codePoints > 0) {
                int next;
                --codePoints;
                if (i >= end) {
                    throw new IndexOutOfBoundsException();
                }
                if (Character.isHighSurrogate(seq[i]) && (next = i + 1) < end && Character.isLowSurrogate(seq[next])) {
                    ++i;
                }
                ++i;
            }
            return i;
        }
        int codePoints = -codePointOffset;
        int i = index;
        while (codePoints > 0) {
            int prev;
            --codePoints;
            if (--i < start) {
                throw new IndexOutOfBoundsException();
            }
            if (!Character.isLowSurrogate(seq[i]) || (prev = i - 1) < start || !Character.isHighSurrogate(seq[prev])) continue;
            --i;
        }
        return i;
    }

    public static int digit(char c, int radix) {
        return Character.digit((int)c, radix);
    }

    public static int digit(int codePoint, int radix) {
        if (radix < 2 || radix > 36) {
            return -1;
        }
        if (codePoint < 128) {
            int result = -1;
            if (48 <= codePoint && codePoint <= 57) {
                result = codePoint - 48;
            } else if (97 <= codePoint && codePoint <= 122) {
                result = 10 + (codePoint - 97);
            } else if (65 <= codePoint && codePoint <= 90) {
                result = 10 + (codePoint - 65);
            }
            return result < radix ? result : -1;
        }
        return Character.digitImpl(codePoint, radix);
    }

    private static native int digitImpl(int var0, int var1);

    public boolean equals(Object object) {
        return object instanceof Character && ((Character)object).value == this.value;
    }

    public static char forDigit(int digit, int radix) {
        if (2 <= radix && radix <= 36 && digit >= 0 && digit < radix) {
            return (char)(digit < 10 ? digit + 48 : digit + 97 - 10);
        }
        return '\u0000';
    }

    public static String getName(int codePoint) {
        Character.checkValidCodePoint(codePoint);
        if (Character.getType(codePoint) == 0) {
            return null;
        }
        String result = Character.getNameImpl(codePoint);
        if (result == null) {
            String blockName = UnicodeBlock.of(codePoint).toString().replace('_', ' ');
            result = blockName + " " + IntegralToString.intToHexString(codePoint, true, 0);
        }
        return result;
    }

    private static native String getNameImpl(int var0);

    public static int getNumericValue(char c) {
        return Character.getNumericValue((int)c);
    }

    public static int getNumericValue(int codePoint) {
        if (codePoint < 128) {
            if (codePoint >= 48 && codePoint <= 57) {
                return codePoint - 48;
            }
            if (codePoint >= 97 && codePoint <= 122) {
                return codePoint - 87;
            }
            if (codePoint >= 65 && codePoint <= 90) {
                return codePoint - 55;
            }
            return -1;
        }
        if (codePoint >= 65313 && codePoint <= 65338) {
            return codePoint - 65303;
        }
        if (codePoint >= 65345 && codePoint <= 65370) {
            return codePoint - 65335;
        }
        return Character.getNumericValueImpl(codePoint);
    }

    private static native int getNumericValueImpl(int var0);

    public static int getType(char c) {
        return Character.getType((int)c);
    }

    public static int getType(int codePoint) {
        int type = Character.getTypeImpl(codePoint);
        if (type <= 16) {
            return type;
        }
        return type + 1;
    }

    private static native int getTypeImpl(int var0);

    public static byte getDirectionality(char c) {
        return Character.getDirectionality((int)c);
    }

    public static byte getDirectionality(int codePoint) {
        if (Character.getType(codePoint) == 0) {
            return -1;
        }
        byte directionality = Character.getDirectionalityImpl(codePoint);
        if (directionality == -1) {
            return -1;
        }
        return DIRECTIONALITY[directionality];
    }

    private static native byte getDirectionalityImpl(int var0);

    public static boolean isMirrored(char c) {
        return Character.isMirrored((int)c);
    }

    public static boolean isMirrored(int codePoint) {
        return Character.isMirroredImpl(codePoint);
    }

    private static native boolean isMirroredImpl(int var0);

    public int hashCode() {
        return this.value;
    }

    public static char highSurrogate(int codePoint) {
        return (char)((codePoint >> 10) + 55232);
    }

    public static char lowSurrogate(int codePoint) {
        return (char)(codePoint & 0x3FF | 0xDC00);
    }

    public static boolean isBmpCodePoint(int codePoint) {
        return codePoint >= 0 && codePoint <= 65535;
    }

    public static boolean isDefined(char c) {
        return Character.isDefinedImpl(c);
    }

    public static boolean isDefined(int codePoint) {
        return Character.isDefinedImpl(codePoint);
    }

    private static native boolean isDefinedImpl(int var0);

    public static boolean isDigit(char c) {
        return Character.isDigit((int)c);
    }

    public static boolean isDigit(int codePoint) {
        if (48 <= codePoint && codePoint <= 57) {
            return true;
        }
        if (codePoint < 1632) {
            return false;
        }
        return Character.isDigitImpl(codePoint);
    }

    private static native boolean isDigitImpl(int var0);

    public static boolean isIdentifierIgnorable(char c) {
        return Character.isIdentifierIgnorable((int)c);
    }

    public static boolean isIdentifierIgnorable(int codePoint) {
        if (codePoint < 1536) {
            return codePoint >= 0 && codePoint <= 8 || codePoint >= 14 && codePoint <= 27 || codePoint >= 127 && codePoint <= 159 || codePoint == 173;
        }
        return Character.isIdentifierIgnorableImpl(codePoint);
    }

    private static native boolean isIdentifierIgnorableImpl(int var0);

    public static boolean isISOControl(char c) {
        return Character.isISOControl((int)c);
    }

    public static boolean isISOControl(int c) {
        return c >= 0 && c <= 31 || c >= 127 && c <= 159;
    }

    public static boolean isJavaIdentifierPart(char c) {
        return Character.isJavaIdentifierPart((int)c);
    }

    public static boolean isJavaIdentifierPart(int codePoint) {
        if (codePoint < 64) {
            return (0x3FF00100FFFC1FFL & 1L << codePoint) != 0L;
        }
        if (codePoint < 128) {
            return (0x87FFFFFE87FFFFFEL & 1L << codePoint - 64) != 0L;
        }
        int type = Character.getType(codePoint);
        return type >= 1 && type <= 5 || type == 26 || type == 23 || type >= 9 && type <= 10 || type == 8 || type == 6 || codePoint >= 0 && codePoint <= 8 || codePoint >= 14 && codePoint <= 27 || codePoint >= 127 && codePoint <= 159 || type == 16;
    }

    public static boolean isJavaIdentifierStart(char c) {
        return Character.isJavaIdentifierStart((int)c);
    }

    public static boolean isJavaIdentifierStart(int codePoint) {
        if (codePoint < 64) {
            return codePoint == 36;
        }
        if (codePoint < 128) {
            return (0x7FFFFFE87FFFFFEL & 1L << codePoint - 64) != 0L;
        }
        int type = Character.getType(codePoint);
        return type >= 1 && type <= 5 || type == 26 || type == 23 || type == 10;
    }

    @Deprecated
    public static boolean isJavaLetter(char c) {
        return Character.isJavaIdentifierStart(c);
    }

    @Deprecated
    public static boolean isJavaLetterOrDigit(char c) {
        return Character.isJavaIdentifierPart(c);
    }

    public static boolean isLetter(char c) {
        return Character.isLetter((int)c);
    }

    public static boolean isLetter(int codePoint) {
        if (65 <= codePoint && codePoint <= 90 || 97 <= codePoint && codePoint <= 122) {
            return true;
        }
        if (codePoint < 128) {
            return false;
        }
        return Character.isLetterImpl(codePoint);
    }

    private static native boolean isLetterImpl(int var0);

    public static boolean isLetterOrDigit(char c) {
        return Character.isLetterOrDigit((int)c);
    }

    public static boolean isLetterOrDigit(int codePoint) {
        if (65 <= codePoint && codePoint <= 90 || 97 <= codePoint && codePoint <= 122) {
            return true;
        }
        if (48 <= codePoint && codePoint <= 57) {
            return true;
        }
        if (codePoint < 128) {
            return false;
        }
        return Character.isLetterOrDigitImpl(codePoint);
    }

    private static native boolean isLetterOrDigitImpl(int var0);

    public static boolean isLowerCase(char c) {
        return Character.isLowerCase((int)c);
    }

    public static boolean isLowerCase(int codePoint) {
        if (97 <= codePoint && codePoint <= 122) {
            return true;
        }
        if (codePoint < 128) {
            return false;
        }
        return Character.isLowerCaseImpl(codePoint);
    }

    private static native boolean isLowerCaseImpl(int var0);

    @Deprecated
    public static boolean isSpace(char c) {
        return c == '\n' || c == '\t' || c == '\f' || c == '\r' || c == ' ';
    }

    public static boolean isSpaceChar(char c) {
        return Character.isSpaceChar((int)c);
    }

    public static boolean isSpaceChar(int codePoint) {
        if (codePoint == 32 || codePoint == 160 || codePoint == 5760) {
            return true;
        }
        if (codePoint < 8192) {
            return false;
        }
        if (codePoint <= 65535) {
            return codePoint <= 8203 || codePoint == 8232 || codePoint == 8233 || codePoint == 8239 || codePoint == 12288;
        }
        return Character.isSpaceCharImpl(codePoint);
    }

    private static native boolean isSpaceCharImpl(int var0);

    public static boolean isTitleCase(char c) {
        return Character.isTitleCaseImpl(c);
    }

    public static boolean isTitleCase(int codePoint) {
        return Character.isTitleCaseImpl(codePoint);
    }

    private static native boolean isTitleCaseImpl(int var0);

    public static boolean isUnicodeIdentifierPart(char c) {
        return Character.isUnicodeIdentifierPartImpl(c);
    }

    public static boolean isUnicodeIdentifierPart(int codePoint) {
        return Character.isUnicodeIdentifierPartImpl(codePoint);
    }

    private static native boolean isUnicodeIdentifierPartImpl(int var0);

    public static boolean isUnicodeIdentifierStart(char c) {
        return Character.isUnicodeIdentifierStartImpl(c);
    }

    public static boolean isUnicodeIdentifierStart(int codePoint) {
        return Character.isUnicodeIdentifierStartImpl(codePoint);
    }

    private static native boolean isUnicodeIdentifierStartImpl(int var0);

    public static boolean isUpperCase(char c) {
        return Character.isUpperCase((int)c);
    }

    public static boolean isUpperCase(int codePoint) {
        if (65 <= codePoint && codePoint <= 90) {
            return true;
        }
        if (codePoint < 128) {
            return false;
        }
        return Character.isUpperCaseImpl(codePoint);
    }

    private static native boolean isUpperCaseImpl(int var0);

    public static boolean isWhitespace(char c) {
        return Character.isWhitespace((int)c);
    }

    public static boolean isWhitespace(int codePoint) {
        if (codePoint >= 28 && codePoint <= 32 || codePoint >= 9 && codePoint <= 13) {
            return true;
        }
        if (codePoint == 5760) {
            return true;
        }
        if (codePoint < 8192 || codePoint == 8199) {
            return false;
        }
        if (codePoint <= 65535) {
            return codePoint <= 8203 || codePoint == 8232 || codePoint == 8233 || codePoint == 12288;
        }
        return Character.isWhitespaceImpl(codePoint);
    }

    private static native boolean isWhitespaceImpl(int var0);

    public static char reverseBytes(char c) {
        return (char)(c << 8 | c >> 8);
    }

    public static char toLowerCase(char c) {
        return (char)Character.toLowerCase((int)c);
    }

    public static int toLowerCase(int codePoint) {
        if (65 <= codePoint && codePoint <= 90) {
            return (char)(codePoint + 32);
        }
        if (codePoint < 192) {
            return codePoint;
        }
        return Character.toLowerCaseImpl(codePoint);
    }

    private static native int toLowerCaseImpl(int var0);

    public String toString() {
        return String.valueOf(this.value);
    }

    public static String toString(char value) {
        return String.valueOf(value);
    }

    public static char toTitleCase(char c) {
        return (char)Character.toTitleCaseImpl(c);
    }

    public static int toTitleCase(int codePoint) {
        return Character.toTitleCaseImpl(codePoint);
    }

    private static native int toTitleCaseImpl(int var0);

    public static char toUpperCase(char c) {
        return (char)Character.toUpperCase((int)c);
    }

    public static int toUpperCase(int codePoint) {
        if (97 <= codePoint && codePoint <= 122) {
            return (char)(codePoint - 32);
        }
        if (codePoint < 181) {
            return codePoint;
        }
        return Character.toUpperCaseImpl(codePoint);
    }

    private static native int toUpperCaseImpl(int var0);

    static {
        for (int i = 0; i < 128; ++i) {
            Character.SMALL_VALUES[i] = new Character((char)i);
        }
    }

    public static final class UnicodeBlock
    extends Subset {
        @Deprecated
        public static final UnicodeBlock SURROGATES_AREA = new UnicodeBlock("SURROGATES_AREA", 0, 0);
        public static final UnicodeBlock BASIC_LATIN = new UnicodeBlock("BASIC_LATIN", 0, 127);
        public static final UnicodeBlock LATIN_1_SUPPLEMENT = new UnicodeBlock("LATIN_1_SUPPLEMENT", 128, 255);
        public static final UnicodeBlock LATIN_EXTENDED_A = new UnicodeBlock("LATIN_EXTENDED_A", 256, 383);
        public static final UnicodeBlock LATIN_EXTENDED_B = new UnicodeBlock("LATIN_EXTENDED_B", 384, 591);
        public static final UnicodeBlock IPA_EXTENSIONS = new UnicodeBlock("IPA_EXTENSIONS", 592, 687);
        public static final UnicodeBlock SPACING_MODIFIER_LETTERS = new UnicodeBlock("SPACING_MODIFIER_LETTERS", 688, 767);
        public static final UnicodeBlock COMBINING_DIACRITICAL_MARKS = new UnicodeBlock("COMBINING_DIACRITICAL_MARKS", 768, 879);
        public static final UnicodeBlock GREEK = new UnicodeBlock("GREEK", 880, 1023);
        public static final UnicodeBlock CYRILLIC = new UnicodeBlock("CYRILLIC", 1024, 1279);
        public static final UnicodeBlock CYRILLIC_SUPPLEMENTARY = new UnicodeBlock("CYRILLIC_SUPPLEMENTARY", 1280, 1327);
        public static final UnicodeBlock ARMENIAN = new UnicodeBlock("ARMENIAN", 1328, 1423);
        public static final UnicodeBlock HEBREW = new UnicodeBlock("HEBREW", 1424, 1535);
        public static final UnicodeBlock ARABIC = new UnicodeBlock("ARABIC", 1536, 1791);
        public static final UnicodeBlock SYRIAC = new UnicodeBlock("SYRIAC", 1792, 1871);
        public static final UnicodeBlock THAANA = new UnicodeBlock("THAANA", 1920, 1983);
        public static final UnicodeBlock DEVANAGARI = new UnicodeBlock("DEVANAGARI", 2304, 2431);
        public static final UnicodeBlock BENGALI = new UnicodeBlock("BENGALI", 2432, 2559);
        public static final UnicodeBlock GURMUKHI = new UnicodeBlock("GURMUKHI", 2560, 2687);
        public static final UnicodeBlock GUJARATI = new UnicodeBlock("GUJARATI", 2688, 2815);
        public static final UnicodeBlock ORIYA = new UnicodeBlock("ORIYA", 2816, 2943);
        public static final UnicodeBlock TAMIL = new UnicodeBlock("TAMIL", 2944, 3071);
        public static final UnicodeBlock TELUGU = new UnicodeBlock("TELUGU", 3072, 3199);
        public static final UnicodeBlock KANNADA = new UnicodeBlock("KANNADA", 3200, 3327);
        public static final UnicodeBlock MALAYALAM = new UnicodeBlock("MALAYALAM", 3328, 3455);
        public static final UnicodeBlock SINHALA = new UnicodeBlock("SINHALA", 3456, 3583);
        public static final UnicodeBlock THAI = new UnicodeBlock("THAI", 3584, 3711);
        public static final UnicodeBlock LAO = new UnicodeBlock("LAO", 3712, 3839);
        public static final UnicodeBlock TIBETAN = new UnicodeBlock("TIBETAN", 3840, 4095);
        public static final UnicodeBlock MYANMAR = new UnicodeBlock("MYANMAR", 4096, 4255);
        public static final UnicodeBlock GEORGIAN = new UnicodeBlock("GEORGIAN", 4256, 4351);
        public static final UnicodeBlock HANGUL_JAMO = new UnicodeBlock("HANGUL_JAMO", 4352, 4607);
        public static final UnicodeBlock ETHIOPIC = new UnicodeBlock("ETHIOPIC", 4608, 4991);
        public static final UnicodeBlock CHEROKEE = new UnicodeBlock("CHEROKEE", 5024, 5119);
        public static final UnicodeBlock UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS = new UnicodeBlock("UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS", 5120, 5759);
        public static final UnicodeBlock OGHAM = new UnicodeBlock("OGHAM", 5760, 5791);
        public static final UnicodeBlock RUNIC = new UnicodeBlock("RUNIC", 5792, 5887);
        public static final UnicodeBlock TAGALOG = new UnicodeBlock("TAGALOG", 5888, 5919);
        public static final UnicodeBlock HANUNOO = new UnicodeBlock("HANUNOO", 5920, 5951);
        public static final UnicodeBlock BUHID = new UnicodeBlock("BUHID", 5952, 5983);
        public static final UnicodeBlock TAGBANWA = new UnicodeBlock("TAGBANWA", 5984, 6015);
        public static final UnicodeBlock KHMER = new UnicodeBlock("KHMER", 6016, 6143);
        public static final UnicodeBlock MONGOLIAN = new UnicodeBlock("MONGOLIAN", 6144, 6319);
        public static final UnicodeBlock LIMBU = new UnicodeBlock("LIMBU", 6400, 6479);
        public static final UnicodeBlock TAI_LE = new UnicodeBlock("TAI_LE", 6480, 6527);
        public static final UnicodeBlock KHMER_SYMBOLS = new UnicodeBlock("KHMER_SYMBOLS", 6624, 6655);
        public static final UnicodeBlock PHONETIC_EXTENSIONS = new UnicodeBlock("PHONETIC_EXTENSIONS", 7424, 7551);
        public static final UnicodeBlock LATIN_EXTENDED_ADDITIONAL = new UnicodeBlock("LATIN_EXTENDED_ADDITIONAL", 7680, 7935);
        public static final UnicodeBlock GREEK_EXTENDED = new UnicodeBlock("GREEK_EXTENDED", 7936, 8191);
        public static final UnicodeBlock GENERAL_PUNCTUATION = new UnicodeBlock("GENERAL_PUNCTUATION", 8192, 8303);
        public static final UnicodeBlock SUPERSCRIPTS_AND_SUBSCRIPTS = new UnicodeBlock("SUPERSCRIPTS_AND_SUBSCRIPTS", 8304, 8351);
        public static final UnicodeBlock CURRENCY_SYMBOLS = new UnicodeBlock("CURRENCY_SYMBOLS", 8352, 8399);
        public static final UnicodeBlock COMBINING_MARKS_FOR_SYMBOLS = new UnicodeBlock("COMBINING_MARKS_FOR_SYMBOLS", 8400, 8447);
        public static final UnicodeBlock LETTERLIKE_SYMBOLS = new UnicodeBlock("LETTERLIKE_SYMBOLS", 8448, 8527);
        public static final UnicodeBlock NUMBER_FORMS = new UnicodeBlock("NUMBER_FORMS", 8528, 8591);
        public static final UnicodeBlock ARROWS = new UnicodeBlock("ARROWS", 8592, 8703);
        public static final UnicodeBlock MATHEMATICAL_OPERATORS = new UnicodeBlock("MATHEMATICAL_OPERATORS", 8704, 8959);
        public static final UnicodeBlock MISCELLANEOUS_TECHNICAL = new UnicodeBlock("MISCELLANEOUS_TECHNICAL", 8960, 9215);
        public static final UnicodeBlock CONTROL_PICTURES = new UnicodeBlock("CONTROL_PICTURES", 9216, 9279);
        public static final UnicodeBlock OPTICAL_CHARACTER_RECOGNITION = new UnicodeBlock("OPTICAL_CHARACTER_RECOGNITION", 9280, 9311);
        public static final UnicodeBlock ENCLOSED_ALPHANUMERICS = new UnicodeBlock("ENCLOSED_ALPHANUMERICS", 9312, 9471);
        public static final UnicodeBlock BOX_DRAWING = new UnicodeBlock("BOX_DRAWING", 9472, 9599);
        public static final UnicodeBlock BLOCK_ELEMENTS = new UnicodeBlock("BLOCK_ELEMENTS", 9600, 9631);
        public static final UnicodeBlock GEOMETRIC_SHAPES = new UnicodeBlock("GEOMETRIC_SHAPES", 9632, 9727);
        public static final UnicodeBlock MISCELLANEOUS_SYMBOLS = new UnicodeBlock("MISCELLANEOUS_SYMBOLS", 9728, 9983);
        public static final UnicodeBlock DINGBATS = new UnicodeBlock("DINGBATS", 9984, 10175);
        public static final UnicodeBlock MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A = new UnicodeBlock("MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A", 10176, 10223);
        public static final UnicodeBlock SUPPLEMENTAL_ARROWS_A = new UnicodeBlock("SUPPLEMENTAL_ARROWS_A", 10224, 10239);
        public static final UnicodeBlock BRAILLE_PATTERNS = new UnicodeBlock("BRAILLE_PATTERNS", 10240, 10495);
        public static final UnicodeBlock SUPPLEMENTAL_ARROWS_B = new UnicodeBlock("SUPPLEMENTAL_ARROWS_B", 10496, 10623);
        public static final UnicodeBlock MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B = new UnicodeBlock("MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B", 10624, 10751);
        public static final UnicodeBlock SUPPLEMENTAL_MATHEMATICAL_OPERATORS = new UnicodeBlock("SUPPLEMENTAL_MATHEMATICAL_OPERATORS", 10752, 11007);
        public static final UnicodeBlock MISCELLANEOUS_SYMBOLS_AND_ARROWS = new UnicodeBlock("MISCELLANEOUS_SYMBOLS_AND_ARROWS", 11008, 11263);
        public static final UnicodeBlock CJK_RADICALS_SUPPLEMENT = new UnicodeBlock("CJK_RADICALS_SUPPLEMENT", 11904, 12031);
        public static final UnicodeBlock KANGXI_RADICALS = new UnicodeBlock("KANGXI_RADICALS", 12032, 12255);
        public static final UnicodeBlock IDEOGRAPHIC_DESCRIPTION_CHARACTERS = new UnicodeBlock("IDEOGRAPHIC_DESCRIPTION_CHARACTERS", 12272, 12287);
        public static final UnicodeBlock CJK_SYMBOLS_AND_PUNCTUATION = new UnicodeBlock("CJK_SYMBOLS_AND_PUNCTUATION", 12288, 12351);
        public static final UnicodeBlock HIRAGANA = new UnicodeBlock("HIRAGANA", 12352, 12447);
        public static final UnicodeBlock KATAKANA = new UnicodeBlock("KATAKANA", 12448, 12543);
        public static final UnicodeBlock BOPOMOFO = new UnicodeBlock("BOPOMOFO", 12544, 12591);
        public static final UnicodeBlock HANGUL_COMPATIBILITY_JAMO = new UnicodeBlock("HANGUL_COMPATIBILITY_JAMO", 12592, 12687);
        public static final UnicodeBlock KANBUN = new UnicodeBlock("KANBUN", 12688, 12703);
        public static final UnicodeBlock BOPOMOFO_EXTENDED = new UnicodeBlock("BOPOMOFO_EXTENDED", 12704, 12735);
        public static final UnicodeBlock KATAKANA_PHONETIC_EXTENSIONS = new UnicodeBlock("KATAKANA_PHONETIC_EXTENSIONS", 12784, 12799);
        public static final UnicodeBlock ENCLOSED_CJK_LETTERS_AND_MONTHS = new UnicodeBlock("ENCLOSED_CJK_LETTERS_AND_MONTHS", 12800, 13055);
        public static final UnicodeBlock CJK_COMPATIBILITY = new UnicodeBlock("CJK_COMPATIBILITY", 13056, 13311);
        public static final UnicodeBlock CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A = new UnicodeBlock("CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A", 13312, 19903);
        public static final UnicodeBlock YIJING_HEXAGRAM_SYMBOLS = new UnicodeBlock("YIJING_HEXAGRAM_SYMBOLS", 19904, 19967);
        public static final UnicodeBlock CJK_UNIFIED_IDEOGRAPHS = new UnicodeBlock("CJK_UNIFIED_IDEOGRAPHS", 19968, 40959);
        public static final UnicodeBlock YI_SYLLABLES = new UnicodeBlock("YI_SYLLABLES", 40960, 42127);
        public static final UnicodeBlock YI_RADICALS = new UnicodeBlock("YI_RADICALS", 42128, 42191);
        public static final UnicodeBlock HANGUL_SYLLABLES = new UnicodeBlock("HANGUL_SYLLABLES", 44032, 55215);
        public static final UnicodeBlock HIGH_SURROGATES = new UnicodeBlock("HIGH_SURROGATES", 55296, 56191);
        public static final UnicodeBlock HIGH_PRIVATE_USE_SURROGATES = new UnicodeBlock("HIGH_PRIVATE_USE_SURROGATES", 56192, 56319);
        public static final UnicodeBlock LOW_SURROGATES = new UnicodeBlock("LOW_SURROGATES", 56320, 57343);
        public static final UnicodeBlock PRIVATE_USE_AREA = new UnicodeBlock("PRIVATE_USE_AREA", 57344, 63743);
        public static final UnicodeBlock CJK_COMPATIBILITY_IDEOGRAPHS = new UnicodeBlock("CJK_COMPATIBILITY_IDEOGRAPHS", 63744, 64255);
        public static final UnicodeBlock ALPHABETIC_PRESENTATION_FORMS = new UnicodeBlock("ALPHABETIC_PRESENTATION_FORMS", 64256, 64335);
        public static final UnicodeBlock ARABIC_PRESENTATION_FORMS_A = new UnicodeBlock("ARABIC_PRESENTATION_FORMS_A", 64336, 65023);
        public static final UnicodeBlock VARIATION_SELECTORS = new UnicodeBlock("VARIATION_SELECTORS", 65024, 65039);
        public static final UnicodeBlock COMBINING_HALF_MARKS = new UnicodeBlock("COMBINING_HALF_MARKS", 65056, 65071);
        public static final UnicodeBlock CJK_COMPATIBILITY_FORMS = new UnicodeBlock("CJK_COMPATIBILITY_FORMS", 65072, 65103);
        public static final UnicodeBlock SMALL_FORM_VARIANTS = new UnicodeBlock("SMALL_FORM_VARIANTS", 65104, 65135);
        public static final UnicodeBlock ARABIC_PRESENTATION_FORMS_B = new UnicodeBlock("ARABIC_PRESENTATION_FORMS_B", 65136, 65279);
        public static final UnicodeBlock HALFWIDTH_AND_FULLWIDTH_FORMS = new UnicodeBlock("HALFWIDTH_AND_FULLWIDTH_FORMS", 65280, 65519);
        public static final UnicodeBlock SPECIALS = new UnicodeBlock("SPECIALS", 65520, 65535);
        public static final UnicodeBlock LINEAR_B_SYLLABARY = new UnicodeBlock("LINEAR_B_SYLLABARY", 65536, 65663);
        public static final UnicodeBlock LINEAR_B_IDEOGRAMS = new UnicodeBlock("LINEAR_B_IDEOGRAMS", 65664, 65791);
        public static final UnicodeBlock AEGEAN_NUMBERS = new UnicodeBlock("AEGEAN_NUMBERS", 65792, 65855);
        public static final UnicodeBlock OLD_ITALIC = new UnicodeBlock("OLD_ITALIC", 66304, 66351);
        public static final UnicodeBlock GOTHIC = new UnicodeBlock("GOTHIC", 66352, 66383);
        public static final UnicodeBlock UGARITIC = new UnicodeBlock("UGARITIC", 66432, 66463);
        public static final UnicodeBlock DESERET = new UnicodeBlock("DESERET", 66560, 66639);
        public static final UnicodeBlock SHAVIAN = new UnicodeBlock("SHAVIAN", 66640, 66687);
        public static final UnicodeBlock OSMANYA = new UnicodeBlock("OSMANYA", 66688, 66735);
        public static final UnicodeBlock CYPRIOT_SYLLABARY = new UnicodeBlock("CYPRIOT_SYLLABARY", 67584, 67647);
        public static final UnicodeBlock BYZANTINE_MUSICAL_SYMBOLS = new UnicodeBlock("BYZANTINE_MUSICAL_SYMBOLS", 118784, 119039);
        public static final UnicodeBlock MUSICAL_SYMBOLS = new UnicodeBlock("MUSICAL_SYMBOLS", 119040, 119295);
        public static final UnicodeBlock TAI_XUAN_JING_SYMBOLS = new UnicodeBlock("TAI_XUAN_JING_SYMBOLS", 119552, 119647);
        public static final UnicodeBlock MATHEMATICAL_ALPHANUMERIC_SYMBOLS = new UnicodeBlock("MATHEMATICAL_ALPHANUMERIC_SYMBOLS", 119808, 120831);
        public static final UnicodeBlock CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B = new UnicodeBlock("CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B", 131072, 173791);
        public static final UnicodeBlock CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT = new UnicodeBlock("CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT", 194560, 195103);
        public static final UnicodeBlock TAGS = new UnicodeBlock("TAGS", 917504, 917631);
        public static final UnicodeBlock VARIATION_SELECTORS_SUPPLEMENT = new UnicodeBlock("VARIATION_SELECTORS_SUPPLEMENT", 917760, 917999);
        public static final UnicodeBlock SUPPLEMENTARY_PRIVATE_USE_AREA_A = new UnicodeBlock("SUPPLEMENTARY_PRIVATE_USE_AREA_A", 983040, 1048575);
        public static final UnicodeBlock SUPPLEMENTARY_PRIVATE_USE_AREA_B = new UnicodeBlock("SUPPLEMENTARY_PRIVATE_USE_AREA_B", 0x100000, 0x10FFFF);
        private static UnicodeBlock[] BLOCKS = new UnicodeBlock[]{null, BASIC_LATIN, LATIN_1_SUPPLEMENT, LATIN_EXTENDED_A, LATIN_EXTENDED_B, IPA_EXTENSIONS, SPACING_MODIFIER_LETTERS, COMBINING_DIACRITICAL_MARKS, GREEK, CYRILLIC, ARMENIAN, HEBREW, ARABIC, SYRIAC, THAANA, DEVANAGARI, BENGALI, GURMUKHI, GUJARATI, ORIYA, TAMIL, TELUGU, KANNADA, MALAYALAM, SINHALA, THAI, LAO, TIBETAN, MYANMAR, GEORGIAN, HANGUL_JAMO, ETHIOPIC, CHEROKEE, UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS, OGHAM, RUNIC, KHMER, MONGOLIAN, LATIN_EXTENDED_ADDITIONAL, GREEK_EXTENDED, GENERAL_PUNCTUATION, SUPERSCRIPTS_AND_SUBSCRIPTS, CURRENCY_SYMBOLS, COMBINING_MARKS_FOR_SYMBOLS, LETTERLIKE_SYMBOLS, NUMBER_FORMS, ARROWS, MATHEMATICAL_OPERATORS, MISCELLANEOUS_TECHNICAL, CONTROL_PICTURES, OPTICAL_CHARACTER_RECOGNITION, ENCLOSED_ALPHANUMERICS, BOX_DRAWING, BLOCK_ELEMENTS, GEOMETRIC_SHAPES, MISCELLANEOUS_SYMBOLS, DINGBATS, BRAILLE_PATTERNS, CJK_RADICALS_SUPPLEMENT, KANGXI_RADICALS, IDEOGRAPHIC_DESCRIPTION_CHARACTERS, CJK_SYMBOLS_AND_PUNCTUATION, HIRAGANA, KATAKANA, BOPOMOFO, HANGUL_COMPATIBILITY_JAMO, KANBUN, BOPOMOFO_EXTENDED, ENCLOSED_CJK_LETTERS_AND_MONTHS, CJK_COMPATIBILITY, CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A, CJK_UNIFIED_IDEOGRAPHS, YI_SYLLABLES, YI_RADICALS, HANGUL_SYLLABLES, HIGH_SURROGATES, HIGH_PRIVATE_USE_SURROGATES, LOW_SURROGATES, PRIVATE_USE_AREA, CJK_COMPATIBILITY_IDEOGRAPHS, ALPHABETIC_PRESENTATION_FORMS, ARABIC_PRESENTATION_FORMS_A, COMBINING_HALF_MARKS, CJK_COMPATIBILITY_FORMS, SMALL_FORM_VARIANTS, ARABIC_PRESENTATION_FORMS_B, SPECIALS, HALFWIDTH_AND_FULLWIDTH_FORMS, OLD_ITALIC, GOTHIC, DESERET, BYZANTINE_MUSICAL_SYMBOLS, MUSICAL_SYMBOLS, MATHEMATICAL_ALPHANUMERIC_SYMBOLS, CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B, CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT, TAGS, CYRILLIC_SUPPLEMENTARY, TAGALOG, HANUNOO, BUHID, TAGBANWA, MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A, SUPPLEMENTAL_ARROWS_A, SUPPLEMENTAL_ARROWS_B, MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B, SUPPLEMENTAL_MATHEMATICAL_OPERATORS, KATAKANA_PHONETIC_EXTENSIONS, VARIATION_SELECTORS, SUPPLEMENTARY_PRIVATE_USE_AREA_A, SUPPLEMENTARY_PRIVATE_USE_AREA_B, LIMBU, TAI_LE, KHMER_SYMBOLS, PHONETIC_EXTENSIONS, MISCELLANEOUS_SYMBOLS_AND_ARROWS, YIJING_HEXAGRAM_SYMBOLS, LINEAR_B_SYLLABARY, LINEAR_B_IDEOGRAMS, AEGEAN_NUMBERS, UGARITIC, SHAVIAN, OSMANYA, CYPRIOT_SYLLABARY, TAI_XUAN_JING_SYMBOLS, VARIATION_SELECTORS_SUPPLEMENT};

        public static UnicodeBlock forName(String blockName) {
            if (blockName == null) {
                throw new NullPointerException();
            }
            int block = Character.forNameImpl(blockName);
            if (block == -1) {
                if (blockName.equals("SURROGATES_AREA")) {
                    return SURROGATES_AREA;
                }
                if (blockName.equalsIgnoreCase("greek")) {
                    return GREEK;
                }
                if (blockName.equals("COMBINING_MARKS_FOR_SYMBOLS") || blockName.equals("Combining Marks for Symbols") || blockName.equals("CombiningMarksforSymbols")) {
                    return COMBINING_MARKS_FOR_SYMBOLS;
                }
                throw new IllegalArgumentException("Bad block name: " + blockName);
            }
            return BLOCKS[block];
        }

        public static UnicodeBlock of(char c) {
            return UnicodeBlock.of((int)c);
        }

        public static UnicodeBlock of(int codePoint) {
            Character.checkValidCodePoint(codePoint);
            int block = Character.ofImpl(codePoint);
            if (block == -1 || block >= BLOCKS.length) {
                return null;
            }
            return BLOCKS[block];
        }

        private UnicodeBlock(String blockName, int start, int end) {
            super(blockName);
        }
    }

    public static class Subset {
        String name;

        protected Subset(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            this.name = string;
        }

        public final boolean equals(Object object) {
            return super.equals(object);
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final String toString() {
            return this.name;
        }
    }
}

