/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import dalvik.system.VMRuntime;
import java.lang.ref.FinalizerReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.TimeoutException;
import libcore.util.EmptyArray;

public final class Daemons {
    private static final int NANOS_PER_MILLI = 1000000;
    private static final long MAX_FINALIZE_MILLIS = 10000L;

    public static void start() {
        ReferenceQueueDaemon.INSTANCE.start();
        FinalizerDaemon.INSTANCE.start();
        FinalizerWatchdogDaemon.INSTANCE.start();
    }

    public static void stop() {
        ReferenceQueueDaemon.INSTANCE.stop();
        FinalizerDaemon.INSTANCE.stop();
        FinalizerWatchdogDaemon.INSTANCE.stop();
    }

    private static class FinalizerWatchdogDaemon
    extends Daemon {
        private static final FinalizerWatchdogDaemon INSTANCE = new FinalizerWatchdogDaemon();

        private FinalizerWatchdogDaemon() {
        }

        public void run() {
            while (this.isRunning()) {
                long elapsedMillis;
                Object object = FinalizerDaemon.INSTANCE.finalizingObject;
                long startedNanos = FinalizerDaemon.INSTANCE.finalizingStartedNanos;
                long sleepMillis = 10000L;
                if (object != null) {
                    elapsedMillis = (System.nanoTime() - startedNanos) / 1000000L;
                    sleepMillis -= elapsedMillis;
                }
                if (sleepMillis > 0L) {
                    try {
                        Thread.sleep(sleepMillis);
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                }
                if (object == null || object != FinalizerDaemon.INSTANCE.finalizingObject || VMRuntime.getRuntime().isDebuggerActive()) continue;
                elapsedMillis = (System.nanoTime() - startedNanos) / 1000000L;
                TimeoutException syntheticException = new TimeoutException();
                syntheticException.setStackTrace(FinalizerDaemon.INSTANCE.getStackTrace());
                System.logE(object.getClass().getName() + ".finalize() timed out after " + elapsedMillis + " ms; limit is " + 10000L + " ms", syntheticException);
                System.exit(2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FinalizerDaemon
    extends Daemon {
        private static final FinalizerDaemon INSTANCE = new FinalizerDaemon();
        private final ReferenceQueue<Object> queue = FinalizerReference.queue;
        private volatile Object finalizingObject;
        private volatile long finalizingStartedNanos;

        private FinalizerDaemon() {
        }

        @Override
        public void run() {
            while (this.isRunning()) {
                try {
                    this.doFinalize((FinalizerReference)this.queue.remove());
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @FindBugsSuppressWarnings(value={"FI_EXPLICIT_INVOCATION"})
        private void doFinalize(FinalizerReference<?> reference) {
            FinalizerReference.remove(reference);
            Object object = reference.get();
            reference.clear();
            try {
                this.finalizingStartedNanos = System.nanoTime();
                this.finalizingObject = object;
                object.finalize();
            }
            catch (Throwable ex) {
                System.logE("Uncaught exception thrown by finalizer", ex);
            }
            finally {
                this.finalizingObject = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReferenceQueueDaemon
    extends Daemon {
        private static final ReferenceQueueDaemon INSTANCE = new ReferenceQueueDaemon();

        private ReferenceQueueDaemon() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            while (this.isRunning()) {
                Reference list;
                try {
                    Class<ReferenceQueue> clazz = ReferenceQueue.class;
                    // MONITORENTER : java.lang.ref.ReferenceQueue.class
                    while (ReferenceQueue.unenqueued == null) {
                        ReferenceQueue.class.wait();
                    }
                    list = ReferenceQueue.unenqueued;
                    ReferenceQueue.unenqueued = null;
                    // MONITOREXIT : clazz
                }
                catch (InterruptedException e) {
                    continue;
                }
                this.enqueue(list);
            }
        }

        private void enqueue(Reference<?> list) {
            while (list != null) {
                Reference<?> reference;
                if (list == list.pendingNext) {
                    reference = list;
                    reference.pendingNext = null;
                    list = null;
                } else {
                    reference = list.pendingNext;
                    list.pendingNext = reference.pendingNext;
                    reference.pendingNext = null;
                }
                reference.enqueueInternal();
            }
        }
    }

    private static abstract class Daemon
    implements Runnable {
        private Thread thread;

        private Daemon() {
        }

        public synchronized void start() {
            if (this.thread != null) {
                throw new IllegalStateException("already running");
            }
            this.thread = new Thread(this, this.getClass().getSimpleName());
            this.thread.setDaemon(true);
            this.thread.start();
        }

        public abstract void run();

        protected synchronized boolean isRunning() {
            return this.thread != null;
        }

        public synchronized void interrupt() {
            if (this.thread == null) {
                throw new IllegalStateException("not running");
            }
            this.thread.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Thread threadToStop;
            Daemon daemon = this;
            synchronized (daemon) {
                threadToStop = this.thread;
                this.thread = null;
            }
            if (threadToStop == null) {
                throw new IllegalStateException("not running");
            }
            threadToStop.interrupt();
            while (true) {
                try {
                    threadToStop.join();
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        public synchronized StackTraceElement[] getStackTrace() {
            return this.thread != null ? this.thread.getStackTrace() : EmptyArray.STACK_TRACE_ELEMENT;
        }
    }
}

