/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Float
extends Number
implements Comparable<Float> {
    static final int EXPONENT_BIAS = 127;
    static final int EXPONENT_BITS = 9;
    static final int MANTISSA_BITS = 23;
    static final int NON_MANTISSA_BITS = 9;
    static final int SIGN_MASK = Integer.MIN_VALUE;
    static final int EXPONENT_MASK = 2139095040;
    static final int MANTISSA_MASK = 0x7FFFFF;
    private static final long serialVersionUID = -2671257302660747028L;
    private final float value;
    public static final float MAX_VALUE = 3.4028235E38f;
    public static final float MIN_VALUE = 1.4E-45f;
    public static final float NaN = 0.0f / 0.0f;
    public static final float POSITIVE_INFINITY = 1.0f / 0.0f;
    public static final float NEGATIVE_INFINITY = -1.0f / 0.0f;
    public static final float MIN_NORMAL = 1.1754944E-38f;
    public static final int MAX_EXPONENT = 127;
    public static final int MIN_EXPONENT = -126;
    public static final Class<Float> TYPE = float[].class.getComponentType();
    public static final int SIZE = 32;

    public Float(float value) {
        this.value = value;
    }

    public Float(double value) {
        this.value = (float)value;
    }

    public Float(String string) throws NumberFormatException {
        this(Float.parseFloat(string));
    }

    @Override
    public int compareTo(Float object) {
        return Float.compare(this.value, object.value);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        return object instanceof Float && Float.floatToIntBits(this.value) == Float.floatToIntBits(((Float)object).value);
    }

    public static native int floatToIntBits(float var0);

    public static native int floatToRawIntBits(float var0);

    @Override
    public float floatValue() {
        return this.value;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public static native float intBitsToFloat(int var0);

    @Override
    public int intValue() {
        return (int)this.value;
    }

    public boolean isInfinite() {
        return Float.isInfinite(this.value);
    }

    public static boolean isInfinite(float f) {
        return f == Float.POSITIVE_INFINITY || f == Float.NEGATIVE_INFINITY;
    }

    public boolean isNaN() {
        return Float.isNaN(this.value);
    }

    public static boolean isNaN(float f) {
        return f != f;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    public static float parseFloat(String string) throws NumberFormatException {
        return StringToReal.parseFloat(string);
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    public String toString() {
        return Float.toString(this.value);
    }

    public static String toString(float f) {
        return RealToString.getInstance().floatToString(f);
    }

    public static Float valueOf(String string) throws NumberFormatException {
        return Float.valueOf(Float.parseFloat(string));
    }

    public static int compare(float float1, float float2) {
        if (float1 > float2) {
            return 1;
        }
        if (float2 > float1) {
            return -1;
        }
        if (float1 == float2 && 0.0f != float1) {
            return 0;
        }
        if (Float.isNaN(float1)) {
            if (Float.isNaN(float2)) {
                return 0;
            }
            return 1;
        }
        if (Float.isNaN(float2)) {
            return -1;
        }
        int f1 = Float.floatToRawIntBits(float1);
        int f2 = Float.floatToRawIntBits(float2);
        return (f1 >> 31) - (f2 >> 31);
    }

    public static Float valueOf(float f) {
        return new Float(f);
    }

    public static String toHexString(float f) {
        if (f != f) {
            return "NaN";
        }
        if (f == Float.POSITIVE_INFINITY) {
            return "Infinity";
        }
        if (f == Float.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        int bitValue = Float.floatToIntBits(f);
        boolean negative = (bitValue & Integer.MIN_VALUE) != 0;
        int exponent = (bitValue & 0x7F800000) >>> 23;
        int significand = (bitValue & 0x7FFFFF) << 1;
        if (exponent == 0 && significand == 0) {
            return negative ? "-0x0.0p0" : "0x0.0p0";
        }
        StringBuilder hexString = new StringBuilder(10);
        if (negative) {
            hexString.append("-0x");
        } else {
            hexString.append("0x");
        }
        if (exponent == 0) {
            hexString.append("0.");
            int fractionDigits = 6;
            while (significand != 0 && (significand & 0xF) == 0) {
                significand >>>= 4;
                --fractionDigits;
            }
            String hexSignificand = Integer.toHexString(significand);
            if (significand != 0 && fractionDigits > hexSignificand.length()) {
                int digitDiff = fractionDigits - hexSignificand.length();
                while (digitDiff-- != 0) {
                    hexString.append('0');
                }
            }
            hexString.append(hexSignificand);
            hexString.append("p-126");
        } else {
            hexString.append("1.");
            int fractionDigits = 6;
            while (significand != 0 && (significand & 0xF) == 0) {
                significand >>>= 4;
                --fractionDigits;
            }
            String hexSignificand = Integer.toHexString(significand);
            if (significand != 0 && fractionDigits > hexSignificand.length()) {
                int digitDiff = fractionDigits - hexSignificand.length();
                while (digitDiff-- != 0) {
                    hexString.append('0');
                }
            }
            hexString.append(hexSignificand);
            hexString.append('p');
            hexString.append(exponent - 127);
        }
        return hexString.toString();
    }
}

