/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import libcore.io.ErrnoException;
import libcore.io.IoUtils;
import libcore.io.Libcore;
import libcore.io.OsConstants;
import libcore.util.MutableInt;

final class ProcessManager {
    private final Map<Integer, ProcessReference> processReferences = new HashMap<Integer, ProcessReference>();
    private final ProcessReferenceQueue referenceQueue = new ProcessReferenceQueue();
    private static final ProcessManager instance = new ProcessManager();

    private ProcessManager() {
        Thread reaperThread = new Thread(ProcessManager.class.getName()){

            public void run() {
                ProcessManager.this.watchChildren();
            }
        };
        reaperThread.setDaemon(true);
        reaperThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp() {
        ProcessReference reference;
        while ((reference = this.referenceQueue.poll()) != null) {
            Map<Integer, ProcessReference> map = this.processReferences;
            synchronized (map) {
                this.processReferences.remove(reference.processId);
            }
        }
    }

    private void watchChildren() {
        MutableInt status = new MutableInt(-1);
        while (true) {
            try {
                while (true) {
                    int exitValue;
                    int pid = Libcore.os.waitpid(0, status, 0);
                    if (OsConstants.WIFEXITED(status.value)) {
                        exitValue = OsConstants.WEXITSTATUS(status.value);
                    } else if (OsConstants.WIFSIGNALED(status.value)) {
                        exitValue = OsConstants.WTERMSIG(status.value);
                    } else if (OsConstants.WIFSTOPPED(status.value)) {
                        exitValue = OsConstants.WSTOPSIG(status.value);
                    } else {
                        throw new AssertionError((Object)("unexpected status from waitpid: " + status.value));
                    }
                    this.onExit(pid, exitValue);
                }
            }
            catch (ErrnoException errnoException) {
                if (errnoException.errno == OsConstants.ECHILD) {
                    this.waitForMoreChildren();
                    continue;
                }
                throw new AssertionError((Object)errnoException);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onExit(int pid, int exitValue) {
        ProcessImpl process;
        ProcessReference processReference = null;
        Map<Integer, ProcessReference> map = this.processReferences;
        synchronized (map) {
            this.cleanUp();
            processReference = this.processReferences.remove(pid);
        }
        if (processReference != null && (process = (ProcessImpl)processReference.get()) != null) {
            process.setExitValue(exitValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForMoreChildren() {
        Map<Integer, ProcessReference> map = this.processReferences;
        synchronized (map) {
            if (this.processReferences.isEmpty()) {
                try {
                    this.processReferences.wait();
                }
                catch (InterruptedException ex) {
                    throw new AssertionError((Object)"unexpected interrupt");
                }
            }
        }
    }

    private static native int exec(String[] var0, String[] var1, String var2, FileDescriptor var3, FileDescriptor var4, FileDescriptor var5, boolean var6) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Process exec(String[] taintedCommand, String[] taintedEnvironment, File workingDirectory, boolean redirectErrorStream) throws IOException {
        if (taintedCommand == null) {
            throw new NullPointerException();
        }
        if (taintedCommand.length == 0) {
            throw new IndexOutOfBoundsException();
        }
        Object[] command = (String[])taintedCommand.clone();
        Object[] environment = taintedEnvironment != null ? (String[])taintedEnvironment.clone() : null;
        for (String string : command) {
            if (string != null) continue;
            throw new NullPointerException();
        }
        if (environment != null) {
            for (String string : environment) {
                if (string != null) continue;
                throw new NullPointerException();
            }
        }
        FileDescriptor in = new FileDescriptor();
        FileDescriptor out = new FileDescriptor();
        FileDescriptor err = new FileDescriptor();
        String string = workingDirectory == null ? null : workingDirectory.getPath();
        Map<Integer, ProcessReference> map = this.processReferences;
        synchronized (map) {
            int pid;
            try {
                pid = ProcessManager.exec((String[])command, (String[])environment, string, in, out, err, redirectErrorStream);
            }
            catch (IOException e) {
                IOException wrapper = new IOException("Error running exec(). Command: " + Arrays.toString(command) + " Working Directory: " + workingDirectory + " Environment: " + Arrays.toString(environment));
                wrapper.initCause(e);
                throw wrapper;
            }
            ProcessImpl process = new ProcessImpl(pid, in, out, err);
            ProcessReference processReference = new ProcessReference(process, this.referenceQueue);
            this.processReferences.put(pid, processReference);
            this.processReferences.notifyAll();
            return process;
        }
    }

    public static ProcessManager getInstance() {
        return instance;
    }

    private static class ProcessOutputStream
    extends FileOutputStream {
        private FileDescriptor fd;

        private ProcessOutputStream(FileDescriptor fd) {
            super(fd);
            this.fd = fd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                ProcessOutputStream processOutputStream = this;
                synchronized (processOutputStream) {
                    try {
                        IoUtils.close(this.fd);
                    }
                    finally {
                        this.fd = null;
                    }
                }
            }
        }
    }

    private static class ProcessInputStream
    extends FileInputStream {
        private FileDescriptor fd;

        private ProcessInputStream(FileDescriptor fd) {
            super(fd);
            this.fd = fd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                ProcessInputStream processInputStream = this;
                synchronized (processInputStream) {
                    try {
                        IoUtils.close(this.fd);
                    }
                    finally {
                        this.fd = null;
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ProcessReferenceQueue
    extends ReferenceQueue<ProcessImpl> {
        ProcessReferenceQueue() {
        }

        public ProcessReference poll() {
            Reference reference = super.poll();
            return (ProcessReference)reference;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ProcessReference
    extends WeakReference<ProcessImpl> {
        final int processId;

        public ProcessReference(ProcessImpl referent, ProcessReferenceQueue referenceQueue) {
            super(referent, referenceQueue);
            this.processId = referent.pid;
        }
    }

    static class ProcessImpl
    extends Process {
        private final int pid;
        private final InputStream errorStream;
        private final InputStream inputStream;
        private final OutputStream outputStream;
        private Integer exitValue = null;
        private final Object exitValueMutex = new Object();

        ProcessImpl(int pid, FileDescriptor in, FileDescriptor out, FileDescriptor err) {
            this.pid = pid;
            this.errorStream = new ProcessInputStream(err);
            this.inputStream = new ProcessInputStream(in);
            this.outputStream = new ProcessOutputStream(out);
        }

        public void destroy() {
            try {
                Libcore.os.kill(this.pid, OsConstants.SIGKILL);
            }
            catch (ErrnoException e) {
                System.logI("Failed to destroy process " + this.pid, e);
            }
            IoUtils.closeQuietly(this.inputStream);
            IoUtils.closeQuietly(this.errorStream);
            IoUtils.closeQuietly(this.outputStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int exitValue() {
            Object object = this.exitValueMutex;
            synchronized (object) {
                if (this.exitValue == null) {
                    throw new IllegalThreadStateException("Process has not yet terminated.");
                }
                return this.exitValue;
            }
        }

        public InputStream getErrorStream() {
            return this.errorStream;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public OutputStream getOutputStream() {
            return this.outputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int waitFor() throws InterruptedException {
            Object object = this.exitValueMutex;
            synchronized (object) {
                while (this.exitValue == null) {
                    this.exitValueMutex.wait();
                }
                return this.exitValue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setExitValue(int exitValue) {
            Object object = this.exitValueMutex;
            synchronized (object) {
                this.exitValue = exitValue;
                this.exitValueMutex.notifyAll();
            }
        }

        public String toString() {
            return "Process[pid=" + this.pid + "]";
        }
    }
}

