/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public final class StackTraceElement
implements Serializable {
    private static final long serialVersionUID = 6992337162326171013L;
    private static final int NATIVE_LINE_NUMBER = -2;
    String declaringClass;
    String methodName;
    String fileName;
    int lineNumber;

    public StackTraceElement(String cls, String method, String file, int line) {
        if (cls == null || method == null) {
            throw new NullPointerException();
        }
        this.declaringClass = cls;
        this.methodName = method;
        this.fileName = file;
        this.lineNumber = line;
    }

    private StackTraceElement() {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StackTraceElement)) {
            return false;
        }
        StackTraceElement castObj = (StackTraceElement)obj;
        if (this.methodName == null || castObj.methodName == null) {
            return false;
        }
        if (!this.getMethodName().equals(castObj.getMethodName())) {
            return false;
        }
        if (!this.getClassName().equals(castObj.getClassName())) {
            return false;
        }
        String localFileName = this.getFileName();
        if (localFileName == null ? castObj.getFileName() != null : !localFileName.equals(castObj.getFileName())) {
            return false;
        }
        return this.getLineNumber() == castObj.getLineNumber();
    }

    public String getClassName() {
        return this.declaringClass == null ? "<unknown class>" : this.declaringClass;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getMethodName() {
        return this.methodName == null ? "<unknown method>" : this.methodName;
    }

    public int hashCode() {
        if (this.methodName == null) {
            return 0;
        }
        return this.methodName.hashCode() ^ this.declaringClass.hashCode();
    }

    public boolean isNativeMethod() {
        return this.lineNumber == -2;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(80);
        buf.append(this.getClassName());
        buf.append('.');
        buf.append(this.getMethodName());
        if (this.isNativeMethod()) {
            buf.append("(Native Method)");
        } else {
            String fName = this.getFileName();
            if (fName == null) {
                buf.append("(Unknown Source)");
            } else {
                int lineNum = this.getLineNumber();
                buf.append('(');
                buf.append(fName);
                if (lineNum >= 0) {
                    buf.append(':');
                    buf.append(lineNum);
                }
                buf.append(')');
            }
        }
        return buf.toString();
    }
}

