/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class StrictMath {
    public static final double E = Math.E;
    public static final double PI = Math.PI;

    private StrictMath() {
    }

    public static double abs(double d) {
        return Math.abs(d);
    }

    public static float abs(float f) {
        return Math.abs(f);
    }

    public static int abs(int i) {
        return Math.abs(i);
    }

    public static long abs(long l) {
        return Math.abs(l);
    }

    public static native double acos(double var0);

    public static native double asin(double var0);

    public static native double atan(double var0);

    public static native double atan2(double var0, double var2);

    public static native double cbrt(double var0);

    public static native double ceil(double var0);

    public static native double cosh(double var0);

    public static native double cos(double var0);

    public static native double exp(double var0);

    public static native double expm1(double var0);

    public static native double floor(double var0);

    public static native double hypot(double var0, double var2);

    public static native double IEEEremainder(double var0, double var2);

    public static native double log(double var0);

    public static native double log10(double var0);

    public static native double log1p(double var0);

    public static double max(double d1, double d2) {
        if (d1 > d2) {
            return d1;
        }
        if (d1 < d2) {
            return d2;
        }
        if (d1 != d2) {
            return Double.NaN;
        }
        if (d1 == 0.0 && (Double.doubleToLongBits(d1) & Double.doubleToLongBits(d2) & Long.MIN_VALUE) == 0L) {
            return 0.0;
        }
        return d1;
    }

    public static float max(float f1, float f2) {
        if (f1 > f2) {
            return f1;
        }
        if (f1 < f2) {
            return f2;
        }
        if (f1 != f2) {
            return Float.NaN;
        }
        if (f1 == 0.0f && (Float.floatToIntBits(f1) & Float.floatToIntBits(f2) & Integer.MIN_VALUE) == 0) {
            return 0.0f;
        }
        return f1;
    }

    public static int max(int i1, int i2) {
        return Math.max(i1, i2);
    }

    public static long max(long l1, long l2) {
        return Math.max(l1, l2);
    }

    public static double min(double d1, double d2) {
        if (d1 > d2) {
            return d2;
        }
        if (d1 < d2) {
            return d1;
        }
        if (d1 != d2) {
            return Double.NaN;
        }
        if (d1 == 0.0 && ((Double.doubleToLongBits(d1) | Double.doubleToLongBits(d2)) & Long.MIN_VALUE) != 0L) {
            return -0.0;
        }
        return d1;
    }

    public static float min(float f1, float f2) {
        if (f1 > f2) {
            return f2;
        }
        if (f1 < f2) {
            return f1;
        }
        if (f1 != f2) {
            return Float.NaN;
        }
        if (f1 == 0.0f && ((Float.floatToIntBits(f1) | Float.floatToIntBits(f2)) & Integer.MIN_VALUE) != 0) {
            return -0.0f;
        }
        return f1;
    }

    public static int min(int i1, int i2) {
        return Math.min(i1, i2);
    }

    public static long min(long l1, long l2) {
        return Math.min(l1, l2);
    }

    public static native double pow(double var0, double var2);

    public static double random() {
        return Math.random();
    }

    public static native double rint(double var0);

    public static long round(double d) {
        return Math.round(d);
    }

    public static int round(float f) {
        return Math.round(f);
    }

    public static double signum(double d) {
        return Math.signum(d);
    }

    public static float signum(float f) {
        return Math.signum(f);
    }

    public static native double sinh(double var0);

    public static native double sin(double var0);

    public static native double sqrt(double var0);

    public static native double tan(double var0);

    public static native double tanh(double var0);

    public static double toDegrees(double angrad) {
        return Math.toDegrees(angrad);
    }

    public static double toRadians(double angdeg) {
        return Math.toRadians(angdeg);
    }

    public static double ulp(double d) {
        if (Double.isInfinite(d)) {
            return Double.POSITIVE_INFINITY;
        }
        if (d == Double.MAX_VALUE || d == -1.7976931348623157E308) {
            return StrictMath.pow(2.0, 971.0);
        }
        d = Math.abs(d);
        return StrictMath.nextafter(d, Double.MAX_VALUE) - d;
    }

    public static float ulp(float f) {
        return Math.ulp(f);
    }

    private static native double nextafter(double var0, double var2);

    public static double copySign(double magnitude, double sign) {
        long magnitudeBits = Double.doubleToRawLongBits(magnitude);
        long signBits = Double.doubleToRawLongBits(sign != sign ? 1.0 : sign);
        magnitudeBits = magnitudeBits & Long.MAX_VALUE | signBits & Long.MIN_VALUE;
        return Double.longBitsToDouble(magnitudeBits);
    }

    public static float copySign(float magnitude, float sign) {
        int magnitudeBits = Float.floatToRawIntBits(magnitude);
        int signBits = Float.floatToRawIntBits(sign != sign ? 1.0f : sign);
        magnitudeBits = magnitudeBits & Integer.MAX_VALUE | signBits & Integer.MIN_VALUE;
        return Float.intBitsToFloat(magnitudeBits);
    }

    public static int getExponent(float f) {
        return Math.getExponent(f);
    }

    public static int getExponent(double d) {
        return Math.getExponent(d);
    }

    public static double nextAfter(double start, double direction) {
        if (start == 0.0 && direction == 0.0) {
            return direction;
        }
        return StrictMath.nextafter(start, direction);
    }

    public static float nextAfter(float start, double direction) {
        return Math.nextAfter(start, direction);
    }

    public static double nextUp(double d) {
        return Math.nextUp(d);
    }

    public static float nextUp(float f) {
        return Math.nextUp(f);
    }

    public static double scalb(double d, int scaleFactor) {
        long result;
        if (Double.isNaN(d) || Double.isInfinite(d) || d == 0.0) {
            return d;
        }
        long bits = Double.doubleToLongBits(d);
        long sign = bits & Long.MIN_VALUE;
        long factor = (int)((bits & 0x7FF0000000000000L) >> 52) - 1023 + scaleFactor;
        int subNormalFactor = Long.numberOfLeadingZeros(bits & Long.MAX_VALUE) - 12;
        if (subNormalFactor < 0) {
            subNormalFactor = 0;
        }
        if (Math.abs(d) < Double.MIN_NORMAL) {
            factor -= (long)subNormalFactor;
        }
        if (factor > 1023L) {
            return d > 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        }
        if (factor < -1023L) {
            long digits = factor + 1023L + (long)subNormalFactor;
            result = Math.abs(d) < Double.MIN_NORMAL ? StrictMath.shiftLongBits(bits & 0xFFFFFFFFFFFFFL, digits) : StrictMath.shiftLongBits(bits & 0xFFFFFFFFFFFFFL | 0x10000000000000L, digits - 1L);
        } else {
            result = Math.abs(d) >= Double.MIN_NORMAL ? factor + 1023L << 52 | bits & 0xFFFFFFFFFFFFFL : factor + 1023L << 52 | bits << subNormalFactor + 1 & 0xFFFFFFFFFFFFFL;
        }
        return Double.longBitsToDouble(result | sign);
    }

    public static float scalb(float d, int scaleFactor) {
        int result;
        if (Float.isNaN(d) || Float.isInfinite(d) || d == 0.0f) {
            return d;
        }
        int bits = Float.floatToIntBits(d);
        int sign = bits & Integer.MIN_VALUE;
        int factor = ((bits & 0x7F800000) >> 23) - 127 + scaleFactor;
        int subNormalFactor = Integer.numberOfLeadingZeros(bits & Integer.MAX_VALUE) - 9;
        if (subNormalFactor < 0) {
            subNormalFactor = 0;
        }
        if (Math.abs(d) < Float.MIN_NORMAL) {
            factor -= subNormalFactor;
        }
        if (factor > 127) {
            return d > 0.0f ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY;
        }
        if (factor < -127) {
            int digits = factor + 127 + subNormalFactor;
            result = Math.abs(d) < Float.MIN_NORMAL ? StrictMath.shiftIntBits(bits & 0x7FFFFF, digits) : StrictMath.shiftIntBits(bits & 0x7FFFFF | 0x800000, digits - 1);
        } else {
            result = Math.abs(d) >= Float.MIN_NORMAL ? factor + 127 << 23 | bits & 0x7FFFFF : factor + 127 << 23 | bits << subNormalFactor + 1 & 0x7FFFFF;
        }
        return Float.intBitsToFloat(result | sign);
    }

    private static int shiftIntBits(int bits, int digits) {
        if (digits > 0) {
            return bits << digits;
        }
        int absDigits = -digits;
        if (Integer.numberOfLeadingZeros(bits & Integer.MAX_VALUE) <= 32 - absDigits) {
            if ((bits >> absDigits - 1 & 1) == 0 || Integer.numberOfTrailingZeros(bits) == absDigits - 1) {
                return bits >> absDigits;
            }
            return (bits >> absDigits) + 1;
        }
        return 0;
    }

    private static long shiftLongBits(long bits, long digits) {
        if (digits > 0L) {
            return bits << (int)digits;
        }
        long absDigits = -digits;
        if ((long)Long.numberOfLeadingZeros(bits & Long.MAX_VALUE) <= 64L - absDigits) {
            if ((bits >> (int)(absDigits - 1L) & 1L) == 0L || (long)Long.numberOfTrailingZeros(bits) == absDigits - 1L) {
                return bits >> (int)absDigits;
            }
            return (bits >> (int)absDigits) + 1L;
        }
        return 0L;
    }
}

