/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;

public final class StringBuffer
extends AbstractStringBuilder
implements Appendable,
Serializable,
CharSequence {
    private static final long serialVersionUID = 3388685877147921107L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("count", Integer.TYPE), new ObjectStreamField("shared", Boolean.TYPE), new ObjectStreamField("value", char[].class)};

    public StringBuffer() {
    }

    public StringBuffer(int capacity) {
        super(capacity);
    }

    public StringBuffer(String string) {
        super(string);
    }

    public StringBuffer(CharSequence cs) {
        super(((Object)cs).toString());
    }

    public StringBuffer append(boolean b) {
        return this.append(b ? "true" : "false");
    }

    public synchronized StringBuffer append(char ch) {
        this.append0(ch);
        return this;
    }

    public StringBuffer append(double d) {
        RealToString.getInstance().appendDouble(this, d);
        return this;
    }

    public StringBuffer append(float f) {
        RealToString.getInstance().appendFloat(this, f);
        return this;
    }

    public StringBuffer append(int i) {
        IntegralToString.appendInt(this, i);
        return this;
    }

    public StringBuffer append(long l) {
        IntegralToString.appendLong(this, l);
        return this;
    }

    public synchronized StringBuffer append(Object obj) {
        if (obj == null) {
            this.appendNull();
        } else {
            this.append0(obj.toString());
        }
        return this;
    }

    public synchronized StringBuffer append(String string) {
        this.append0(string);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StringBuffer append(StringBuffer sb) {
        if (sb == null) {
            this.appendNull();
        } else {
            StringBuffer stringBuffer = sb;
            synchronized (stringBuffer) {
                this.append0(sb.getValue(), 0, sb.length());
            }
        }
        return this;
    }

    public synchronized StringBuffer append(char[] chars) {
        this.append0(chars);
        return this;
    }

    public synchronized StringBuffer append(char[] chars, int start, int length) {
        this.append0(chars, start, length);
        return this;
    }

    public synchronized StringBuffer append(CharSequence s) {
        if (s == null) {
            this.appendNull();
        } else {
            this.append0(s, 0, s.length());
        }
        return this;
    }

    public synchronized StringBuffer append(CharSequence s, int start, int end) {
        this.append0(s, start, end);
        return this;
    }

    public StringBuffer appendCodePoint(int codePoint) {
        return this.append(Character.toChars(codePoint));
    }

    public synchronized char charAt(int index) {
        return super.charAt(index);
    }

    public synchronized int codePointAt(int index) {
        return super.codePointAt(index);
    }

    public synchronized int codePointBefore(int index) {
        return super.codePointBefore(index);
    }

    public synchronized int codePointCount(int beginIndex, int endIndex) {
        return super.codePointCount(beginIndex, endIndex);
    }

    public synchronized StringBuffer delete(int start, int end) {
        this.delete0(start, end);
        return this;
    }

    public synchronized StringBuffer deleteCharAt(int location) {
        this.deleteCharAt0(location);
        return this;
    }

    public synchronized void ensureCapacity(int min) {
        super.ensureCapacity(min);
    }

    public synchronized void getChars(int start, int end, char[] buffer, int idx) {
        super.getChars(start, end, buffer, idx);
    }

    public synchronized int indexOf(String subString, int start) {
        return super.indexOf(subString, start);
    }

    public synchronized StringBuffer insert(int index, char ch) {
        this.insert0(index, ch);
        return this;
    }

    public StringBuffer insert(int index, boolean b) {
        return this.insert(index, b ? "true" : "false");
    }

    public StringBuffer insert(int index, int i) {
        return this.insert(index, Integer.toString(i));
    }

    public StringBuffer insert(int index, long l) {
        return this.insert(index, Long.toString(l));
    }

    public StringBuffer insert(int index, double d) {
        return this.insert(index, Double.toString(d));
    }

    public StringBuffer insert(int index, float f) {
        return this.insert(index, Float.toString(f));
    }

    public StringBuffer insert(int index, Object obj) {
        return this.insert(index, obj == null ? "null" : obj.toString());
    }

    public synchronized StringBuffer insert(int index, String string) {
        this.insert0(index, string);
        return this;
    }

    public synchronized StringBuffer insert(int index, char[] chars) {
        this.insert0(index, chars);
        return this;
    }

    public synchronized StringBuffer insert(int index, char[] chars, int start, int length) {
        this.insert0(index, chars, start, length);
        return this;
    }

    public synchronized StringBuffer insert(int index, CharSequence s) {
        this.insert0(index, s == null ? "null" : ((Object)s).toString());
        return this;
    }

    public synchronized StringBuffer insert(int index, CharSequence s, int start, int end) {
        this.insert0(index, s, start, end);
        return this;
    }

    public synchronized int lastIndexOf(String subString, int start) {
        return super.lastIndexOf(subString, start);
    }

    public synchronized int offsetByCodePoints(int index, int codePointOffset) {
        return super.offsetByCodePoints(index, codePointOffset);
    }

    public synchronized StringBuffer replace(int start, int end, String string) {
        this.replace0(start, end, string);
        return this;
    }

    public synchronized StringBuffer reverse() {
        this.reverse0();
        return this;
    }

    public synchronized void setCharAt(int index, char ch) {
        super.setCharAt(index, ch);
    }

    public synchronized void setLength(int length) {
        super.setLength(length);
    }

    public synchronized CharSequence subSequence(int start, int end) {
        return super.substring(start, end);
    }

    public synchronized String substring(int start) {
        return super.substring(start);
    }

    public synchronized String substring(int start, int end) {
        return super.substring(start, end);
    }

    public synchronized String toString() {
        return super.toString();
    }

    public synchronized void trimToSize() {
        super.trimToSize();
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        ObjectOutputStream.PutField fields = out.putFields();
        fields.put("count", this.length());
        fields.put("shared", false);
        fields.put("value", this.getValue());
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = in.readFields();
        int count = fields.get("count", 0);
        char[] value = (char[])fields.get("value", null);
        this.set(value, count);
    }
}

