/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class StringBuilder
extends AbstractStringBuilder
implements Appendable,
CharSequence,
Serializable {
    private static final long serialVersionUID = 4383685877147921099L;

    public StringBuilder() {
    }

    public StringBuilder(int capacity) {
        super(capacity);
    }

    public StringBuilder(CharSequence seq) {
        super(((Object)seq).toString());
    }

    public StringBuilder(String str) {
        super(str);
    }

    public StringBuilder append(boolean b) {
        this.append0(b ? "true" : "false");
        return this;
    }

    public StringBuilder append(char c) {
        this.append0(c);
        return this;
    }

    public StringBuilder append(int i) {
        IntegralToString.appendInt(this, i);
        return this;
    }

    public StringBuilder append(long l) {
        IntegralToString.appendLong(this, l);
        return this;
    }

    public StringBuilder append(float f) {
        RealToString.getInstance().appendFloat(this, f);
        return this;
    }

    public StringBuilder append(double d) {
        RealToString.getInstance().appendDouble(this, d);
        return this;
    }

    public StringBuilder append(Object obj) {
        if (obj == null) {
            this.appendNull();
        } else {
            this.append0(obj.toString());
        }
        return this;
    }

    public StringBuilder append(String str) {
        this.append0(str);
        return this;
    }

    public StringBuilder append(StringBuffer sb) {
        if (sb == null) {
            this.appendNull();
        } else {
            this.append0(sb.getValue(), 0, sb.length());
        }
        return this;
    }

    public StringBuilder append(char[] chars) {
        this.append0(chars);
        return this;
    }

    public StringBuilder append(char[] str, int offset, int len) {
        this.append0(str, offset, len);
        return this;
    }

    public StringBuilder append(CharSequence csq) {
        if (csq == null) {
            this.appendNull();
        } else {
            this.append0(csq, 0, csq.length());
        }
        return this;
    }

    public StringBuilder append(CharSequence csq, int start, int end) {
        this.append0(csq, start, end);
        return this;
    }

    public StringBuilder appendCodePoint(int codePoint) {
        this.append0(Character.toChars(codePoint));
        return this;
    }

    public StringBuilder delete(int start, int end) {
        this.delete0(start, end);
        return this;
    }

    public StringBuilder deleteCharAt(int index) {
        this.deleteCharAt0(index);
        return this;
    }

    public StringBuilder insert(int offset, boolean b) {
        this.insert0(offset, b ? "true" : "false");
        return this;
    }

    public StringBuilder insert(int offset, char c) {
        this.insert0(offset, c);
        return this;
    }

    public StringBuilder insert(int offset, int i) {
        this.insert0(offset, Integer.toString(i));
        return this;
    }

    public StringBuilder insert(int offset, long l) {
        this.insert0(offset, Long.toString(l));
        return this;
    }

    public StringBuilder insert(int offset, float f) {
        this.insert0(offset, Float.toString(f));
        return this;
    }

    public StringBuilder insert(int offset, double d) {
        this.insert0(offset, Double.toString(d));
        return this;
    }

    public StringBuilder insert(int offset, Object obj) {
        this.insert0(offset, obj == null ? "null" : obj.toString());
        return this;
    }

    public StringBuilder insert(int offset, String str) {
        this.insert0(offset, str);
        return this;
    }

    public StringBuilder insert(int offset, char[] ch) {
        this.insert0(offset, ch);
        return this;
    }

    public StringBuilder insert(int offset, char[] str, int strOffset, int strLen) {
        this.insert0(offset, str, strOffset, strLen);
        return this;
    }

    public StringBuilder insert(int offset, CharSequence s) {
        this.insert0(offset, s == null ? "null" : ((Object)s).toString());
        return this;
    }

    public StringBuilder insert(int offset, CharSequence s, int start, int end) {
        this.insert0(offset, s, start, end);
        return this;
    }

    public StringBuilder replace(int start, int end, String str) {
        this.replace0(start, end, str);
        return this;
    }

    public StringBuilder reverse() {
        this.reverse0();
        return this;
    }

    public String toString() {
        return super.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int count = in.readInt();
        char[] value = (char[])in.readObject();
        this.set(value, count);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.length());
        out.writeObject(this.getValue());
    }
}

