/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import libcore.util.CollectionUtils;

public class ThreadGroup
implements Thread.UncaughtExceptionHandler {
    private String name;
    private int maxPriority = 10;
    final ThreadGroup parent;
    private final List<WeakReference<Thread>> threadRefs = new ArrayList<WeakReference<Thread>>(5);
    private final Iterable<Thread> threads = CollectionUtils.dereferenceIterable(this.threadRefs, true);
    private final List<ThreadGroup> groups = new ArrayList<ThreadGroup>(3);
    private boolean isDaemon;
    private boolean isDestroyed;
    static final ThreadGroup mSystem = new ThreadGroup();
    static final ThreadGroup mMain = new ThreadGroup(mSystem, "main");

    public ThreadGroup(String name) {
        this(Thread.currentThread().getThreadGroup(), name);
    }

    public ThreadGroup(ThreadGroup parent, String name) {
        if (parent == null) {
            throw new NullPointerException("parent == null");
        }
        this.name = name;
        this.parent = parent;
        if (parent != null) {
            parent.add(this);
            this.setMaxPriority(parent.getMaxPriority());
            if (parent.isDaemon()) {
                this.setDaemon(true);
            }
        }
    }

    private ThreadGroup() {
        this.name = "system";
        this.parent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int activeCount() {
        int count = 0;
        List<Object> list = this.threadRefs;
        synchronized (list) {
            for (Thread thread : this.threads) {
                if (!thread.isAlive()) continue;
                ++count;
            }
        }
        list = this.groups;
        synchronized (list) {
            for (ThreadGroup group : this.groups) {
                count += group.activeCount();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int activeGroupCount() {
        int count = 0;
        List<ThreadGroup> list = this.groups;
        synchronized (list) {
            for (ThreadGroup group : this.groups) {
                count += 1 + group.activeGroupCount();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(ThreadGroup g) throws IllegalThreadStateException {
        List<ThreadGroup> list = this.groups;
        synchronized (list) {
            if (this.isDestroyed) {
                throw new IllegalThreadStateException();
            }
            this.groups.add(g);
        }
    }

    @Deprecated
    public boolean allowThreadSuspension(boolean b) {
        return true;
    }

    public final void checkAccess() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        List<WeakReference<Thread>> list = this.threadRefs;
        synchronized (list) {
            List<ThreadGroup> list2 = this.groups;
            synchronized (list2) {
                if (this.isDestroyed) {
                    throw new IllegalThreadStateException("Thread group was already destroyed: " + (this.name != null ? this.name : "n/a"));
                }
                if (this.threads.iterator().hasNext()) {
                    throw new IllegalThreadStateException("Thread group still contains threads: " + (this.name != null ? this.name : "n/a"));
                }
                while (!this.groups.isEmpty()) {
                    this.groups.get(0).destroy();
                }
                if (this.parent != null) {
                    this.parent.remove(this);
                }
                this.isDestroyed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyIfEmptyDaemon() {
        List<WeakReference<Thread>> list = this.threadRefs;
        synchronized (list) {
            if (this.isDaemon && !this.isDestroyed && !this.threads.iterator().hasNext()) {
                List<ThreadGroup> list2 = this.groups;
                synchronized (list2) {
                    if (this.groups.isEmpty()) {
                        this.destroy();
                    }
                }
            }
        }
    }

    public int enumerate(Thread[] threads) {
        return this.enumerate(threads, true);
    }

    public int enumerate(Thread[] threads, boolean recurse) {
        return this.enumerateGeneric(threads, recurse, 0, true);
    }

    public int enumerate(ThreadGroup[] groups) {
        return this.enumerate(groups, true);
    }

    public int enumerate(ThreadGroup[] groups, boolean recurse) {
        return this.enumerateGeneric(groups, recurse, 0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int enumerateGeneric(Object[] enumeration, boolean recurse, int enumerationIndex, boolean enumeratingThreads) {
        int i;
        List<Object> list;
        if (enumeratingThreads) {
            list = this.threadRefs;
            synchronized (list) {
                for (i = this.threadRefs.size() - 1; i >= 0; --i) {
                    Thread thread = (Thread)this.threadRefs.get(i).get();
                    if (thread == null || !thread.isAlive()) continue;
                    if (enumerationIndex >= enumeration.length) {
                        return enumerationIndex;
                    }
                    enumeration[enumerationIndex++] = thread;
                }
            }
        }
        list = this.groups;
        synchronized (list) {
            for (i = this.groups.size() - 1; i >= 0; --i) {
                if (enumerationIndex >= enumeration.length) {
                    return enumerationIndex;
                }
                enumeration[enumerationIndex++] = this.groups.get(i);
            }
        }
        if (recurse) {
            list = this.groups;
            synchronized (list) {
                for (ThreadGroup group : this.groups) {
                    if (enumerationIndex >= enumeration.length) {
                        return enumerationIndex;
                    }
                    enumerationIndex = group.enumerateGeneric(enumeration, recurse, enumerationIndex, enumeratingThreads);
                }
            }
        }
        return enumerationIndex;
    }

    public final int getMaxPriority() {
        return this.maxPriority;
    }

    public final String getName() {
        return this.name;
    }

    public final ThreadGroup getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void interrupt() {
        List<Object> list = this.threadRefs;
        synchronized (list) {
            for (Thread thread : this.threads) {
                thread.interrupt();
            }
        }
        list = this.groups;
        synchronized (list) {
            for (ThreadGroup group : this.groups) {
                group.interrupt();
            }
        }
    }

    public final boolean isDaemon() {
        return this.isDaemon;
    }

    public synchronized boolean isDestroyed() {
        return this.isDestroyed;
    }

    public void list() {
        System.out.println();
        this.list(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void list(int levels) {
        this.indent(levels);
        System.out.println(this.toString());
        ++levels;
        List<Object> list = this.threadRefs;
        synchronized (list) {
            for (Thread thread : this.threads) {
                this.indent(levels);
                System.out.println(thread);
            }
        }
        list = this.groups;
        synchronized (list) {
            for (ThreadGroup group : this.groups) {
                group.list(levels);
            }
        }
    }

    private void indent(int levels) {
        for (int i = 0; i < levels; ++i) {
            System.out.print("    ");
        }
    }

    public final boolean parentOf(ThreadGroup g) {
        while (g != null) {
            if (this == g) {
                return true;
            }
            g = g.parent;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(ThreadGroup g) {
        List<ThreadGroup> list = this.groups;
        synchronized (list) {
            Iterator<ThreadGroup> i = this.groups.iterator();
            while (i.hasNext()) {
                ThreadGroup threadGroup = i.next();
                if (!threadGroup.equals(g)) continue;
                i.remove();
                break;
            }
        }
        this.destroyIfEmptyDaemon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void resume() {
        List<Object> list = this.threadRefs;
        synchronized (list) {
            for (Thread thread : this.threads) {
                thread.resume();
            }
        }
        list = this.groups;
        synchronized (list) {
            for (ThreadGroup group : this.groups) {
                group.resume();
            }
        }
    }

    public final void setDaemon(boolean isDaemon) {
        this.isDaemon = isDaemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMaxPriority(int newMax) {
        if (newMax <= this.maxPriority) {
            if (newMax < 1) {
                newMax = 1;
            }
            int parentPriority = this.parent == null ? newMax : this.parent.getMaxPriority();
            this.maxPriority = parentPriority <= newMax ? parentPriority : newMax;
            List<ThreadGroup> list = this.groups;
            synchronized (list) {
                for (ThreadGroup group : this.groups) {
                    group.setMaxPriority(newMax);
                }
            }
        }
    }

    @Deprecated
    public final void stop() {
        if (this.stopHelper()) {
            Thread.currentThread().stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stopHelper() {
        boolean stopCurrent = false;
        List<Object> list = this.threadRefs;
        synchronized (list) {
            Thread current = Thread.currentThread();
            for (Thread thread : this.threads) {
                if (thread == current) {
                    stopCurrent = true;
                    continue;
                }
                thread.stop();
            }
        }
        list = this.groups;
        synchronized (list) {
            for (ThreadGroup group : this.groups) {
                stopCurrent |= group.stopHelper();
            }
        }
        return stopCurrent;
    }

    @Deprecated
    public final void suspend() {
        if (this.suspendHelper()) {
            Thread.currentThread().suspend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean suspendHelper() {
        boolean suspendCurrent = false;
        List<Object> list = this.threadRefs;
        synchronized (list) {
            Thread current = Thread.currentThread();
            for (Thread thread : this.threads) {
                if (thread == current) {
                    suspendCurrent = true;
                    continue;
                }
                thread.suspend();
            }
        }
        list = this.groups;
        synchronized (list) {
            for (ThreadGroup group : this.groups) {
                suspendCurrent |= group.suspendHelper();
            }
        }
        return suspendCurrent;
    }

    public String toString() {
        return this.getClass().getName() + "[name=" + this.getName() + ",maxPriority=" + this.getMaxPriority() + "]";
    }

    public void uncaughtException(Thread t, Throwable e) {
        if (this.parent != null) {
            this.parent.uncaughtException(t, e);
        } else if (Thread.getDefaultUncaughtExceptionHandler() != null) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(t, e);
        } else if (!(e instanceof ThreadDeath)) {
            e.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addThread(Thread thread) throws IllegalThreadStateException {
        List<WeakReference<Thread>> list = this.threadRefs;
        synchronized (list) {
            if (this.isDestroyed) {
                throw new IllegalThreadStateException();
            }
            this.threadRefs.add(new WeakReference<Thread>(thread));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeThread(Thread thread) throws IllegalThreadStateException {
        List<WeakReference<Thread>> list = this.threadRefs;
        synchronized (list) {
            Iterator<Thread> i = this.threads.iterator();
            while (i.hasNext()) {
                if (!i.next().equals(thread)) continue;
                i.remove();
                break;
            }
        }
        this.destroyIfEmptyDaemon();
    }
}

