/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import libcore.util.EmptyArray;

public class Throwable
implements Serializable {
    private static final long serialVersionUID = -3042686055658047285L;
    private String detailMessage;
    private Throwable cause = this;
    private List<Throwable> suppressedExceptions = new ArrayList<Throwable>();
    private volatile Object stackState;
    private StackTraceElement[] stackTrace;

    public Throwable() {
        this.fillInStackTrace();
    }

    public Throwable(String detailMessage) {
        this();
        this.detailMessage = detailMessage;
    }

    public Throwable(String detailMessage, Throwable throwable) {
        this();
        this.detailMessage = detailMessage;
        this.cause = throwable;
    }

    public Throwable(Throwable throwable) {
        this();
        this.detailMessage = throwable == null ? null : throwable.toString();
        this.cause = throwable;
    }

    protected Throwable(String detailMessage, Throwable throwable, boolean enableSuppression) {
        this(detailMessage, throwable);
        if (!enableSuppression) {
            this.suppressedExceptions = null;
        }
    }

    public Throwable fillInStackTrace() {
        this.stackState = Throwable.nativeFillInStackTrace();
        this.stackTrace = null;
        return this;
    }

    public String getMessage() {
        return this.detailMessage;
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public StackTraceElement[] getStackTrace() {
        return (StackTraceElement[])this.getInternalStackTrace().clone();
    }

    public void setStackTrace(StackTraceElement[] trace) {
        StackTraceElement[] newTrace;
        for (StackTraceElement element : newTrace = (StackTraceElement[])trace.clone()) {
            if (element != null) continue;
            throw new NullPointerException();
        }
        this.stackTrace = newTrace;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    private static int countDuplicates(StackTraceElement[] currentStack, StackTraceElement[] parentStack) {
        StackTraceElement parentFrame;
        int duplicates = 0;
        int parentIndex = parentStack.length;
        int i = currentStack.length;
        while (--i >= 0 && --parentIndex >= 0 && (parentFrame = parentStack[parentIndex]).equals(currentStack[i])) {
            ++duplicates;
        }
        return duplicates;
    }

    private StackTraceElement[] getInternalStackTrace() {
        if (this.stackTrace == null) {
            this.stackTrace = Throwable.nativeGetStackTrace(this.stackState);
            this.stackState = null;
        }
        return this.stackTrace;
    }

    public void printStackTrace(PrintStream err) {
        try {
            this.printStackTrace(err, "", null);
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    public void printStackTrace(PrintWriter err) {
        try {
            this.printStackTrace(err, "", null);
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    private void printStackTrace(Appendable err, String indent, StackTraceElement[] parentStack) throws IOException {
        Throwable cause;
        err.append(this.toString());
        err.append("\n");
        StackTraceElement[] stack = this.getInternalStackTrace();
        if (stack != null) {
            int duplicates = parentStack != null ? Throwable.countDuplicates(stack, parentStack) : 0;
            for (int i = 0; i < stack.length - duplicates; ++i) {
                err.append(indent);
                err.append("\tat ");
                err.append(stack[i].toString());
                err.append("\n");
            }
            if (duplicates > 0) {
                err.append(indent);
                err.append("\t... ");
                err.append(Integer.toString(duplicates));
                err.append(" more\n");
            }
        }
        if (this.suppressedExceptions != null) {
            for (Throwable throwable : this.suppressedExceptions) {
                err.append(indent);
                err.append("\tSuppressed: ");
                throwable.printStackTrace(err, indent + "\t", stack);
            }
        }
        if ((cause = this.getCause()) != null) {
            err.append(indent);
            err.append("Caused by: ");
            cause.printStackTrace(err, indent, stack);
        }
    }

    public String toString() {
        String msg = this.getLocalizedMessage();
        String name = this.getClass().getName();
        if (msg == null) {
            return name;
        }
        return name + ": " + msg;
    }

    public Throwable initCause(Throwable throwable) {
        if (this.cause != this) {
            throw new IllegalStateException("Cause already initialized");
        }
        if (throwable == this) {
            throw new IllegalArgumentException("throwable == this");
        }
        this.cause = throwable;
        return this;
    }

    public Throwable getCause() {
        if (this.cause == this) {
            return null;
        }
        return this.cause;
    }

    public final void addSuppressed(Throwable throwable) {
        if (throwable == this) {
            throw new IllegalArgumentException("suppressed == this");
        }
        if (throwable == null) {
            throw new NullPointerException("suppressed == null");
        }
        if (this.suppressedExceptions != null) {
            this.suppressedExceptions.add(throwable);
        }
    }

    public final Throwable[] getSuppressed() {
        return this.suppressedExceptions != null ? this.suppressedExceptions.toArray(new Throwable[this.suppressedExceptions.size()]) : EmptyArray.THROWABLE;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.getInternalStackTrace();
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.suppressedExceptions != null) {
            this.suppressedExceptions = new ArrayList<Throwable>(this.suppressedExceptions);
        }
    }

    private static native Object nativeFillInStackTrace();

    private static native StackTraceElement[] nativeGetStackTrace(Object var0);
}

