/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VMClassLoader {
    VMClassLoader() {
    }

    static URL getResource(String name) {
        int numEntries = VMClassLoader.getBootClassPathSize();
        for (int i = 0; i < numEntries; ++i) {
            String urlStr = VMClassLoader.getBootClassPathResource(name, i);
            if (urlStr == null) continue;
            try {
                return new URL(urlStr);
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
            }
        }
        return null;
    }

    static List<URL> getResources(String name) {
        ArrayList<URL> list = new ArrayList<URL>();
        int numEntries = VMClassLoader.getBootClassPathSize();
        for (int i = 0; i < numEntries; ++i) {
            String urlStr = VMClassLoader.getBootClassPathResource(name, i);
            if (urlStr == null) continue;
            try {
                list.add(new URL(urlStr));
                continue;
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
            }
        }
        return list;
    }

    static native Class loadClass(String var0, boolean var1) throws ClassNotFoundException;

    static native Class getPrimitiveClass(char var0);

    static native Class defineClass(ClassLoader var0, String var1, byte[] var2, int var3, int var4) throws ClassFormatError;

    static native Class defineClass(ClassLoader var0, byte[] var1, int var2, int var3) throws ClassFormatError;

    static native Class findLoadedClass(ClassLoader var0, String var1);

    private static native int getBootClassPathSize();

    private static native String getBootClassPathResource(String var0, int var1);
}

