/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FinalizerReference<T>
extends Reference<T> {
    public static final ReferenceQueue<Object> queue = new ReferenceQueue();
    private static FinalizerReference head = null;
    private T zombie;
    private FinalizerReference prev;
    private FinalizerReference next;

    public FinalizerReference(T r, ReferenceQueue<? super T> q) {
        super(r, q);
    }

    @Override
    public T get() {
        return this.zombie;
    }

    @Override
    public void clear() {
        this.zombie = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void add(Object referent) {
        FinalizerReference<Object> reference = new FinalizerReference<Object>(referent, queue);
        Class<FinalizerReference> clazz = FinalizerReference.class;
        synchronized (FinalizerReference.class) {
            reference.prev = null;
            reference.next = head;
            if (head != null) {
                FinalizerReference.head.prev = reference;
            }
            head = reference;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(FinalizerReference reference) {
        Class<FinalizerReference> clazz = FinalizerReference.class;
        synchronized (FinalizerReference.class) {
            FinalizerReference next = reference.next;
            FinalizerReference prev = reference.prev;
            reference.next = null;
            reference.prev = null;
            if (prev != null) {
                prev.next = next;
            } else {
                head = next;
            }
            if (next != null) {
                next.prev = prev;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void finalizeAllEnqueued() throws InterruptedException {
        Sentinel sentinel = new Sentinel();
        FinalizerReference<Object> reference = new FinalizerReference<Object>(null, queue);
        reference.zombie = sentinel;
        reference.enqueueInternal();
        sentinel.awaitFinalization();
    }

    private static class Sentinel {
        boolean finalized = false;

        private Sentinel() {
        }

        protected synchronized void finalize() throws Throwable {
            this.finalized = true;
            this.notifyAll();
        }

        synchronized void awaitFinalization() throws InterruptedException {
            while (!this.finalized) {
                this.wait();
            }
        }
    }
}

