/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceQueue<T> {
    private static final int NANOS_PER_MILLI = 1000000;
    private Reference<? extends T> head;
    public static Reference unenqueued = null;

    public synchronized Reference<? extends T> poll() {
        if (this.head == null) {
            return null;
        }
        Reference<? extends T> ret = this.head;
        this.head = this.head == this.head.queueNext ? null : this.head.queueNext;
        ret.queueNext = null;
        return ret;
    }

    public Reference<? extends T> remove() throws InterruptedException {
        return this.remove(0L);
    }

    public synchronized Reference<? extends T> remove(long timeoutMillis) throws InterruptedException {
        if (timeoutMillis < 0L) {
            throw new IllegalArgumentException("timeout < 0: " + timeoutMillis);
        }
        if (this.head != null) {
            return this.poll();
        }
        if (timeoutMillis == 0L || timeoutMillis > 9223372036854L) {
            do {
                this.wait(0L);
            } while (this.head == null);
            return this.poll();
        }
        long nanosToWait = timeoutMillis * 1000000L;
        int timeoutNanos = 0;
        long startTime = System.nanoTime();
        while (true) {
            long nanosElapsed;
            long nanosRemaining;
            this.wait(timeoutMillis, timeoutNanos);
            if (this.head != null || (nanosRemaining = nanosToWait - (nanosElapsed = System.nanoTime() - startTime)) <= 0L) break;
            timeoutMillis = nanosRemaining / 1000000L;
            timeoutNanos = (int)(nanosRemaining - timeoutMillis * 1000000L);
        }
        return this.poll();
    }

    synchronized void enqueue(Reference<? extends T> reference) {
        reference.queueNext = this.head == null ? reference : this.head;
        this.head = reference;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void add(Reference<?> list) {
        Class<ReferenceQueue> clazz = ReferenceQueue.class;
        synchronized (ReferenceQueue.class) {
            if (unenqueued == null) {
                unenqueued = list;
            } else {
                Reference<?> next = ReferenceQueue.unenqueued.pendingNext;
                ReferenceQueue.unenqueued.pendingNext = list.pendingNext;
                list.pendingNext = next;
            }
            ReferenceQueue.class.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

