/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Hashtable;
import org.apache.harmony.kernel.vm.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessibleObject
implements AnnotatedElement {
    boolean flag = false;
    static Hashtable<String, String> trans = new Hashtable(9);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAccessible(AccessibleObject[] objects, boolean flag) {
        Class<AccessibleObject> clazz = AccessibleObject.class;
        synchronized (AccessibleObject.class) {
            for (AccessibleObject object : objects) {
                object.flag = flag;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected AccessibleObject() {
    }

    public boolean isAccessible() {
        return this.flag;
    }

    public void setAccessible(boolean flag) {
        this.flag = flag;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getDeclaredAnnotations();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        throw new UnsupportedOperationException();
    }

    String getSignature(Class<?> clazz) {
        String result = "";
        String nextType = clazz.getName();
        result = trans.containsKey(nextType) ? trans.get(nextType) : (clazz.isArray() ? "[" + this.getSignature(clazz.getComponentType()) : "L" + nextType + ";");
        return result;
    }

    String toString(Class<?>[] types) {
        StringBuilder result = new StringBuilder();
        if (types.length != 0) {
            result.append(types[0].getName());
            for (int i = 1; i < types.length; ++i) {
                result.append(',');
                result.append(types[i].getName());
            }
        }
        return result.toString();
    }

    String getSignatureAttribute() {
        throw new UnsupportedOperationException();
    }

    static String getClassSignatureAttribute(Class clazz) {
        Object[] annotation = AccessibleObject.getClassSignatureAnnotation(clazz);
        if (annotation == null) {
            return null;
        }
        return StringUtils.combineStrings(annotation);
    }

    private static native Object[] getClassSignatureAnnotation(Class var0);

    void appendArrayType(StringBuilder sb, Class<?> obj) {
        int dimensions = 0;
        while (obj.isArray()) {
            obj = obj.getComponentType();
            ++dimensions;
        }
        sb.append(obj.getName());
        for (int d = 0; d < dimensions; ++d) {
            sb.append("[]");
        }
    }

    void appendArrayGenericType(StringBuilder sb, Type[] types) {
        if (types.length > 0) {
            this.appendGenericType(sb, types[0]);
            for (int i = 1; i < types.length; ++i) {
                sb.append(',');
                this.appendGenericType(sb, types[i]);
            }
        }
    }

    void appendGenericType(StringBuilder sb, Type obj) {
        if (obj instanceof TypeVariable) {
            sb.append(((TypeVariable)obj).getName());
        } else if (obj instanceof ParameterizedType) {
            sb.append(obj.toString());
        } else if (obj instanceof GenericArrayType) {
            Type simplified = ((GenericArrayType)obj).getGenericComponentType();
            this.appendGenericType(sb, simplified);
            sb.append("[]");
        } else if (obj instanceof Class) {
            Class c = (Class)obj;
            if (c.isArray()) {
                int len;
                String[] as = c.getName().split("\\[");
                if (as[len = as.length - 1].length() > 1) {
                    sb.append(as[len].substring(1, as[len].length() - 1));
                } else {
                    char ch = as[len].charAt(0);
                    if (ch == 'I') {
                        sb.append("int");
                    } else if (ch == 'B') {
                        sb.append("byte");
                    } else if (ch == 'J') {
                        sb.append("long");
                    } else if (ch == 'F') {
                        sb.append("float");
                    } else if (ch == 'D') {
                        sb.append("double");
                    } else if (ch == 'S') {
                        sb.append("short");
                    } else if (ch == 'C') {
                        sb.append("char");
                    } else if (ch == 'Z') {
                        sb.append("boolean");
                    } else if (ch == 'V') {
                        sb.append("void");
                    }
                }
                for (int i = 0; i < len; ++i) {
                    sb.append("[]");
                }
            } else {
                sb.append(c.getName());
            }
        }
    }

    static {
        trans.put("byte", "B");
        trans.put("char", "C");
        trans.put("short", "S");
        trans.put("int", "I");
        trans.put("long", "J");
        trans.put("float", "F");
        trans.put("double", "D");
        trans.put("void", "V");
        trans.put("boolean", "Z");
    }
}

