/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Array {
    private Array() {
    }

    public static Object get(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array instanceof Object[]) {
            return ((Object[])array)[index];
        }
        if (array instanceof boolean[]) {
            return ((boolean[])array)[index] ? Boolean.TRUE : Boolean.FALSE;
        }
        if (array instanceof byte[]) {
            return ((byte[])array)[index];
        }
        if (array instanceof char[]) {
            return Character.valueOf(((char[])array)[index]);
        }
        if (array instanceof short[]) {
            return ((short[])array)[index];
        }
        if (array instanceof int[]) {
            return ((int[])array)[index];
        }
        if (array instanceof long[]) {
            return ((long[])array)[index];
        }
        if (array instanceof float[]) {
            return new Float(((float[])array)[index]);
        }
        if (array instanceof double[]) {
            return new Double(((double[])array)[index]);
        }
        if (array == null) {
            throw new NullPointerException();
        }
        throw new IllegalArgumentException("Not an array");
    }

    public static boolean getBoolean(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array instanceof boolean[]) {
            return ((boolean[])array)[index];
        }
        if (array == null) {
            throw new NullPointerException();
        }
        if (array.getClass().isArray()) {
            throw new IllegalArgumentException("Wrong array type");
        }
        throw new IllegalArgumentException("Not an array");
    }

    public static byte getByte(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array instanceof byte[]) {
            return ((byte[])array)[index];
        }
        return Array.getBoolean(array, index) ? (byte)1 : 0;
    }

    public static char getChar(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array instanceof char[]) {
            return ((char[])array)[index];
        }
        if (array == null) {
            throw new NullPointerException();
        }
        if (array.getClass().isArray()) {
            throw new IllegalArgumentException("Wrong array type");
        }
        throw new IllegalArgumentException("Not an array");
    }

    public static double getDouble(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array instanceof double[]) {
            return ((double[])array)[index];
        }
        return Array.getFloat(array, index);
    }

    public static float getFloat(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array instanceof float[]) {
            return ((float[])array)[index];
        }
        return Array.getLong(array, index);
    }

    public static int getInt(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array instanceof int[]) {
            return ((int[])array)[index];
        }
        return Array.getShort(array, index);
    }

    public static int getLength(Object array) {
        if (array instanceof Object[]) {
            return ((Object[])array).length;
        }
        if (array instanceof boolean[]) {
            return ((boolean[])array).length;
        }
        if (array instanceof byte[]) {
            return ((byte[])array).length;
        }
        if (array instanceof char[]) {
            return ((char[])array).length;
        }
        if (array instanceof short[]) {
            return ((short[])array).length;
        }
        if (array instanceof int[]) {
            return ((int[])array).length;
        }
        if (array instanceof long[]) {
            return ((long[])array).length;
        }
        if (array instanceof float[]) {
            return ((float[])array).length;
        }
        if (array instanceof double[]) {
            return ((double[])array).length;
        }
        if (array == null) {
            throw new NullPointerException();
        }
        throw new IllegalArgumentException("Not an array");
    }

    public static long getLong(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array instanceof long[]) {
            return ((long[])array)[index];
        }
        return Array.getInt(array, index);
    }

    public static short getShort(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array instanceof short[]) {
            return ((short[])array)[index];
        }
        return Array.getByte(array, index);
    }

    public static Object newInstance(Class<?> componentType, int ... dimensions) throws NegativeArraySizeException, IllegalArgumentException {
        if (dimensions.length <= 0 || dimensions.length > 255) {
            throw new IllegalArgumentException("Bad number of dimensions");
        }
        if (componentType == Void.TYPE) {
            throw new IllegalArgumentException();
        }
        if (componentType == null) {
            throw new NullPointerException();
        }
        return Array.createMultiArray(componentType, dimensions);
    }

    private static native Object createMultiArray(Class<?> var0, int[] var1) throws NegativeArraySizeException;

    public static Object newInstance(Class<?> componentType, int size) throws NegativeArraySizeException {
        if (!componentType.isPrimitive()) {
            return Array.createObjectArray(componentType, size);
        }
        if (componentType == Boolean.TYPE) {
            return new boolean[size];
        }
        if (componentType == Byte.TYPE) {
            return new byte[size];
        }
        if (componentType == Character.TYPE) {
            return new char[size];
        }
        if (componentType == Short.TYPE) {
            return new short[size];
        }
        if (componentType == Integer.TYPE) {
            return new int[size];
        }
        if (componentType == Long.TYPE) {
            return new long[size];
        }
        if (componentType == Float.TYPE) {
            return new float[size];
        }
        if (componentType == Double.TYPE) {
            return new double[size];
        }
        if (componentType == Void.TYPE) {
            throw new IllegalArgumentException();
        }
        throw new AssertionError();
    }

    private static native Object createObjectArray(Class<?> var0, int var1) throws NegativeArraySizeException;

    public static void set(Object array, int index, Object value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("Not an array type");
        }
        if (array instanceof Object[]) {
            if (value != null && !array.getClass().getComponentType().isInstance(value)) {
                throw new IllegalArgumentException("Wrong array type");
            }
            ((Object[])array)[index] = value;
        } else {
            if (value == null) {
                throw new IllegalArgumentException("Primitive array can't take null values.");
            }
            if (value instanceof Boolean) {
                Array.setBoolean(array, index, (Boolean)value);
            } else if (value instanceof Byte) {
                Array.setByte(array, index, (Byte)value);
            } else if (value instanceof Character) {
                Array.setChar(array, index, ((Character)value).charValue());
            } else if (value instanceof Short) {
                Array.setShort(array, index, (Short)value);
            } else if (value instanceof Integer) {
                Array.setInt(array, index, (Integer)value);
            } else if (value instanceof Long) {
                Array.setLong(array, index, (Long)value);
            } else if (value instanceof Float) {
                Array.setFloat(array, index, ((Float)value).floatValue());
            } else if (value instanceof Double) {
                Array.setDouble(array, index, (Double)value);
            }
        }
    }

    public static void setBoolean(Object array, int index, boolean value) {
        if (array instanceof boolean[]) {
            ((boolean[])array)[index] = value;
        } else {
            Array.setByte(array, index, value ? (byte)1 : 0);
        }
    }

    public static void setByte(Object array, int index, byte value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array instanceof byte[]) {
            ((byte[])array)[index] = value;
        } else {
            Array.setShort(array, index, value);
        }
    }

    public static void setChar(Object array, int index, char value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (!(array instanceof char[])) {
            if (array == null) {
                throw new NullPointerException();
            }
            if (!array.getClass().isArray()) {
                throw new IllegalArgumentException("Not an array");
            }
            throw new IllegalArgumentException("Wrong array type");
        }
        ((char[])array)[index] = value;
    }

    public static void setDouble(Object array, int index, double value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (!(array instanceof double[])) {
            if (array == null) {
                throw new NullPointerException();
            }
            if (!array.getClass().isArray()) {
                throw new IllegalArgumentException("Not an array");
            }
            throw new IllegalArgumentException("Wrong array type");
        }
        ((double[])array)[index] = value;
    }

    public static void setFloat(Object array, int index, float value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array instanceof float[]) {
            ((float[])array)[index] = value;
        } else {
            Array.setDouble(array, index, value);
        }
    }

    public static void setInt(Object array, int index, int value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array instanceof int[]) {
            ((int[])array)[index] = value;
        } else {
            Array.setLong(array, index, value);
        }
    }

    public static void setLong(Object array, int index, long value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array instanceof long[]) {
            ((long[])array)[index] = value;
        } else {
            Array.setFloat(array, index, value);
        }
    }

    public static void setShort(Object array, int index, short value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array instanceof short[]) {
            ((short[])array)[index] = value;
        } else {
            Array.setInt(array, index, value);
        }
    }
}

