/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Comparator;
import org.apache.harmony.kernel.vm.StringUtils;
import org.apache.harmony.luni.lang.reflect.GenericSignatureParser;
import org.apache.harmony.luni.lang.reflect.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Field
extends AccessibleObject
implements Member {
    public static final Comparator<Field> ORDER_BY_NAME_AND_DECLARING_CLASS = new Comparator<Field>(){

        @Override
        public int compare(Field a, Field b) {
            int comparison = a.name.compareTo(b.name);
            if (comparison != 0) {
                return comparison;
            }
            return a.getDeclaringClass().getName().compareTo(b.getDeclaringClass().getName());
        }
    };
    private Class<?> declaringClass;
    private Class<?> type;
    private Type genericType;
    private volatile boolean genericTypesAreInitialized = false;
    private String name;
    private int slot;
    private static final char TYPE_BOOLEAN = 'Z';
    private static final char TYPE_BYTE = 'B';
    private static final char TYPE_CHAR = 'C';
    private static final char TYPE_SHORT = 'S';
    private static final char TYPE_INTEGER = 'I';
    private static final char TYPE_FLOAT = 'F';
    private static final char TYPE_LONG = 'J';
    private static final char TYPE_DOUBLE = 'D';

    Field(Field orig) {
        this(orig.declaringClass, orig.type, orig.name, orig.slot);
        if (orig.flag) {
            this.flag = true;
        }
    }

    private Field(Class<?> declaringClass, Class<?> type, String name, int slot) {
        this.declaringClass = declaringClass;
        this.type = type;
        this.name = name;
        this.slot = slot;
    }

    private synchronized void initGenericType() {
        if (!this.genericTypesAreInitialized) {
            String signatureAttribute = this.getSignatureAttribute();
            GenericSignatureParser parser = new GenericSignatureParser(this.declaringClass.getClassLoader());
            parser.parseForField(this.declaringClass, signatureAttribute);
            this.genericType = parser.fieldType;
            if (this.genericType == null) {
                this.genericType = this.getType();
            }
            this.genericTypesAreInitialized = true;
        }
    }

    @Override
    String getSignatureAttribute() {
        Object[] annotation = this.getSignatureAnnotation(this.declaringClass, this.slot);
        if (annotation == null) {
            return null;
        }
        return StringUtils.combineStrings(annotation);
    }

    private native Object[] getSignatureAnnotation(Class var1, int var2);

    @Override
    public boolean isSynthetic() {
        int flags = this.getFieldModifiers(this.declaringClass, this.slot);
        return (flags & 0x1000) != 0;
    }

    public String toGenericString() {
        StringBuilder sb = new StringBuilder(80);
        int modifier = this.getModifiers();
        if (modifier != 0) {
            sb.append(Modifier.toString(modifier)).append(' ');
        }
        this.appendGenericType(sb, this.getGenericType());
        sb.append(' ');
        sb.append(this.getDeclaringClass().getName()).append('.').append(this.getName());
        return sb.toString();
    }

    public boolean isEnumConstant() {
        int flags = this.getFieldModifiers(this.declaringClass, this.slot);
        return (flags & 0x4000) != 0;
    }

    public Type getGenericType() {
        this.initGenericType();
        return Types.getType(this.genericType);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return Field.getDeclaredAnnotations(this.declaringClass, this.slot);
    }

    private static native Annotation[] getDeclaredAnnotations(Class var0, int var1);

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        if (annotationType == null) {
            throw new NullPointerException("annotationType == null");
        }
        return Field.getAnnotation(this.declaringClass, this.slot, annotationType);
    }

    private static native <A extends Annotation> A getAnnotation(Class<?> var0, int var1, Class<A> var2);

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        if (annotationType == null) {
            throw new NullPointerException("annotationType == null");
        }
        return Field.isAnnotationPresent(this.declaringClass, this.slot, annotationType);
    }

    private static native boolean isAnnotationPresent(Class<?> var0, int var1, Class<? extends Annotation> var2);

    public boolean equals(Object object) {
        return object instanceof Field && this.toString().equals(object.toString());
    }

    public Object get(Object object) throws IllegalAccessException, IllegalArgumentException {
        return this.getField(object, this.declaringClass, this.type, this.slot, this.flag);
    }

    public boolean getBoolean(Object object) throws IllegalAccessException, IllegalArgumentException {
        return this.getZField(object, this.declaringClass, this.type, this.slot, this.flag, 'Z');
    }

    public byte getByte(Object object) throws IllegalAccessException, IllegalArgumentException {
        return this.getBField(object, this.declaringClass, this.type, this.slot, this.flag, 'B');
    }

    public char getChar(Object object) throws IllegalAccessException, IllegalArgumentException {
        return this.getCField(object, this.declaringClass, this.type, this.slot, this.flag, 'C');
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public double getDouble(Object object) throws IllegalAccessException, IllegalArgumentException {
        return this.getDField(object, this.declaringClass, this.type, this.slot, this.flag, 'D');
    }

    public float getFloat(Object object) throws IllegalAccessException, IllegalArgumentException {
        return this.getFField(object, this.declaringClass, this.type, this.slot, this.flag, 'F');
    }

    public int getInt(Object object) throws IllegalAccessException, IllegalArgumentException {
        return this.getIField(object, this.declaringClass, this.type, this.slot, this.flag, 'I');
    }

    public long getLong(Object object) throws IllegalAccessException, IllegalArgumentException {
        return this.getJField(object, this.declaringClass, this.type, this.slot, this.flag, 'J');
    }

    @Override
    public int getModifiers() {
        return this.getFieldModifiers(this.declaringClass, this.slot);
    }

    private native int getFieldModifiers(Class<?> var1, int var2);

    @Override
    public String getName() {
        return this.name;
    }

    public short getShort(Object object) throws IllegalAccessException, IllegalArgumentException {
        return this.getSField(object, this.declaringClass, this.type, this.slot, this.flag, 'S');
    }

    private String getSignature() {
        return this.getSignature(this.type);
    }

    public Class<?> getType() {
        return this.type;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.getDeclaringClass().getName().hashCode();
    }

    public void set(Object object, Object value) throws IllegalAccessException, IllegalArgumentException {
        this.setField(object, this.declaringClass, this.type, this.slot, this.flag, value);
    }

    public void setBoolean(Object object, boolean value) throws IllegalAccessException, IllegalArgumentException {
        this.setZField(object, this.declaringClass, this.type, this.slot, this.flag, 'Z', value);
    }

    public void setByte(Object object, byte value) throws IllegalAccessException, IllegalArgumentException {
        this.setBField(object, this.declaringClass, this.type, this.slot, this.flag, 'B', value);
    }

    public void setChar(Object object, char value) throws IllegalAccessException, IllegalArgumentException {
        this.setCField(object, this.declaringClass, this.type, this.slot, this.flag, 'C', value);
    }

    public void setDouble(Object object, double value) throws IllegalAccessException, IllegalArgumentException {
        this.setDField(object, this.declaringClass, this.type, this.slot, this.flag, 'D', value);
    }

    public void setFloat(Object object, float value) throws IllegalAccessException, IllegalArgumentException {
        this.setFField(object, this.declaringClass, this.type, this.slot, this.flag, 'F', value);
    }

    public void setInt(Object object, int value) throws IllegalAccessException, IllegalArgumentException {
        this.setIField(object, this.declaringClass, this.type, this.slot, this.flag, 'I', value);
    }

    public void setLong(Object object, long value) throws IllegalAccessException, IllegalArgumentException {
        this.setJField(object, this.declaringClass, this.type, this.slot, this.flag, 'J', value);
    }

    public void setShort(Object object, short value) throws IllegalAccessException, IllegalArgumentException {
        this.setSField(object, this.declaringClass, this.type, this.slot, this.flag, 'S', value);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(Modifier.toString(this.getModifiers()));
        if (result.length() != 0) {
            result.append(' ');
        }
        this.appendArrayType(result, this.type);
        result.append(' ');
        result.append(this.declaringClass.getName());
        result.append('.');
        result.append(this.name);
        return result.toString();
    }

    private native Object getField(Object var1, Class<?> var2, Class<?> var3, int var4, boolean var5) throws IllegalAccessException;

    private native double getDField(Object var1, Class<?> var2, Class<?> var3, int var4, boolean var5, char var6) throws IllegalAccessException;

    private native int getIField(Object var1, Class<?> var2, Class<?> var3, int var4, boolean var5, char var6) throws IllegalAccessException;

    private native long getJField(Object var1, Class<?> var2, Class<?> var3, int var4, boolean var5, char var6) throws IllegalAccessException;

    private native boolean getZField(Object var1, Class<?> var2, Class<?> var3, int var4, boolean var5, char var6) throws IllegalAccessException;

    private native float getFField(Object var1, Class<?> var2, Class<?> var3, int var4, boolean var5, char var6) throws IllegalAccessException;

    private native char getCField(Object var1, Class<?> var2, Class<?> var3, int var4, boolean var5, char var6) throws IllegalAccessException;

    private native short getSField(Object var1, Class<?> var2, Class<?> var3, int var4, boolean var5, char var6) throws IllegalAccessException;

    private native byte getBField(Object var1, Class<?> var2, Class<?> var3, int var4, boolean var5, char var6) throws IllegalAccessException;

    private native void setField(Object var1, Class<?> var2, Class<?> var3, int var4, boolean var5, Object var6) throws IllegalAccessException;

    private native void setDField(Object var1, Class<?> var2, Class<?> var3, int var4, boolean var5, char var6, double var7) throws IllegalAccessException;

    private native void setIField(Object var1, Class<?> var2, Class<?> var3, int var4, boolean var5, char var6, int var7) throws IllegalAccessException;

    private native void setJField(Object var1, Class<?> var2, Class<?> var3, int var4, boolean var5, char var6, long var7) throws IllegalAccessException;

    private native void setZField(Object var1, Class<?> var2, Class<?> var3, int var4, boolean var5, char var6, boolean var7) throws IllegalAccessException;

    private native void setFField(Object var1, Class<?> var2, Class<?> var3, int var4, boolean var5, char var6, float var7) throws IllegalAccessException;

    private native void setCField(Object var1, Class<?> var2, Class<?> var3, int var4, boolean var5, char var6, char var7) throws IllegalAccessException;

    private native void setSField(Object var1, Class<?> var2, Class<?> var3, int var4, boolean var5, char var6, short var7) throws IllegalAccessException;

    private native void setBField(Object var1, Class<?> var2, Class<?> var3, int var4, boolean var5, char var6, byte var7) throws IllegalAccessException;
}

