/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.math.NativeBN;

final class BigInt {
    transient int bignum = 0;

    BigInt() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.bignum != 0) {
                NativeBN.BN_free(this.bignum);
                this.bignum = 0;
            }
        }
        finally {
            super.finalize();
        }
    }

    public String toString() {
        return this.decString();
    }

    int getNativeBIGNUM() {
        return this.bignum;
    }

    static int consumeErrors(StringBuilder sb) {
        int e;
        int cnt = 0;
        while ((e = NativeBN.ERR_get_error()) != 0) {
            int reason = e & 0xFF;
            if (reason == 103) {
                throw new ArithmeticException("BigInteger division by zero");
            }
            if (reason == 108) {
                throw new ArithmeticException("BigInteger not invertible");
            }
            if (reason == 65) {
                throw new OutOfMemoryError();
            }
            sb.append(e).append(": ");
            String s = NativeBN.ERR_error_string(e);
            sb.append(s);
            ++cnt;
        }
        return cnt;
    }

    private static void Check(boolean success) {
        StringBuilder sb;
        int cnt;
        if (!success && (cnt = BigInt.consumeErrors(sb = new StringBuilder("(openssl)ERR: "))) > 0) {
            throw new ArithmeticException(sb.toString());
        }
    }

    private void makeValid() {
        if (this.bignum == 0) {
            this.bignum = NativeBN.BN_new();
            BigInt.Check(this.bignum != 0);
        }
    }

    private static BigInt newBigInt() {
        BigInt bi = new BigInt();
        bi.bignum = NativeBN.BN_new();
        BigInt.Check(bi.bignum != 0);
        return bi;
    }

    static int cmp(BigInt a, BigInt b) {
        return NativeBN.BN_cmp(a.bignum, b.bignum);
    }

    void putCopy(BigInt from) {
        this.makeValid();
        BigInt.Check(NativeBN.BN_copy(this.bignum, from.bignum));
    }

    BigInt copy() {
        BigInt bi = new BigInt();
        bi.putCopy(this);
        return bi;
    }

    void putLongInt(long val) {
        this.makeValid();
        BigInt.Check(NativeBN.putLongInt(this.bignum, val));
    }

    void putULongInt(long val, boolean neg) {
        this.makeValid();
        BigInt.Check(NativeBN.putULongInt(this.bignum, val, neg));
    }

    private NumberFormatException invalidBigInteger(String s) {
        throw new NumberFormatException("Invalid BigInteger: " + s);
    }

    void putDecString(String original) {
        String s = this.checkString(original, 10);
        this.makeValid();
        int usedLen = NativeBN.BN_dec2bn(this.bignum, s);
        BigInt.Check(usedLen > 0);
        if (usedLen < s.length()) {
            throw this.invalidBigInteger(original);
        }
    }

    void putHexString(String original) {
        String s = this.checkString(original, 16);
        this.makeValid();
        int usedLen = NativeBN.BN_hex2bn(this.bignum, s);
        BigInt.Check(usedLen > 0);
        if (usedLen < s.length()) {
            throw this.invalidBigInteger(original);
        }
    }

    String checkString(String s, int base) {
        if (s == null) {
            throw new NullPointerException();
        }
        int charCount = s.length();
        int i = 0;
        if (charCount > 0) {
            char ch = s.charAt(0);
            if (ch == '+') {
                s = s.substring(1);
                --charCount;
            } else if (ch == '-') {
                ++i;
            }
        }
        if (charCount - i == 0) {
            throw this.invalidBigInteger(s);
        }
        boolean nonAscii = false;
        while (i < charCount) {
            char ch = s.charAt(i);
            if (Character.digit(ch, base) == -1) {
                throw this.invalidBigInteger(s);
            }
            if (ch > '\u0080') {
                nonAscii = true;
            }
            ++i;
        }
        return nonAscii ? BigInt.toAscii(s, base) : s;
    }

    private static String toAscii(String s, int base) {
        int length = s.length();
        StringBuilder result = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char ch = s.charAt(i);
            int value = Character.digit(ch, base);
            if (value >= 0 && value <= 9) {
                ch = (char)(48 + value);
            }
            result.append(ch);
        }
        return result.toString();
    }

    void putBigEndian(byte[] a, boolean neg) {
        this.makeValid();
        BigInt.Check(NativeBN.BN_bin2bn(a, a.length, neg, this.bignum));
    }

    void putLittleEndianInts(int[] a, boolean neg) {
        this.makeValid();
        BigInt.Check(NativeBN.litEndInts2bn(a, a.length, neg, this.bignum));
    }

    void putBigEndianTwosComplement(byte[] a) {
        this.makeValid();
        BigInt.Check(NativeBN.twosComp2bn(a, a.length, this.bignum));
    }

    long longInt() {
        return NativeBN.longInt(this.bignum);
    }

    String decString() {
        return NativeBN.BN_bn2dec(this.bignum);
    }

    String hexString() {
        return NativeBN.BN_bn2hex(this.bignum);
    }

    byte[] bigEndianMagnitude() {
        return NativeBN.BN_bn2bin(this.bignum);
    }

    int[] littleEndianIntsMagnitude() {
        return NativeBN.bn2litEndInts(this.bignum);
    }

    int sign() {
        return NativeBN.sign(this.bignum);
    }

    void setSign(int val) {
        if (val > 0) {
            NativeBN.BN_set_negative(this.bignum, 0);
        } else if (val < 0) {
            NativeBN.BN_set_negative(this.bignum, 1);
        }
    }

    boolean twosCompFitsIntoBytes(int desiredByteCount) {
        int actualByteCount = (NativeBN.bitLength(this.bignum) + 7) / 8;
        return actualByteCount <= desiredByteCount;
    }

    int bitLength() {
        return NativeBN.bitLength(this.bignum);
    }

    boolean isBitSet(int n) {
        return NativeBN.BN_is_bit_set(this.bignum, n);
    }

    static BigInt shift(BigInt a, int n) {
        BigInt r = BigInt.newBigInt();
        BigInt.Check(NativeBN.BN_shift(r.bignum, a.bignum, n));
        return r;
    }

    void shift(int n) {
        BigInt.Check(NativeBN.BN_shift(this.bignum, this.bignum, n));
    }

    void addPositiveInt(int w) {
        BigInt.Check(NativeBN.BN_add_word(this.bignum, w));
    }

    void multiplyByPositiveInt(int w) {
        BigInt.Check(NativeBN.BN_mul_word(this.bignum, w));
    }

    static int remainderByPositiveInt(BigInt a, int w) {
        int rem = NativeBN.BN_mod_word(a.bignum, w);
        BigInt.Check(rem != -1);
        return rem;
    }

    static BigInt addition(BigInt a, BigInt b) {
        BigInt r = BigInt.newBigInt();
        BigInt.Check(NativeBN.BN_add(r.bignum, a.bignum, b.bignum));
        return r;
    }

    void add(BigInt a) {
        BigInt.Check(NativeBN.BN_add(this.bignum, this.bignum, a.bignum));
    }

    static BigInt subtraction(BigInt a, BigInt b) {
        BigInt r = BigInt.newBigInt();
        BigInt.Check(NativeBN.BN_sub(r.bignum, a.bignum, b.bignum));
        return r;
    }

    static BigInt gcd(BigInt a, BigInt b) {
        BigInt r = BigInt.newBigInt();
        BigInt.Check(NativeBN.BN_gcd(r.bignum, a.bignum, b.bignum));
        return r;
    }

    static BigInt product(BigInt a, BigInt b) {
        BigInt r = BigInt.newBigInt();
        BigInt.Check(NativeBN.BN_mul(r.bignum, a.bignum, b.bignum));
        return r;
    }

    static BigInt bigExp(BigInt a, BigInt p) {
        BigInt r = BigInt.newBigInt();
        BigInt.Check(NativeBN.BN_exp(r.bignum, a.bignum, p.bignum));
        return r;
    }

    static BigInt exp(BigInt a, int p) {
        BigInt power = new BigInt();
        power.putLongInt(p);
        return BigInt.bigExp(a, power);
    }

    static void division(BigInt dividend, BigInt divisor, BigInt quotient, BigInt remainder) {
        int rem;
        int quot;
        if (quotient != null) {
            quotient.makeValid();
            quot = quotient.bignum;
        } else {
            quot = 0;
        }
        if (remainder != null) {
            remainder.makeValid();
            rem = remainder.bignum;
        } else {
            rem = 0;
        }
        BigInt.Check(NativeBN.BN_div(quot, rem, dividend.bignum, divisor.bignum));
    }

    static BigInt modulus(BigInt a, BigInt m) {
        BigInt r = BigInt.newBigInt();
        BigInt.Check(NativeBN.BN_nnmod(r.bignum, a.bignum, m.bignum));
        return r;
    }

    static BigInt modExp(BigInt a, BigInt p, BigInt m) {
        BigInt r = BigInt.newBigInt();
        BigInt.Check(NativeBN.BN_mod_exp(r.bignum, a.bignum, p.bignum, m.bignum));
        return r;
    }

    static BigInt modInverse(BigInt a, BigInt m) {
        BigInt r = BigInt.newBigInt();
        BigInt.Check(NativeBN.BN_mod_inverse(r.bignum, a.bignum, m.bignum));
        return r;
    }

    static BigInt generatePrimeDefault(int bitLength) {
        BigInt r = BigInt.newBigInt();
        BigInt.Check(NativeBN.BN_generate_prime_ex(r.bignum, bitLength, false, 0, 0, 0));
        return r;
    }

    boolean isPrime(int certainty) {
        return NativeBN.BN_is_prime_ex(this.bignum, certainty, 0);
    }
}

