/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import libcore.util.BasicLruCache;

class AddressCache {
    private static final int MAX_ENTRIES = 512;
    private static final long DEFAULT_POSITIVE_TTL_NANOS = 600000000000L;
    private static final long DEFAULT_NEGATIVE_TTL_NANOS = 10000000000L;
    private final BasicLruCache<String, AddressCacheEntry> cache = new BasicLruCache(512);

    AddressCache() {
    }

    public void clear() {
        this.cache.evictAll();
    }

    public Object get(String hostname) {
        AddressCacheEntry entry = this.cache.get(hostname);
        if (entry != null && entry.expiryNanos >= System.nanoTime()) {
            return entry.value;
        }
        return null;
    }

    public void put(String hostname, InetAddress[] addresses) {
        this.put(hostname, addresses, true);
    }

    public void put(String hostname, String detailMessage) {
        this.put(hostname, detailMessage, false);
    }

    public void put(String hostname, Object value, boolean isPositive) {
        String propertyName = isPositive ? "networkaddress.cache.ttl" : "networkaddress.cache.negative.ttl";
        long defaultTtlNanos = isPositive ? 600000000000L : 10000000000L;
        long expiryNanos = System.nanoTime() + defaultTtlNanos;
        this.cache.put(hostname, new AddressCacheEntry(value, expiryNanos));
    }

    public void putUnknownHost(String hostname, String detailMessage) {
        this.put(hostname, detailMessage);
    }

    private long customTtl(String propertyName, long defaultTtlNanos) {
        String ttlString = System.getProperty(propertyName, null);
        if (ttlString == null) {
            return System.nanoTime() + defaultTtlNanos;
        }
        try {
            long ttlS = Long.parseLong(ttlString);
            if (ttlS == -1L) {
                return Long.MAX_VALUE;
            }
            if (ttlS == 0L) {
                return Long.MIN_VALUE;
            }
            return System.nanoTime() + ttlS * 1000000000L;
        }
        catch (NumberFormatException ex) {
            return System.nanoTime() + defaultTtlNanos;
        }
    }

    static class AddressCacheEntry {
        final Object value;
        final long expiryNanos;

        AddressCacheEntry(Object value, long expiryNanos) {
            this.value = value;
            this.expiryNanos = expiryNanos;
        }
    }
}

