/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.net.NetPermission;
import java.net.PasswordAuthentication;
import java.net.URL;

public abstract class Authenticator {
    private static Authenticator thisAuthenticator;
    private static final NetPermission requestPasswordAuthenticationPermission;
    private static final NetPermission setDefaultAuthenticatorPermission;
    private String host;
    private InetAddress addr;
    private int port;
    private String protocol;
    private String prompt;
    private String scheme;
    private URL url;
    private RequestorType rt;

    protected PasswordAuthentication getPasswordAuthentication() {
        return null;
    }

    protected final int getRequestingPort() {
        return this.port;
    }

    protected final InetAddress getRequestingSite() {
        return this.addr;
    }

    protected final String getRequestingPrompt() {
        return this.prompt;
    }

    protected final String getRequestingProtocol() {
        return this.protocol;
    }

    protected final String getRequestingScheme() {
        return this.scheme;
    }

    public static synchronized PasswordAuthentication requestPasswordAuthentication(InetAddress rAddr, int rPort, String rProtocol, String rPrompt, String rScheme) {
        if (thisAuthenticator == null) {
            return null;
        }
        Authenticator.thisAuthenticator.addr = rAddr;
        Authenticator.thisAuthenticator.port = rPort;
        Authenticator.thisAuthenticator.protocol = rProtocol;
        Authenticator.thisAuthenticator.prompt = rPrompt;
        Authenticator.thisAuthenticator.scheme = rScheme;
        Authenticator.thisAuthenticator.rt = RequestorType.SERVER;
        return thisAuthenticator.getPasswordAuthentication();
    }

    public static void setDefault(Authenticator a) {
        thisAuthenticator = a;
    }

    public static synchronized PasswordAuthentication requestPasswordAuthentication(String rHost, InetAddress rAddr, int rPort, String rProtocol, String rPrompt, String rScheme) {
        if (thisAuthenticator == null) {
            return null;
        }
        Authenticator.thisAuthenticator.host = rHost;
        Authenticator.thisAuthenticator.addr = rAddr;
        Authenticator.thisAuthenticator.port = rPort;
        Authenticator.thisAuthenticator.protocol = rProtocol;
        Authenticator.thisAuthenticator.prompt = rPrompt;
        Authenticator.thisAuthenticator.scheme = rScheme;
        Authenticator.thisAuthenticator.rt = RequestorType.SERVER;
        return thisAuthenticator.getPasswordAuthentication();
    }

    protected final String getRequestingHost() {
        return this.host;
    }

    public static PasswordAuthentication requestPasswordAuthentication(String rHost, InetAddress rAddr, int rPort, String rProtocol, String rPrompt, String rScheme, URL rURL, RequestorType reqType) {
        if (thisAuthenticator == null) {
            return null;
        }
        Authenticator.thisAuthenticator.host = rHost;
        Authenticator.thisAuthenticator.addr = rAddr;
        Authenticator.thisAuthenticator.port = rPort;
        Authenticator.thisAuthenticator.protocol = rProtocol;
        Authenticator.thisAuthenticator.prompt = rPrompt;
        Authenticator.thisAuthenticator.scheme = rScheme;
        Authenticator.thisAuthenticator.url = rURL;
        Authenticator.thisAuthenticator.rt = reqType;
        return thisAuthenticator.getPasswordAuthentication();
    }

    protected URL getRequestingURL() {
        return this.url;
    }

    protected RequestorType getRequestorType() {
        return this.rt;
    }

    static {
        requestPasswordAuthenticationPermission = new NetPermission("requestPasswordAuthentication");
        setDefaultAuthenticatorPermission = new NetPermission("setDefaultAuthenticator");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RequestorType {
        PROXY,
        SERVER;

    }
}

