/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;

public final class DatagramPacket {
    byte[] data;
    int length;
    int capacity;
    InetAddress address;
    int port = -1;
    int offset = 0;

    public DatagramPacket(byte[] data, int length) {
        this(data, 0, length);
    }

    public DatagramPacket(byte[] data, int offset, int length) {
        this.setData(data, offset, length);
    }

    public DatagramPacket(byte[] data, int offset, int length, InetAddress host, int aPort) {
        this(data, offset, length);
        this.setPort(aPort);
        this.address = host;
    }

    public DatagramPacket(byte[] data, int length, InetAddress host, int port) {
        this(data, 0, length, host, port);
    }

    public synchronized InetAddress getAddress() {
        return this.address;
    }

    public synchronized byte[] getData() {
        return this.data;
    }

    public synchronized int getLength() {
        return this.length;
    }

    public synchronized int getOffset() {
        return this.offset;
    }

    public synchronized int getPort() {
        return this.port;
    }

    public synchronized void setAddress(InetAddress addr) {
        this.address = addr;
    }

    public synchronized void setData(byte[] data, int offset, int byteCount) {
        if ((offset | byteCount) < 0 || offset > data.length || byteCount > data.length - offset) {
            throw new IllegalArgumentException();
        }
        this.data = data;
        this.offset = offset;
        this.length = byteCount;
        this.capacity = byteCount;
    }

    public synchronized void setData(byte[] buf) {
        this.length = buf.length;
        this.capacity = buf.length;
        this.data = buf;
        this.offset = 0;
    }

    synchronized int getCapacity() {
        return this.capacity;
    }

    public synchronized void setLength(int length) {
        this.setLengthOnly(length);
        this.capacity = length;
    }

    synchronized void setLengthOnly(int length) {
        if (length < 0 || this.offset + length > this.data.length) {
            throw new IndexOutOfBoundsException("length=" + length + ", offset=" + this.offset + ", buffer size=" + this.data.length);
        }
        this.length = length;
    }

    public synchronized void setPort(int aPort) {
        if (aPort < 0 || aPort > 65535) {
            throw new IllegalArgumentException("Port out of range: " + aPort);
        }
        this.port = aPort;
    }

    public DatagramPacket(byte[] data, int length, SocketAddress sockAddr) throws SocketException {
        this(data, 0, length);
        this.setSocketAddress(sockAddr);
    }

    public DatagramPacket(byte[] data, int offset, int length, SocketAddress sockAddr) throws SocketException {
        this(data, offset, length);
        this.setSocketAddress(sockAddr);
    }

    public synchronized SocketAddress getSocketAddress() {
        return new InetSocketAddress(this.getAddress(), this.getPort());
    }

    public synchronized void setSocketAddress(SocketAddress sockAddr) {
        if (!(sockAddr instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Socket address not an InetSocketAddress: " + (sockAddr == null ? null : sockAddr.getClass()));
        }
        InetSocketAddress inetAddr = (InetSocketAddress)sockAddr;
        if (inetAddr.isUnresolved()) {
            throw new IllegalArgumentException("Socket address unresolved: " + sockAddr);
        }
        this.port = inetAddr.getPort();
        this.address = inetAddr.getAddress();
    }
}

