/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.ObjectStreamException;
import java.net.InetAddress;
import java.nio.ByteOrder;
import libcore.io.Memory;
import libcore.io.OsConstants;

public final class Inet4Address
extends InetAddress {
    private static final long serialVersionUID = 3286316764910316507L;
    public static final InetAddress ANY = new Inet4Address(new byte[]{0, 0, 0, 0}, null);
    public static final InetAddress ALL = new Inet4Address(new byte[]{-1, -1, -1, -1}, null);
    public static final InetAddress LOOPBACK = new Inet4Address(new byte[]{127, 0, 0, 1}, "localhost");

    Inet4Address(byte[] ipaddress, String hostName) {
        super(OsConstants.AF_INET, ipaddress, hostName);
    }

    public boolean isAnyLocalAddress() {
        return this.ipaddress[0] == 0 && this.ipaddress[1] == 0 && this.ipaddress[2] == 0 && this.ipaddress[3] == 0;
    }

    public boolean isLinkLocalAddress() {
        return (this.ipaddress[0] & 0xFF) == 169 && (this.ipaddress[1] & 0xFF) == 254;
    }

    public boolean isLoopbackAddress() {
        return (this.ipaddress[0] & 0xFF) == 127;
    }

    public boolean isMCGlobal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        int address = Memory.peekInt(this.ipaddress, 0, ByteOrder.BIG_ENDIAN);
        if (address >>> 8 < 0xE00001) {
            return false;
        }
        return address >>> 24 <= 238;
    }

    public boolean isMCLinkLocal() {
        return (this.ipaddress[0] & 0xFF) == 224 && this.ipaddress[1] == 0 && this.ipaddress[2] == 0;
    }

    public boolean isMCNodeLocal() {
        return false;
    }

    public boolean isMCOrgLocal() {
        return (this.ipaddress[0] & 0xFF) == 239 && (this.ipaddress[1] & 0xFC) == 192;
    }

    public boolean isMCSiteLocal() {
        return (this.ipaddress[0] & 0xFF) == 239 && (this.ipaddress[1] & 0xFF) == 255;
    }

    public boolean isMulticastAddress() {
        return (this.ipaddress[0] & 0xF0) == 224;
    }

    public boolean isSiteLocalAddress() {
        if ((this.ipaddress[0] & 0xFF) == 10) {
            return true;
        }
        if ((this.ipaddress[0] & 0xFF) == 172 && (this.ipaddress[1] & 0xF0) == 16) {
            return true;
        }
        return (this.ipaddress[0] & 0xFF) == 192 && (this.ipaddress[1] & 0xFF) == 168;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new Inet4Address(this.ipaddress, this.hostName);
    }
}

