/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.PlainDatagramSocketImpl;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.Enumeration;

public class MulticastSocket
extends DatagramSocket {
    private InetAddress setAddress;

    public MulticastSocket() throws IOException {
        this.setReuseAddress(true);
    }

    public MulticastSocket(int port) throws IOException {
        super(port);
        this.setReuseAddress(true);
    }

    public MulticastSocket(SocketAddress localAddress) throws IOException {
        super(localAddress);
        this.setReuseAddress(true);
    }

    public InetAddress getInterface() throws SocketException {
        Enumeration<InetAddress> addresses;
        NetworkInterface theInterface;
        this.checkOpen();
        if (this.setAddress != null) {
            return this.setAddress;
        }
        InetAddress ipvXaddress = (InetAddress)this.impl.getOption(16);
        if (ipvXaddress.isAnyLocalAddress() && (theInterface = this.getNetworkInterface()) != null && (addresses = theInterface.getInetAddresses()) != null) {
            while (addresses.hasMoreElements()) {
                InetAddress nextAddress = addresses.nextElement();
                if (!(nextAddress instanceof Inet6Address)) continue;
                return nextAddress;
            }
        }
        return ipvXaddress;
    }

    public NetworkInterface getNetworkInterface() throws SocketException {
        this.checkOpen();
        int index = (Integer)this.impl.getOption(31);
        if (index != 0) {
            return NetworkInterface.getByIndex(index);
        }
        return NetworkInterface.forUnboundMulticastSocket();
    }

    public int getTimeToLive() throws IOException {
        this.checkOpen();
        return this.impl.getTimeToLive();
    }

    @Deprecated
    public byte getTTL() throws IOException {
        this.checkOpen();
        return this.impl.getTTL();
    }

    public void joinGroup(InetAddress groupAddr) throws IOException {
        this.checkJoinOrLeave(groupAddr);
        this.impl.join(groupAddr);
    }

    public void joinGroup(SocketAddress groupAddress, NetworkInterface netInterface) throws IOException {
        this.checkJoinOrLeave(groupAddress, netInterface);
        this.impl.joinGroup(groupAddress, netInterface);
    }

    public void leaveGroup(InetAddress groupAddr) throws IOException {
        this.checkJoinOrLeave(groupAddr);
        this.impl.leave(groupAddr);
    }

    public void leaveGroup(SocketAddress groupAddress, NetworkInterface netInterface) throws IOException {
        this.checkJoinOrLeave(groupAddress, netInterface);
        this.impl.leaveGroup(groupAddress, netInterface);
    }

    private void checkJoinOrLeave(SocketAddress groupAddress, NetworkInterface netInterface) throws IOException {
        this.checkOpen();
        if (groupAddress == null) {
            throw new IllegalArgumentException("groupAddress == null");
        }
        if (netInterface != null && !netInterface.getInetAddresses().hasMoreElements()) {
            throw new SocketException("No address associated with interface: " + netInterface);
        }
        if (!(groupAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Group address not an InetSocketAddress: " + groupAddress.getClass());
        }
        InetAddress groupAddr = ((InetSocketAddress)groupAddress).getAddress();
        if (groupAddr == null) {
            throw new SocketException("Group address has no address: " + groupAddress);
        }
        if (!groupAddr.isMulticastAddress()) {
            throw new IOException("Not a multicast group: " + groupAddr);
        }
    }

    private void checkJoinOrLeave(InetAddress groupAddr) throws IOException {
        this.checkOpen();
        if (!groupAddr.isMulticastAddress()) {
            throw new IOException("Not a multicast group: " + groupAddr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void send(DatagramPacket packet, byte ttl) throws IOException {
        this.checkOpen();
        InetAddress packAddr = packet.getAddress();
        int currTTL = this.getTimeToLive();
        if (packAddr.isMulticastAddress() && (byte)currTTL != ttl) {
            try {
                this.setTimeToLive(ttl & 0xFF);
                this.impl.send(packet);
            }
            finally {
                this.setTimeToLive(currTTL);
            }
        } else {
            this.impl.send(packet);
        }
    }

    public void setInterface(InetAddress address) throws SocketException {
        this.checkOpen();
        if (address == null) {
            throw new NullPointerException("address == null");
        }
        NetworkInterface networkInterface = NetworkInterface.getByInetAddress(address);
        if (networkInterface == null) {
            throw new SocketException("Address not associated with an interface: " + address);
        }
        this.impl.setOption(31, networkInterface.getIndex());
        this.setAddress = address;
    }

    public void setNetworkInterface(NetworkInterface networkInterface) throws SocketException {
        this.checkOpen();
        if (networkInterface == null) {
            throw new SocketException("networkInterface == null");
        }
        this.impl.setOption(31, networkInterface.getIndex());
        this.setAddress = null;
    }

    public void setTimeToLive(int ttl) throws IOException {
        this.checkOpen();
        if (ttl < 0 || ttl > 255) {
            throw new IllegalArgumentException("TimeToLive out of bounds: " + ttl);
        }
        this.impl.setTimeToLive(ttl);
    }

    @Deprecated
    public void setTTL(byte ttl) throws IOException {
        this.checkOpen();
        this.impl.setTTL(ttl);
    }

    synchronized void createSocket(int aPort, InetAddress addr) throws SocketException {
        this.impl = factory != null ? factory.createDatagramSocketImpl() : new PlainDatagramSocketImpl();
        this.impl.create();
        try {
            this.impl.setOption(4, Boolean.TRUE);
            this.impl.bind(aPort, addr);
            this.isBound = true;
        }
        catch (SocketException e) {
            this.close();
            throw e;
        }
    }

    public boolean getLoopbackMode() throws SocketException {
        this.checkOpen();
        return (Boolean)this.impl.getOption(18) == false;
    }

    public void setLoopbackMode(boolean disable) throws SocketException {
        this.checkOpen();
        this.impl.setOption(18, !disable);
    }
}

