/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileReader;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import libcore.io.ErrnoException;
import libcore.io.IoUtils;
import libcore.io.Libcore;
import libcore.io.OsConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NetworkInterface {
    private final String name;
    private final int interfaceIndex;
    private final List<InterfaceAddress> interfaceAddresses;
    private final List<InetAddress> addresses;
    private final List<NetworkInterface> children = new LinkedList<NetworkInterface>();
    private NetworkInterface parent = null;

    private NetworkInterface(String name, int interfaceIndex, List<InetAddress> addresses, List<InterfaceAddress> interfaceAddresses) {
        this.name = name;
        this.interfaceIndex = interfaceIndex;
        this.addresses = addresses;
        this.interfaceAddresses = interfaceAddresses;
    }

    static NetworkInterface forUnboundMulticastSocket() {
        return new NetworkInterface(null, -1, Arrays.asList(Inet6Address.ANY), Collections.<InterfaceAddress>emptyList());
    }

    public int getIndex() {
        return this.interfaceIndex;
    }

    public String getName() {
        return this.name;
    }

    public Enumeration<InetAddress> getInetAddresses() {
        return Collections.enumeration(this.addresses);
    }

    public String getDisplayName() {
        return this.name;
    }

    public static NetworkInterface getByName(String interfaceName) throws SocketException {
        if (interfaceName == null) {
            throw new NullPointerException("interfaceName == null");
        }
        if (!NetworkInterface.isValidInterfaceName(interfaceName)) {
            return null;
        }
        int interfaceIndex = NetworkInterface.readIntFile("/sys/class/net/" + interfaceName + "/ifindex");
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        ArrayList<InterfaceAddress> interfaceAddresses = new ArrayList<InterfaceAddress>();
        NetworkInterface.collectIpv6Addresses(interfaceName, interfaceIndex, addresses, interfaceAddresses);
        NetworkInterface.collectIpv4Address(interfaceName, addresses, interfaceAddresses);
        return new NetworkInterface(interfaceName, interfaceIndex, addresses, interfaceAddresses);
    }

    private static void collectIpv6Addresses(String interfaceName, int interfaceIndex, List<InetAddress> addresses, List<InterfaceAddress> interfaceAddresses) throws SocketException {
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new FileReader("/proc/net/if_inet6"));
            String suffix = " " + interfaceName;
            while ((line = in.readLine()) != null) {
                if (!line.endsWith(suffix)) continue;
                byte[] addressBytes = new byte[16];
                for (int i = 0; i < addressBytes.length; ++i) {
                    addressBytes[i] = (byte)Integer.parseInt(line.substring(2 * i, 2 * i + 2), 16);
                }
                short prefixLength = Short.parseShort(line.substring(36, 38), 16);
                Inet6Address inet6Address = new Inet6Address(addressBytes, null, interfaceIndex);
                addresses.add(inet6Address);
                interfaceAddresses.add(new InterfaceAddress(inet6Address, prefixLength));
            }
        }
        catch (Exception ex) {
            try {
                throw NetworkInterface.rethrowAsSocketException(ex);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(in);
    }

    /*
     * Loose catch block
     */
    private static void collectIpv4Address(String interfaceName, List<InetAddress> addresses, List<InterfaceAddress> interfaceAddresses) throws SocketException {
        FileDescriptor fd = null;
        try {
            fd = Libcore.os.socket(OsConstants.AF_INET, OsConstants.SOCK_DGRAM, 0);
            InetAddress address = Libcore.os.ioctlInetAddress(fd, OsConstants.SIOCGIFADDR, interfaceName);
            InetAddress broadcast = Libcore.os.ioctlInetAddress(fd, OsConstants.SIOCGIFBRDADDR, interfaceName);
            InetAddress netmask = Libcore.os.ioctlInetAddress(fd, OsConstants.SIOCGIFNETMASK, interfaceName);
            if (broadcast.equals(Inet4Address.ANY)) {
                broadcast = null;
            }
            addresses.add(address);
            interfaceAddresses.add(new InterfaceAddress((Inet4Address)address, (Inet4Address)broadcast, (Inet4Address)netmask));
        }
        catch (ErrnoException errnoException) {
            block7: {
                if (errnoException.errno == OsConstants.EADDRNOTAVAIL) break block7;
                throw NetworkInterface.rethrowAsSocketException(errnoException);
            }
            IoUtils.closeQuietly(fd);
        }
        catch (Exception ex) {
            throw NetworkInterface.rethrowAsSocketException(ex);
            {
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(fd);
                    throw throwable;
                }
            }
        }
        IoUtils.closeQuietly(fd);
    }

    @FindBugsSuppressWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    private static boolean isValidInterfaceName(String interfaceName) {
        for (String validName : new File("/sys/class/net").list()) {
            if (!interfaceName.equals(validName)) continue;
            return true;
        }
        return false;
    }

    private static int readIntFile(String path) throws SocketException {
        try {
            String s = IoUtils.readFileAsString(path).trim();
            if (s.startsWith("0x")) {
                return Integer.parseInt(s.substring(2), 16);
            }
            return Integer.parseInt(s);
        }
        catch (Exception ex) {
            throw NetworkInterface.rethrowAsSocketException(ex);
        }
    }

    private static SocketException rethrowAsSocketException(Exception ex) throws SocketException {
        SocketException result = new SocketException();
        result.initCause(ex);
        throw result;
    }

    public static NetworkInterface getByInetAddress(InetAddress address) throws SocketException {
        if (address == null) {
            throw new NullPointerException("address == null");
        }
        for (NetworkInterface networkInterface : NetworkInterface.getNetworkInterfacesList()) {
            if (!networkInterface.addresses.contains(address)) continue;
            return networkInterface;
        }
        return null;
    }

    public static NetworkInterface getByIndex(int index) throws SocketException {
        String name = Libcore.os.if_indextoname(index);
        if (name == null) {
            return null;
        }
        return NetworkInterface.getByName(name);
    }

    public static Enumeration<NetworkInterface> getNetworkInterfaces() throws SocketException {
        return Collections.enumeration(NetworkInterface.getNetworkInterfacesList());
    }

    @FindBugsSuppressWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    private static List<NetworkInterface> getNetworkInterfacesList() throws SocketException {
        String[] interfaceNames = new File("/sys/class/net").list();
        NetworkInterface[] interfaces = new NetworkInterface[interfaceNames.length];
        for (int i = 0; i < interfaceNames.length; ++i) {
            interfaces[i] = NetworkInterface.getByName(interfaceNames[i]);
        }
        ArrayList<NetworkInterface> result = new ArrayList<NetworkInterface>();
        boolean[] peeked = new boolean[interfaces.length];
        for (int counter = 0; counter < interfaces.length; ++counter) {
            if (peeked[counter]) continue;
            for (int counter2 = counter; counter2 < interfaces.length; ++counter2) {
                if (peeked[counter2] || !interfaces[counter2].name.startsWith(interfaces[counter].name + ":")) continue;
                peeked[counter2] = true;
                interfaces[counter].children.add(interfaces[counter2]);
                interfaces[counter2].parent = interfaces[counter];
                interfaces[counter].addresses.addAll(interfaces[counter2].addresses);
            }
            result.add(interfaces[counter]);
            peeked[counter] = true;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface rhs = (NetworkInterface)obj;
        return this.interfaceIndex == rhs.interfaceIndex && this.name.equals(rhs.name) && ((Object)this.addresses).equals(rhs.addresses);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(25);
        sb.append("[");
        sb.append(this.name);
        sb.append("][");
        sb.append(this.interfaceIndex);
        sb.append("]");
        for (InetAddress address : this.addresses) {
            sb.append("[");
            sb.append(address.toString());
            sb.append("]");
        }
        return sb.toString();
    }

    public List<InterfaceAddress> getInterfaceAddresses() {
        return Collections.unmodifiableList(this.interfaceAddresses);
    }

    public Enumeration<NetworkInterface> getSubInterfaces() {
        return Collections.enumeration(this.children);
    }

    public NetworkInterface getParent() {
        return this.parent;
    }

    public boolean isUp() throws SocketException {
        return this.hasFlag(OsConstants.IFF_UP);
    }

    public boolean isLoopback() throws SocketException {
        return this.hasFlag(OsConstants.IFF_LOOPBACK);
    }

    public boolean isPointToPoint() throws SocketException {
        return this.hasFlag(OsConstants.IFF_POINTOPOINT);
    }

    public boolean supportsMulticast() throws SocketException {
        return this.hasFlag(OsConstants.IFF_MULTICAST);
    }

    private boolean hasFlag(int mask) throws SocketException {
        int flags = NetworkInterface.readIntFile("/sys/class/net/" + this.name + "/flags");
        return (flags & mask) != 0;
    }

    public byte[] getHardwareAddress() throws SocketException {
        try {
            int i;
            String s = IoUtils.readFileAsString("/sys/class/net/" + this.name + "/address");
            byte[] result = new byte[s.length() / 3];
            for (i = 0; i < result.length; ++i) {
                result[i] = (byte)Integer.parseInt(s.substring(3 * i, 3 * i + 2), 16);
            }
            for (i = 0; i < result.length; ++i) {
                if (result[i] == 0) continue;
                return result;
            }
            return null;
        }
        catch (Exception ex) {
            throw NetworkInterface.rethrowAsSocketException(ex);
        }
    }

    public int getMTU() throws SocketException {
        return NetworkInterface.readIntFile("/sys/class/net/" + this.name + "/mtu");
    }

    public boolean isVirtual() {
        return this.parent != null;
    }
}

