/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLStreamHandlerFactory;
import java.nio.charset.Charsets;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import libcore.io.IoUtils;
import libcore.io.Streams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FindBugsSuppressWarnings(value={"DMI_COLLECTION_OF_URLS", "DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"})
public class URLClassLoader
extends SecureClassLoader {
    ArrayList<URL> originalUrls;
    List<URL> searchList;
    ArrayList<URLHandler> handlerList;
    Map<URL, URLHandler> handlerMap = new HashMap<URL, URLHandler>();
    private URLStreamHandlerFactory factory;

    public URLClassLoader(URL[] urls) {
        this(urls, ClassLoader.getSystemClassLoader(), null);
    }

    public URLClassLoader(URL[] urls, ClassLoader parent) {
        this(urls, parent, null);
    }

    protected void addURL(URL url) {
        try {
            this.originalUrls.add(url);
            this.searchList.add(this.createSearchURL(url));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        URLHandler handler;
        if (name == null) {
            return null;
        }
        ArrayList<URL> result = new ArrayList<URL>();
        int n = 0;
        while ((handler = this.getHandler(n++)) != null) {
            handler.findResources(name, result);
        }
        return Collections.enumeration(result);
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        PermissionCollection pc = super.getPermissions(codesource);
        URL u = codesource.getLocation();
        if (u.getProtocol().equals("jar")) {
            try {
                u = ((JarURLConnection)u.openConnection()).getJarFileURL();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (u.getProtocol().equals("file")) {
            String path = u.getFile();
            String host = u.getHost();
            if (host != null && host.length() > 0) {
                path = "//" + host + path;
            }
            if (File.separatorChar != '/') {
                path = path.replace('/', File.separatorChar);
            }
            if (URLClassLoader.isDirectory(u)) {
                pc.add(new FilePermission(path + "-", "read"));
            } else {
                pc.add(new FilePermission(path, "read"));
            }
        } else {
            String host = u.getHost();
            if (host.length() == 0) {
                host = "localhost";
            }
            pc.add(new SocketPermission(host, "connect, accept"));
        }
        return pc;
    }

    public URL[] getURLs() {
        return this.originalUrls.toArray(new URL[this.originalUrls.size()]);
    }

    private static boolean isDirectory(URL url) {
        String file = url.getFile();
        return file.length() > 0 && file.charAt(file.length() - 1) == '/';
    }

    public static URLClassLoader newInstance(URL[] urls) {
        return new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
    }

    public static URLClassLoader newInstance(URL[] urls, ClassLoader parentCl) {
        return new URLClassLoader(urls, parentCl);
    }

    public URLClassLoader(URL[] searchUrls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(parent);
        this.factory = factory;
        int nbUrls = searchUrls.length;
        this.originalUrls = new ArrayList(nbUrls);
        this.handlerList = new ArrayList(nbUrls);
        this.searchList = Collections.synchronizedList(new ArrayList(nbUrls));
        for (int i = 0; i < nbUrls; ++i) {
            this.originalUrls.add(searchUrls[i]);
            try {
                this.searchList.add(this.createSearchURL(searchUrls[i]));
                continue;
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        URLHandler handler;
        String partialName = className.replace('.', '/');
        String classFileName = partialName + ".class";
        String packageName = null;
        int position = partialName.lastIndexOf(47);
        position = partialName.lastIndexOf(47);
        if (position != -1) {
            packageName = partialName.substring(0, position);
        }
        int n = 0;
        while ((handler = this.getHandler(n++)) != null) {
            Class<?> res = handler.findClass(packageName, classFileName, className);
            if (res == null) continue;
            return res;
        }
        throw new ClassNotFoundException(className);
    }

    private URL createSearchURL(URL url) throws MalformedURLException {
        if (url == null) {
            return url;
        }
        String protocol = url.getProtocol();
        if (URLClassLoader.isDirectory(url) || protocol.equals("jar")) {
            return url;
        }
        if (this.factory == null) {
            return new URL("jar", "", -1, url.toString() + "!/");
        }
        return new URL("jar", "", -1, url.toString() + "!/", this.factory.createURLStreamHandler("jar"));
    }

    @Override
    public URL findResource(String name) {
        URLHandler handler;
        if (name == null) {
            return null;
        }
        int n = 0;
        while ((handler = this.getHandler(n++)) != null) {
            URL res = handler.findResource(name);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    private URLHandler getHandler(int num) {
        if (num < this.handlerList.size()) {
            return this.handlerList.get(num);
        }
        this.makeNewHandler();
        if (num < this.handlerList.size()) {
            return this.handlerList.get(num);
        }
        return null;
    }

    private synchronized void makeNewHandler() {
        while (!this.searchList.isEmpty()) {
            String protocol;
            URLHandler result;
            URL nextCandidate = this.searchList.remove(0);
            if (nextCandidate == null) {
                throw new NullPointerException("A URL is null");
            }
            if (this.handlerMap.containsKey(nextCandidate) || (result = (protocol = nextCandidate.getProtocol()).equals("jar") ? this.createURLJarHandler(nextCandidate) : (protocol.equals("file") ? this.createURLFileHandler(nextCandidate) : this.createURLHandler(nextCandidate))) == null) continue;
            this.handlerMap.put(nextCandidate, result);
            this.handlerList.add(result);
            return;
        }
    }

    private URLHandler createURLHandler(URL url) {
        return new URLHandler(url);
    }

    private URLHandler createURLFileHandler(URL url) {
        return new URLFileHandler(url);
    }

    private URLHandler createURLJarHandler(URL url) {
        String prefixName;
        String file = url.getFile();
        if (url.getFile().endsWith("!/")) {
            prefixName = "";
        } else {
            int sepIdx = file.lastIndexOf("!/");
            if (sepIdx == -1) {
                return null;
            }
            prefixName = file.substring(sepIdx += 2);
        }
        try {
            URL jarURL = ((JarURLConnection)url.openConnection()).getJarFileURL();
            JarURLConnection juc = (JarURLConnection)new URL("jar", "", jarURL.toExternalForm() + "!/").openConnection();
            JarFile jf = juc.getJarFile();
            URLJarHandler jarH = new URLJarHandler(url, jarURL, jf, prefixName);
            if (jarH.getIndex() == null) {
                try {
                    String classpath;
                    Manifest manifest = jf.getManifest();
                    if (manifest != null && (classpath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH)) != null) {
                        this.searchList.addAll(0, this.getInternalURLs(url, classpath));
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            return jarH;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected Package definePackage(String packageName, Manifest manifest, URL url) throws IllegalArgumentException {
        String implementationVendor;
        String implementationVersion;
        String implementationTitle;
        String specificationVendor;
        String specificationVersion;
        String specificationTitle;
        Attributes mainAttributes = manifest.getMainAttributes();
        String dirName = packageName.replace('.', '/') + "/";
        Attributes packageAttributes = manifest.getAttributes(dirName);
        boolean noEntry = false;
        if (packageAttributes == null) {
            noEntry = true;
            packageAttributes = mainAttributes;
        }
        if ((specificationTitle = packageAttributes.getValue(Attributes.Name.SPECIFICATION_TITLE)) == null && !noEntry) {
            specificationTitle = mainAttributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
        }
        if ((specificationVersion = packageAttributes.getValue(Attributes.Name.SPECIFICATION_VERSION)) == null && !noEntry) {
            specificationVersion = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
        }
        if ((specificationVendor = packageAttributes.getValue(Attributes.Name.SPECIFICATION_VENDOR)) == null && !noEntry) {
            specificationVendor = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
        }
        if ((implementationTitle = packageAttributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE)) == null && !noEntry) {
            implementationTitle = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
        }
        if ((implementationVersion = packageAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION)) == null && !noEntry) {
            implementationVersion = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        }
        if ((implementationVendor = packageAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR)) == null && !noEntry) {
            implementationVendor = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
        }
        return this.definePackage(packageName, specificationTitle, specificationVersion, specificationVendor, implementationTitle, implementationVersion, implementationVendor, this.isSealed(manifest, dirName) ? url : null);
    }

    private boolean isSealed(Manifest manifest, String dirName) {
        String value;
        Attributes attributes = manifest.getAttributes(dirName);
        if (attributes != null && (value = attributes.getValue(Attributes.Name.SEALED)) != null) {
            return value.equalsIgnoreCase("true");
        }
        Attributes mainAttributes = manifest.getMainAttributes();
        String value2 = mainAttributes.getValue(Attributes.Name.SEALED);
        return value2 != null && value2.equalsIgnoreCase("true");
    }

    private ArrayList<URL> getInternalURLs(URL root, String classpath) {
        int jarIndex;
        StringTokenizer tokenizer = new StringTokenizer(classpath);
        ArrayList<URL> addedURLs = new ArrayList<URL>();
        String file = root.getFile();
        int index = file.lastIndexOf("/", jarIndex = file.lastIndexOf("!/") - 1) + 1;
        if (index == 0) {
            index = file.lastIndexOf(System.getProperty("file.separator"), jarIndex) + 1;
        }
        file = file.substring(0, index);
        while (tokenizer.hasMoreElements()) {
            String element = tokenizer.nextToken();
            if (element.isEmpty()) continue;
            try {
                URL url = new URL(new URL(file), element);
                addedURLs.add(this.createSearchURL(url));
            }
            catch (MalformedURLException e) {}
        }
        return addedURLs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class URLFileHandler
    extends URLHandler {
        private String prefix;

        public URLFileHandler(URL url) {
            super(url);
            String baseFile = url.getFile();
            String host = url.getHost();
            int hostLength = 0;
            if (host != null) {
                hostLength = host.length();
            }
            StringBuilder buf = new StringBuilder(2 + hostLength + baseFile.length());
            if (hostLength > 0) {
                buf.append("//").append(host);
            }
            buf.append(baseFile);
            this.prefix = buf.toString();
        }

        @Override
        Class<?> findClass(String packageName, String name, String origName) {
            String filename = this.prefix + name;
            try {
                filename = URLDecoder.decode(filename, "UTF-8");
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
            File file = new File(filename);
            if (file.exists()) {
                try {
                    FileInputStream is = new FileInputStream(file);
                    return this.createClass(is, packageName, origName);
                }
                catch (FileNotFoundException e) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        URL findResource(String name) {
            int idx;
            for (idx = 0; idx < name.length() && (name.charAt(idx) == '/' || name.charAt(idx) == '\\'); ++idx) {
            }
            if (idx > 0) {
                name = name.substring(idx);
            }
            try {
                String filename = URLDecoder.decode(this.prefix, "UTF-8") + name;
                if (new File(filename).exists()) {
                    return this.targetURL(this.url, name);
                }
                return null;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class URLJarHandler
    extends URLHandler {
        final JarFile jf;
        final String prefixName;
        final IndexFile index;
        final Map<URL, URLHandler> subHandlers;

        public URLJarHandler(URL url, URL jarURL, JarFile jf, String prefixName) {
            super(url);
            this.subHandlers = new HashMap<URL, URLHandler>();
            this.jf = jf;
            this.prefixName = prefixName;
            this.codeSourceUrl = jarURL;
            JarEntry je = jf.getJarEntry("META-INF/INDEX.LIST");
            this.index = je == null ? null : IndexFile.readIndexFile(jf, je, url);
        }

        public URLJarHandler(URL url, URL jarURL, JarFile jf, String prefixName, IndexFile index) {
            super(url);
            this.subHandlers = new HashMap<URL, URLHandler>();
            this.jf = jf;
            this.prefixName = prefixName;
            this.index = index;
            this.codeSourceUrl = jarURL;
        }

        IndexFile getIndex() {
            return this.index;
        }

        @Override
        void findResources(String name, ArrayList<URL> resources) {
            int pos;
            String indexedName;
            ArrayList<URL> urls;
            URL res = this.findResourceInOwn(name);
            if (res != null && !resources.contains(res)) {
                resources.add(res);
            }
            if (this.index != null && (urls = this.index.get(indexedName = (pos = name.lastIndexOf("/")) > 0 ? name.substring(0, pos) : name)) != null) {
                urls.remove(this.url);
                for (URL url : urls) {
                    URLHandler h = this.getSubHandler(url);
                    if (h == null) continue;
                    h.findResources(name, resources);
                }
            }
        }

        @Override
        Class<?> findClass(String packageName, String name, String origName) {
            ArrayList<URL> urls;
            String entryName = this.prefixName + name;
            JarEntry entry = this.jf.getJarEntry(entryName);
            if (entry != null) {
                try {
                    Manifest manifest = this.jf.getManifest();
                    return this.createClass(entry, manifest, packageName, origName);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (this.index != null && (urls = packageName == null ? this.index.get(name) : this.index.get(packageName)) != null) {
                urls.remove(this.url);
                for (URL url : urls) {
                    Class<?> res;
                    URLHandler h = this.getSubHandler(url);
                    if (h == null || (res = h.findClass(packageName, name, origName)) == null) continue;
                    return res;
                }
            }
            return null;
        }

        private Class<?> createClass(JarEntry entry, Manifest manifest, String packageName, String origName) {
            byte[] clBuf;
            try {
                InputStream is = this.jf.getInputStream(entry);
                clBuf = Streams.readFully(is);
            }
            catch (IOException e) {
                return null;
            }
            if (packageName != null) {
                String packageDotName = packageName.replace('/', '.');
                Package packageObj = URLClassLoader.this.getPackage(packageDotName);
                if (packageObj == null) {
                    if (manifest != null) {
                        URLClassLoader.this.definePackage(packageDotName, manifest, this.codeSourceUrl);
                    } else {
                        URLClassLoader.this.definePackage(packageDotName, null, null, null, null, null, null, null);
                    }
                } else {
                    boolean exception = packageObj.isSealed();
                    if (manifest != null && URLClassLoader.this.isSealed(manifest, packageName + "/")) {
                        boolean bl = exception = !packageObj.isSealed(this.codeSourceUrl);
                    }
                    if (exception) {
                        throw new SecurityException(String.format("Package %s is sealed", packageName));
                    }
                }
            }
            CodeSource codeS = new CodeSource(this.codeSourceUrl, entry.getCertificates());
            return URLClassLoader.this.defineClass(origName, clBuf, 0, clBuf.length, codeS);
        }

        URL findResourceInOwn(String name) {
            String entryName = this.prefixName + name;
            if (this.jf.getEntry(entryName) != null) {
                return this.targetURL(this.url, name);
            }
            return null;
        }

        @Override
        URL findResource(String name) {
            int pos;
            String indexedName;
            ArrayList<URL> urls;
            URL res = this.findResourceInOwn(name);
            if (res != null) {
                return res;
            }
            if (this.index != null && (urls = this.index.get(indexedName = (pos = name.lastIndexOf("/")) > 0 ? name.substring(0, pos) : name)) != null) {
                urls.remove(this.url);
                for (URL url : urls) {
                    URLHandler h = this.getSubHandler(url);
                    if (h == null || (res = h.findResource(name)) == null) continue;
                    return res;
                }
            }
            return null;
        }

        private synchronized URLHandler getSubHandler(URL url) {
            URLHandler sub = this.subHandlers.get(url);
            if (sub != null) {
                return sub;
            }
            String protocol = url.getProtocol();
            sub = protocol.equals("jar") ? URLClassLoader.this.createURLJarHandler(url) : (protocol.equals("file") ? this.createURLSubJarHandler(url) : URLClassLoader.this.createURLHandler(url));
            if (sub != null) {
                this.subHandlers.put(url, sub);
            }
            return sub;
        }

        private URLHandler createURLSubJarHandler(URL url) {
            String prefixName;
            String file = url.getFile();
            if (url.getFile().endsWith("!/")) {
                prefixName = "";
            } else {
                int sepIdx = file.lastIndexOf("!/");
                if (sepIdx == -1) {
                    return null;
                }
                prefixName = file.substring(sepIdx += 2);
            }
            try {
                URL jarURL = ((JarURLConnection)url.openConnection()).getJarFileURL();
                JarURLConnection juc = (JarURLConnection)new URL("jar", "", jarURL.toExternalForm() + "!/").openConnection();
                JarFile jf = juc.getJarFile();
                URLJarHandler jarH = new URLJarHandler(url, jarURL, jf, prefixName, null);
                return jarH;
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class URLHandler {
        URL url;
        URL codeSourceUrl;

        public URLHandler(URL url) {
            this.url = url;
            this.codeSourceUrl = url;
        }

        void findResources(String name, ArrayList<URL> resources) {
            URL res = this.findResource(name);
            if (res != null && !resources.contains(res)) {
                resources.add(res);
            }
        }

        Class<?> findClass(String packageName, String name, String origName) {
            URL resURL = this.targetURL(this.url, name);
            if (resURL != null) {
                try {
                    InputStream is = resURL.openStream();
                    return this.createClass(is, packageName, origName);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            return null;
        }

        Class<?> createClass(InputStream is, String packageName, String origName) {
            byte[] clBuf;
            if (is == null) {
                return null;
            }
            try {
                clBuf = Streams.readFully(is);
            }
            catch (IOException e) {
                return null;
            }
            if (packageName != null) {
                String packageDotName = packageName.replace('/', '.');
                Package packageObj = URLClassLoader.this.getPackage(packageDotName);
                if (packageObj == null) {
                    URLClassLoader.this.definePackage(packageDotName, null, null, null, null, null, null, null);
                } else if (packageObj.isSealed()) {
                    throw new SecurityException("Package is sealed");
                }
            }
            return URLClassLoader.this.defineClass(origName, clBuf, 0, clBuf.length, new CodeSource(this.codeSourceUrl, (Certificate[])null));
        }

        URL findResource(String name) {
            URL resURL = this.targetURL(this.url, name);
            if (resURL != null) {
                try {
                    URLConnection uc = resURL.openConnection();
                    uc.getInputStream().close();
                    if (!resURL.getProtocol().equals("http")) {
                        return resURL;
                    }
                    int code = ((HttpURLConnection)uc).getResponseCode();
                    if (code >= 200 && code < 300) {
                        return resURL;
                    }
                }
                catch (SecurityException e) {
                    return null;
                }
                catch (IOException e) {
                    return null;
                }
            }
            return null;
        }

        URL targetURL(URL base, String name) {
            try {
                StringBuilder fileBuilder = new StringBuilder();
                fileBuilder.append(base.getFile());
                URI.PATH_ENCODER.appendEncoded(fileBuilder, name);
                String file = fileBuilder.toString();
                return new URL(base.getProtocol(), base.getHost(), base.getPort(), file, null);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IndexFile {
        private HashMap<String, ArrayList<URL>> map;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        static IndexFile readIndexFile(JarFile jf, JarEntry indexEntry, URL url) {
            block15: {
                InputStream is;
                BufferedReader in;
                block14: {
                    IndexFile indexFile;
                    HashMap<String, ArrayList<URL>> pre_map;
                    String prefix;
                    block13: {
                        block12: {
                            in = null;
                            is = null;
                            String parentURLString = IndexFile.getParentURL(url).toExternalForm();
                            prefix = "jar:" + parentURLString + "/";
                            is = jf.getInputStream(indexEntry);
                            in = new BufferedReader(new InputStreamReader(is, Charsets.UTF_8));
                            pre_map = new HashMap<String, ArrayList<URL>>();
                            if (in.readLine() != null) break block12;
                            IndexFile indexFile2 = null;
                            IoUtils.closeQuietly(in);
                            IoUtils.closeQuietly(is);
                            return indexFile2;
                        }
                        if (in.readLine() != null) break block13;
                        IndexFile indexFile3 = null;
                        IoUtils.closeQuietly(in);
                        IoUtils.closeQuietly(is);
                        return indexFile3;
                    }
                    try {
                        String line;
                        block8: while ((line = in.readLine()) != null) {
                            URL jar = new URL(prefix + line + "!/");
                            while ((line = in.readLine()) != null) {
                                ArrayList<Object> list;
                                if (line.isEmpty()) continue block8;
                                if (pre_map.containsKey(line)) {
                                    list = pre_map.get(line);
                                } else {
                                    list = new ArrayList();
                                    pre_map.put(line, list);
                                }
                                list.add(jar);
                            }
                            break block8;
                        }
                        if (pre_map.isEmpty()) break block14;
                        indexFile = new IndexFile(pre_map);
                    }
                    catch (MalformedURLException e) {
                        IoUtils.closeQuietly(in);
                        IoUtils.closeQuietly(is);
                        break block15;
                    }
                    catch (IOException e2) {
                        IoUtils.closeQuietly(in);
                        IoUtils.closeQuietly(is);
                        break block15;
                        {
                            catch (Throwable throwable) {
                                IoUtils.closeQuietly(in);
                                IoUtils.closeQuietly(is);
                                throw throwable;
                            }
                        }
                    }
                    IoUtils.closeQuietly(in);
                    IoUtils.closeQuietly(is);
                    return indexFile;
                }
                IoUtils.closeQuietly(in);
                IoUtils.closeQuietly(is);
            }
            return null;
        }

        private static URL getParentURL(URL url) throws IOException {
            URL fileURL = ((JarURLConnection)url.openConnection()).getJarFileURL();
            String file = fileURL.getFile();
            String parentFile = new File(file).getParent();
            if ((parentFile = parentFile.replace(File.separatorChar, '/')).charAt(0) != '/') {
                parentFile = "/" + parentFile;
            }
            URL parentURL = new URL(fileURL.getProtocol(), fileURL.getHost(), fileURL.getPort(), parentFile);
            return parentURL;
        }

        public IndexFile(HashMap<String, ArrayList<URL>> map) {
            this.map = map;
        }

        ArrayList<URL> get(String name) {
            return this.map.get(name);
        }
    }
}

