/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.CharToByteBufferAdapter;
import java.nio.DoubleBuffer;
import java.nio.DoubleToByteBufferAdapter;
import java.nio.FloatBuffer;
import java.nio.FloatToByteBufferAdapter;
import java.nio.IntBuffer;
import java.nio.IntToByteBufferAdapter;
import java.nio.LongBuffer;
import java.nio.LongToByteBufferAdapter;
import java.nio.MemoryBlock;
import java.nio.ShortBuffer;
import java.nio.ShortToByteBufferAdapter;

abstract class BaseByteBuffer
extends ByteBuffer {
    protected BaseByteBuffer(int capacity, MemoryBlock block) {
        super(capacity, block);
    }

    public final CharBuffer asCharBuffer() {
        return CharToByteBufferAdapter.asCharBuffer(this);
    }

    public final DoubleBuffer asDoubleBuffer() {
        return DoubleToByteBufferAdapter.asDoubleBuffer(this);
    }

    public final FloatBuffer asFloatBuffer() {
        return FloatToByteBufferAdapter.asFloatBuffer(this);
    }

    public final IntBuffer asIntBuffer() {
        return IntToByteBufferAdapter.asIntBuffer(this);
    }

    public final LongBuffer asLongBuffer() {
        return LongToByteBufferAdapter.asLongBuffer(this);
    }

    public final ShortBuffer asShortBuffer() {
        return ShortToByteBufferAdapter.asShortBuffer(this);
    }

    public char getChar() {
        return (char)this.getShort();
    }

    public char getChar(int index) {
        return (char)this.getShort(index);
    }

    public ByteBuffer putChar(char value) {
        return this.putShort((short)value);
    }

    public ByteBuffer putChar(int index, char value) {
        return this.putShort(index, (short)value);
    }
}

