/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.CharBuffer;

abstract class CharArrayBuffer
extends CharBuffer {
    protected final char[] backingArray;
    protected final int offset;

    CharArrayBuffer(char[] array) {
        this(array.length, array, 0);
    }

    CharArrayBuffer(int capacity) {
        this(capacity, new char[capacity], 0);
    }

    CharArrayBuffer(int capacity, char[] backingArray, int offset) {
        super(capacity);
        this.backingArray = backingArray;
        this.offset = offset;
    }

    public final char get() {
        if (this.position == this.limit) {
            throw new BufferUnderflowException();
        }
        return this.backingArray[this.offset + this.position++];
    }

    public final char get(int index) {
        this.checkIndex(index);
        return this.backingArray[this.offset + index];
    }

    public final CharBuffer get(char[] dst, int srcOffset, int charCount) {
        if (charCount > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.backingArray, this.offset + this.position, dst, srcOffset, charCount);
        this.position += charCount;
        return this;
    }

    public final boolean isDirect() {
        return false;
    }

    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }

    public final CharSequence subSequence(int start, int end) {
        this.checkStartEndRemaining(start, end);
        CharBuffer result = this.duplicate();
        result.limit(this.position + end);
        result.position(this.position + start);
        return result;
    }

    public final String toString() {
        return String.copyValueOf(this.backingArray, this.offset + this.position, this.remaining());
    }
}

