/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DirectByteBuffer;
import java.nio.HeapByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.ReadWriteDirectByteBuffer;
import java.nio.ReadWriteHeapByteBuffer;

final class CharToByteBufferAdapter
extends CharBuffer {
    private final ByteBuffer byteBuffer;

    static CharBuffer asCharBuffer(ByteBuffer byteBuffer) {
        ByteBuffer slice = byteBuffer.slice();
        slice.order(byteBuffer.order());
        return new CharToByteBufferAdapter(slice);
    }

    private CharToByteBufferAdapter(ByteBuffer byteBuffer) {
        super(byteBuffer.capacity() / 2);
        this.byteBuffer = byteBuffer;
        this.byteBuffer.clear();
        this.effectiveDirectAddress = byteBuffer.effectiveDirectAddress;
    }

    public CharBuffer asReadOnlyBuffer() {
        CharToByteBufferAdapter buf = new CharToByteBufferAdapter(this.byteBuffer.asReadOnlyBuffer());
        buf.limit = this.limit;
        buf.position = this.position;
        buf.mark = this.mark;
        buf.byteBuffer.order = this.byteBuffer.order;
        return buf;
    }

    public CharBuffer compact() {
        if (this.byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        this.byteBuffer.limit(this.limit * 2);
        this.byteBuffer.position(this.position * 2);
        this.byteBuffer.compact();
        this.byteBuffer.clear();
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    public CharBuffer duplicate() {
        ByteBuffer bb = this.byteBuffer.duplicate().order(this.byteBuffer.order());
        CharToByteBufferAdapter buf = new CharToByteBufferAdapter(bb);
        buf.limit = this.limit;
        buf.position = this.position;
        buf.mark = this.mark;
        return buf;
    }

    public char get() {
        if (this.position == this.limit) {
            throw new BufferUnderflowException();
        }
        return this.byteBuffer.getChar(this.position++ * 2);
    }

    public char get(int index) {
        this.checkIndex(index);
        return this.byteBuffer.getChar(index * 2);
    }

    public CharBuffer get(char[] dst, int dstOffset, int charCount) {
        this.byteBuffer.limit(this.limit * 2);
        this.byteBuffer.position(this.position * 2);
        if (this.byteBuffer instanceof DirectByteBuffer) {
            ((DirectByteBuffer)this.byteBuffer).get(dst, dstOffset, charCount);
        } else {
            ((HeapByteBuffer)this.byteBuffer).get(dst, dstOffset, charCount);
        }
        this.position += charCount;
        return this;
    }

    public boolean isDirect() {
        return this.byteBuffer.isDirect();
    }

    public boolean isReadOnly() {
        return this.byteBuffer.isReadOnly();
    }

    public ByteOrder order() {
        return this.byteBuffer.order();
    }

    protected char[] protectedArray() {
        throw new UnsupportedOperationException();
    }

    protected int protectedArrayOffset() {
        throw new UnsupportedOperationException();
    }

    protected boolean protectedHasArray() {
        return false;
    }

    public CharBuffer put(char c) {
        if (this.position == this.limit) {
            throw new BufferOverflowException();
        }
        this.byteBuffer.putChar(this.position++ * 2, c);
        return this;
    }

    public CharBuffer put(int index, char c) {
        this.checkIndex(index);
        this.byteBuffer.putChar(index * 2, c);
        return this;
    }

    public CharBuffer put(char[] src, int srcOffset, int charCount) {
        this.byteBuffer.limit(this.limit * 2);
        this.byteBuffer.position(this.position * 2);
        if (this.byteBuffer instanceof ReadWriteDirectByteBuffer) {
            ((ReadWriteDirectByteBuffer)this.byteBuffer).put(src, srcOffset, charCount);
        } else {
            ((ReadWriteHeapByteBuffer)this.byteBuffer).put(src, srcOffset, charCount);
        }
        this.position += charCount;
        return this;
    }

    public CharBuffer slice() {
        this.byteBuffer.limit(this.limit * 2);
        this.byteBuffer.position(this.position * 2);
        ByteBuffer bb = this.byteBuffer.slice().order(this.byteBuffer.order());
        CharToByteBufferAdapter result = new CharToByteBufferAdapter(bb);
        this.byteBuffer.clear();
        return result;
    }

    public CharSequence subSequence(int start, int end) {
        this.checkStartEndRemaining(start, end);
        CharBuffer result = this.duplicate();
        result.limit(this.position + end);
        result.position(this.position + start);
        return result;
    }
}

