/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BaseByteBuffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.MemoryBlock;

abstract class DirectByteBuffer
extends BaseByteBuffer {
    protected final int offset;

    protected DirectByteBuffer(MemoryBlock block, int capacity, int offset) {
        super(capacity, block);
        long baseSize = block.getSize();
        if (baseSize >= 0L && (long)(capacity + offset) > baseSize) {
            throw new IllegalArgumentException("capacity + offset > baseSize");
        }
        this.offset = offset;
        this.effectiveDirectAddress = block.toInt() + offset;
    }

    public final ByteBuffer get(byte[] dst, int dstOffset, int byteCount) {
        this.checkGetBounds(1, dst.length, dstOffset, byteCount);
        this.block.peekByteArray(this.offset + this.position, dst, dstOffset, byteCount);
        this.position += byteCount;
        return this;
    }

    final void get(char[] dst, int dstOffset, int charCount) {
        int byteCount = this.checkGetBounds(2, dst.length, dstOffset, charCount);
        this.block.peekCharArray(this.offset + this.position, dst, dstOffset, charCount, this.order.needsSwap);
        this.position += byteCount;
    }

    final void get(double[] dst, int dstOffset, int doubleCount) {
        int byteCount = this.checkGetBounds(8, dst.length, dstOffset, doubleCount);
        this.block.peekDoubleArray(this.offset + this.position, dst, dstOffset, doubleCount, this.order.needsSwap);
        this.position += byteCount;
    }

    final void get(float[] dst, int dstOffset, int floatCount) {
        int byteCount = this.checkGetBounds(4, dst.length, dstOffset, floatCount);
        this.block.peekFloatArray(this.offset + this.position, dst, dstOffset, floatCount, this.order.needsSwap);
        this.position += byteCount;
    }

    final void get(int[] dst, int dstOffset, int intCount) {
        int byteCount = this.checkGetBounds(4, dst.length, dstOffset, intCount);
        this.block.peekIntArray(this.offset + this.position, dst, dstOffset, intCount, this.order.needsSwap);
        this.position += byteCount;
    }

    final void get(long[] dst, int dstOffset, int longCount) {
        int byteCount = this.checkGetBounds(8, dst.length, dstOffset, longCount);
        this.block.peekLongArray(this.offset + this.position, dst, dstOffset, longCount, this.order.needsSwap);
        this.position += byteCount;
    }

    final void get(short[] dst, int dstOffset, int shortCount) {
        int byteCount = this.checkGetBounds(2, dst.length, dstOffset, shortCount);
        this.block.peekShortArray(this.offset + this.position, dst, dstOffset, shortCount, this.order.needsSwap);
        this.position += byteCount;
    }

    public final byte get() {
        if (this.position == this.limit) {
            throw new BufferUnderflowException();
        }
        return this.block.peekByte(this.offset + this.position++);
    }

    public final byte get(int index) {
        this.checkIndex(index);
        return this.block.peekByte(this.offset + index);
    }

    public final char getChar() {
        int newPosition = this.position + 2;
        if (newPosition > this.limit) {
            throw new BufferUnderflowException();
        }
        char result = (char)this.block.peekShort(this.offset + this.position, this.order);
        this.position = newPosition;
        return result;
    }

    public final char getChar(int index) {
        this.checkIndex(index, 2);
        return (char)this.block.peekShort(this.offset + index, this.order);
    }

    public final double getDouble() {
        int newPosition = this.position + 8;
        if (newPosition > this.limit) {
            throw new BufferUnderflowException();
        }
        double result = Double.longBitsToDouble(this.block.peekLong(this.offset + this.position, this.order));
        this.position = newPosition;
        return result;
    }

    public final double getDouble(int index) {
        this.checkIndex(index, 8);
        return Double.longBitsToDouble(this.block.peekLong(this.offset + index, this.order));
    }

    public final float getFloat() {
        int newPosition = this.position + 4;
        if (newPosition > this.limit) {
            throw new BufferUnderflowException();
        }
        float result = Float.intBitsToFloat(this.block.peekInt(this.offset + this.position, this.order));
        this.position = newPosition;
        return result;
    }

    public final float getFloat(int index) {
        this.checkIndex(index, 4);
        return Float.intBitsToFloat(this.block.peekInt(this.offset + index, this.order));
    }

    public final int getInt() {
        int newPosition = this.position + 4;
        if (newPosition > this.limit) {
            throw new BufferUnderflowException();
        }
        int result = this.block.peekInt(this.offset + this.position, this.order);
        this.position = newPosition;
        return result;
    }

    public final int getInt(int index) {
        this.checkIndex(index, 4);
        return this.block.peekInt(this.offset + index, this.order);
    }

    public final long getLong() {
        int newPosition = this.position + 8;
        if (newPosition > this.limit) {
            throw new BufferUnderflowException();
        }
        long result = this.block.peekLong(this.offset + this.position, this.order);
        this.position = newPosition;
        return result;
    }

    public final long getLong(int index) {
        this.checkIndex(index, 8);
        return this.block.peekLong(this.offset + index, this.order);
    }

    public final short getShort() {
        int newPosition = this.position + 2;
        if (newPosition > this.limit) {
            throw new BufferUnderflowException();
        }
        short result = this.block.peekShort(this.offset + this.position, this.order);
        this.position = newPosition;
        return result;
    }

    public final short getShort(int index) {
        this.checkIndex(index, 2);
        return this.block.peekShort(this.offset + index, this.order);
    }

    public final boolean isDirect() {
        return true;
    }

    public final void free() {
        this.block.free();
    }

    protected byte[] protectedArray() {
        byte[] array = this.block.array();
        if (array == null) {
            throw new UnsupportedOperationException();
        }
        return array;
    }

    protected int protectedArrayOffset() {
        this.protectedArray();
        return this.offset;
    }

    protected boolean protectedHasArray() {
        return this.protectedArray() != null;
    }
}

