/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;

abstract class DoubleArrayBuffer
extends DoubleBuffer {
    protected final double[] backingArray;
    protected final int offset;

    DoubleArrayBuffer(double[] array) {
        this(array.length, array, 0);
    }

    DoubleArrayBuffer(int capacity) {
        this(capacity, new double[capacity], 0);
    }

    DoubleArrayBuffer(int capacity, double[] backingArray, int offset) {
        super(capacity);
        this.backingArray = backingArray;
        this.offset = offset;
    }

    public final double get() {
        if (this.position == this.limit) {
            throw new BufferUnderflowException();
        }
        return this.backingArray[this.offset + this.position++];
    }

    public final double get(int index) {
        this.checkIndex(index);
        return this.backingArray[this.offset + index];
    }

    public final DoubleBuffer get(double[] dst, int dstOffset, int doubleCount) {
        if (doubleCount > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.backingArray, this.offset + this.position, dst, dstOffset, doubleCount);
        this.position += doubleCount;
        return this;
    }

    public final boolean isDirect() {
        return false;
    }

    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

